/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.header;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import javax.swing.UIManager;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.painter.AbstractPainter;
import oracle.bali.ewt.painter.ImagePainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;

public class CBHeaderItemPainter
extends AbstractPainter
implements ImageObserver {
    private static int _OFFSET = 4;
    private static final String IMAGE_PATH = "/oracle/bali/dbUI/header/images/";
    static Image _activeImage;
    static Image _inactiveImage;
    static Image _armedImage;
    static Image _rollOverImage;
    static Image _activeArmedImage;
    private boolean _active;
    private boolean _armed;
    private boolean _rollover;
    private Painter _painter;
    private Painter _totalPainter;

    public CBHeaderItemPainter() {
        this(null);
    }

    public CBHeaderItemPainter(Painter painter) {
        if (_activeImage == null) {
            _armedImage = _activeImage = ImageUtils.getImageResource(this.getClass(), (String)"/oracle/bali/dbUI/header/images/active.gif");
            _inactiveImage = ImageUtils.getImageResource(this.getClass(), (String)"/oracle/bali/dbUI/header/images/inactive.gif");
            _rollOverImage = ImageUtils.getImageResource(this.getClass(), (String)"/oracle/bali/dbUI/header/images/rollover.gif");
            _activeArmedImage = ImageUtils.getImageResource(this.getClass(), (String)"/oracle/bali/dbUI/header/images/armed.gif");
        }
        this.setPainter(painter);
    }

    public Dimension getMinimumSize(PaintContext context) {
        return this._totalPainter.getMinimumSize(context);
    }

    public int getRepaintFlags(PaintContext context) {
        return this._totalPainter.getRepaintFlags(context);
    }

    public void setPainter(Painter painter) {
        if (painter == null) {
            painter = (Painter)UIManager.get("Header.DefaultHeaderPainter");
        }
        if (this._painter != painter) {
            this._painter = painter;
            this._totalPainter = new Total(this._painter, (Painter)new Img());
        }
    }

    public Painter getPainter() {
        if (this._painter == null) {
            this._painter = (Painter)UIManager.get("Header.DefaultHeaderPainter");
        }
        return this._painter;
    }

    public boolean isActiveAreaArmed() {
        return this._armed;
    }

    public void setActiveAreaArmed(boolean armed) {
        if (armed != this.isActiveAreaArmed()) {
            this._armed = armed;
        }
    }

    public boolean isActive() {
        return this._active;
    }

    public void setRollover(boolean rollover) {
        if (this.isRollover() != rollover) {
            this._rollover = rollover;
        }
    }

    public boolean isRollover() {
        return this._rollover;
    }

    public void setActive(boolean active) {
        if (this.isActive() != active) {
            this._active = active;
        }
    }

    public boolean pointInActiveArea(int itemWidth, int itemHeight, int x, int y) {
        Image image;
        Image image2 = image = this.isActive() ? this.getActiveImage() : this.getInactiveImage();
        if (image == null) {
            return false;
        }
        int width = image.getWidth(this);
        int height = image.getHeight(this);
        int testX = itemWidth - (width += _OFFSET + 1);
        return x >= testX && x <= itemWidth && y >= 0 && y <= itemHeight;
    }

    public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
        this._totalPainter.paint(context, g, x, y, width, height);
    }

    @Override
    public synchronized boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        return false;
    }

    protected Image getActiveImage() {
        return _activeImage;
    }

    protected Image getInactiveImage() {
        return _inactiveImage;
    }

    private class Total
    extends AbstractPainter {
        private Painter _left;
        private Painter _right;

        public Total(Painter left, Painter right) {
            this._left = left;
            this._right = right;
        }

        public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
            boolean l2r;
            Dimension size = this._right.getPreferredSize(context);
            boolean bl = l2r = context.getReadingDirection() == 1;
            if (l2r) {
                int rightX = width - size.width - 3;
                this._right.paint(context, g, x + rightX, y, size.width, height);
                this._left.paint(context, g, x, y, rightX - 1, height);
            } else {
                int leftX = x + size.width;
                this._right.paint(context, g, leftX, y, size.width, height);
                int rightWidth = width - (leftX + 3);
                this._left.paint(context, g, leftX + 3, y, rightWidth, height);
            }
        }

        public Dimension getMinimumSize(PaintContext context) {
            Dimension left = this._left.getMinimumSize(context);
            Dimension right = this._right.getMinimumSize(context);
            if (left.height > right.height) {
                right.height = left.height;
            }
            right.width += left.width;
            return right;
        }
    }

    private class Img
    extends ImagePainter {
        private Img() {
        }

        protected Image getImageData(PaintContext context) {
            boolean armed = CBHeaderItemPainter.this.isActiveAreaArmed();
            boolean active = CBHeaderItemPainter.this.isActive();
            Image image = null;
            image = armed && active ? _activeArmedImage : (armed ? _armedImage : (active ? CBHeaderItemPainter.this.getActiveImage() : (CBHeaderItemPainter.this.isRollover() ? _rollOverImage : CBHeaderItemPainter.this.getInactiveImage())));
            return image;
        }

        public boolean isTransparent(PaintContext context) {
            return true;
        }
    }
}

