/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.constraintComponent;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Locale;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.UIManager;
import oracle.bali.dbUI.constraint.DCExpression;
import oracle.bali.dbUI.constraint.DCVariable;
import oracle.bali.dbUI.constraint.DataConstraint;
import oracle.bali.dbUI.constraintComponent.ConstraintCompFactory;
import oracle.bali.dbUI.constraintComponent.ConstraintComponent;
import oracle.bali.dbUI.constraintComponent.MDCJDKDropSupport;
import oracle.bali.dbUI.constraintComponent.MultiLayoutManager;
import oracle.bali.dbUI.db.Column;
import oracle.bali.dbUI.db.DataDescriptor;
import oracle.bali.dbUI.db.DataDescriptorProvider;
import oracle.bali.dbUI.dnd.DBUIDataFlavors;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.dnd.DropTarget;
import oracle.bali.ewt.dnd.DropTargetContext;
import oracle.bali.ewt.dnd.DropTargetDragEvent;
import oracle.bali.ewt.dnd.DropTargetDropEvent;
import oracle.bali.ewt.dnd.DropTargetEvent;
import oracle.bali.ewt.dnd.DropTargetListener;
import oracle.bali.ewt.dnd.JFCSupport;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.FixedBorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.util.LocaleUtils;
import oracle.bali.share.datatransfer.TransferUtils;

public class MultiDescriptorComponent
extends LWComponent
implements ConstraintComponent,
Accessible {
    public static final String PROPERTY_DATA_DESCRIPTOR = "dataDescriptor";
    protected static final DataDescriptor EMPTY_DESCRIPTOR = new DataDescriptor(){

        @Override
        public String getName() {
            return MultiDescriptorComponent._sDEFAULT_VALUE;
        }

        @Override
        public Class getDataType() {
            return Object.class;
        }
    };
    private static BorderPainter _sBorderPainter;
    private static final String _sDEFAULT_VALUE = "";
    private static final int _sNOT_QUALIFIED = 0;
    private static final int _sTABLE_QUALIFIED = 1;
    private static final int _sSCHEMA_QUALIFIED = 2;
    boolean _defaulted;
    private Color _background;
    private Color _foreground;
    JComboBox _item;
    private int _itemWidth;
    private PropertyChangeListener _propListen;
    private DataDescriptor _originalDescriptor;
    private DataDescriptor _selectedDescriptorAfterChange;
    private DataDescriptor _selectedDescriptor;
    private DataDescriptorProvider _provider;
    private ConstraintComponent _constraintComponent;
    private DataConstraint _oldValue;
    private boolean _ignoreSelectionChanges = false;
    private DataDescriptor _oldDescriptorValue;
    private int _qualificationLevel = 0;
    private boolean _isDescriptorListChanged;
    private DropTargetListener _dropListener;
    private boolean _jdkDnD;

    public MultiDescriptorComponent() {
        this(null);
    }

    public MultiDescriptorComponent(DataDescriptorProvider provider) {
        Item listener = new Item();
        this._item = this.createDescriptorSelector();
        this._item.addItemListener(listener);
        this._dropListener = new B();
        DropTarget dummy = new DropTarget((Component)this._item, this._dropListener);
        dummy = new DropTarget(this._item.getEditor().getEditorComponent(), this._dropListener);
        this.setLayout(new MultiLayoutManager());
        this.add("item", this._item);
        this._propListen = new Update();
        this._constraintComponent = this.getConstraintComponent(EMPTY_DESCRIPTOR);
        this._constraintComponent.addPropertyChangeListener(this._propListen);
        this.addPropertyChangeListener(new UpdateOnSelection());
        this.add("component", this._constraintComponent.getComponent());
        this.setBackground(UIManager.getColor("control"));
        this.setDataDescriptorProvider(provider);
    }

    public void enableJDKDnD() {
        if (!this._jdkDnD) {
            this._jdkDnD = true;
            DropTarget dummy = JFCSupport.getEWTDropTarget((JComponent)this._item);
            if (dummy != null) {
                dummy.setComponent(null);
                dummy.removeDropTargetListener(this._dropListener);
            }
            if ((dummy = JFCSupport.getEWTDropTarget((JComponent)((JComponent)this._item.getEditor().getEditorComponent()))) != null) {
                dummy.setComponent(null);
                dummy.removeDropTargetListener(this._dropListener);
            }
            dummy = null;
            new MDCJDKDropSupport(this, this._item);
        }
    }

    public void setDataDescriptorProvider(DataDescriptorProvider provider) {
        if (this._provider != provider) {
            if (this._provider != null) {
                this._provider.removePropertyChangeListener(this._propListen);
            }
            this._provider = provider;
            if (this._provider != null) {
                this._provider.addPropertyChangeListener(this._propListen);
            }
            this.setItemWidth(0);
            this.setChoiceItems(LocaleUtils.getDefaultableLocale((Component)((Object)this)));
        }
    }

    public DataDescriptorProvider getDataDescriptorProvider() {
        return this._provider;
    }

    public void fireDataConstraintChange() {
        DataConstraint newValue = this.getDataConstraint();
        this.firePropertyChange("dataConstraint", this._oldValue, newValue);
        this._oldValue = newValue;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public DataConstraint getDataConstraint() {
        return this.getConstraintComponent().getDataConstraint();
    }

    @Override
    public DataDescriptor getDataDescriptor() {
        return this._selectedDescriptor;
    }

    @Override
    public void initState(DataDescriptor descriptor, DataConstraint dataConstraint) {
        this._oldValue = dataConstraint;
        this._originalDescriptor = descriptor;
        this._selectedDescriptor = descriptor;
        this._initState(dataConstraint, LocaleUtils.getDefaultableLocale((Component)((Object)this)));
    }

    public void setSelectedDescriptor(DataDescriptor descriptor) {
        this._selectedDescriptor = descriptor;
        this.selectedItemChanged();
    }

    public Dimension getMinimumSize() {
        return this._item.getMinimumSize();
    }

    public void requestFocus() {
        this._item.requestFocus();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this._item.setEnabled(enabled);
        this.getConstraintComponent().getComponent().setEnabled(enabled);
    }

    public void paintComponent(Graphics g) {
        Dimension size = this.getSize();
        PaintContext context = this.getPaintContext();
        g.setColor(context.getPaintBackground());
        g.fillRect(0, 0, size.width, size.height);
    }

    public BorderPainter getBorderPainter() {
        if (_sBorderPainter == null) {
            _sBorderPainter = new FixedBorderPainter(1, 0, 1, 1);
        }
        return _sBorderPainter;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new JComponent.AccessibleJComponent(){};
        }
        return this.accessibleContext;
    }

    protected ConstraintComponent getConstraintComponent() {
        return this._constraintComponent;
    }

    protected ConstraintComponent getConstraintComponent(DataDescriptor descriptor) {
        return ConstraintCompFactory.getConstraintCompFactory().createConstraintComponent(null, descriptor, null);
    }

    protected int getItemPreferredWidth() {
        return this._item.getPreferredSize().width;
    }

    protected void setItemWidth(int width) {
        if (this._itemWidth != width) {
            this._itemWidth = width;
            this.invalidate();
        }
    }

    protected int getItemWidth() {
        if (this._itemWidth == 0) {
            this._itemWidth = this.getItemPreferredWidth();
        }
        return this._itemWidth;
    }

    protected void selectedItemChanged() {
        if (this._ignoreSelectionChanges) {
            return;
        }
        DataDescriptor oldItem = this._selectedDescriptor;
        DataDescriptor newItem = null;
        int index = this._item.getSelectedIndex();
        if (this._defaulted) {
            if (index == 0) {
                return;
            }
            --index;
        }
        if (this._provider != null && index >= 0) {
            int count = this._provider.getDescriptorCount();
            if (index < count) {
                newItem = this._provider.getDescriptor(index);
            } else if (index == count) {
                newItem = this._selectedDescriptorAfterChange != null ? this._selectedDescriptorAfterChange : this._originalDescriptor;
            } else if (index == count + 1) {
                newItem = this._originalDescriptor;
            }
        }
        if (newItem == null) {
            newItem = this._selectedDescriptor;
        }
        this._selectedDescriptor = newItem;
        if (this._selectedDescriptor != null && this._defaulted) {
            if (!this._item.isEditable()) {
                this._item.removeItem(_sDEFAULT_VALUE);
            }
            this._defaulted = false;
        }
        this.selectedDescriptorChanged(oldItem != this._selectedDescriptor);
        this.fireDataDescriptorChange();
    }

    protected void selectedDescriptorChanged(boolean reallyChanged) {
        ConstraintComponent newComp;
        if (reallyChanged && (newComp = this.getConstraintComponent(this._selectedDescriptor)) != this._constraintComponent) {
            this._constraintComponent.removePropertyChangeListener(this._propListen);
            this.remove(this._constraintComponent.getComponent());
            this._constraintComponent = newComp;
            this._constraintComponent.addPropertyChangeListener(this._propListen);
            this.add("component", this._constraintComponent.getComponent());
            this.invalidate();
        }
    }

    protected void setChoiceItems(Locale locale) {
        this._ignoreSelectionChanges = true;
        DataDescriptor old = this._selectedDescriptor;
        Vector<String> items = new Vector<String>(this._provider != null ? this._provider.getDescriptorCount() + 7 : 37);
        this._defaulted = false;
        boolean foundSelected = false;
        boolean foundOriginal = false;
        boolean isDescriptorListChanged = false;
        boolean clash = false;
        HashSet<String> noDups = new HashSet<String>();
        String toSelect = _sDEFAULT_VALUE;
        int qLevel = 0;
        String selectedName = this._selectedDescriptorAfterChange == null ? _sDEFAULT_VALUE : this._getQualifiedName(this._selectedDescriptorAfterChange, locale, 2);
        String originalName = this._originalDescriptor == null ? _sDEFAULT_VALUE : this._getQualifiedName(this._originalDescriptor, locale, 2);
        block0: do {
            String name;
            noDups.clear();
            items.clear();
            clash = false;
            if (this._provider != null) {
                for (int i = 0; i < this._provider.getDescriptorCount(); ++i) {
                    DataDescriptor desc = this._provider.getDescriptor(i);
                    name = this._getQualifiedName(desc, locale, qLevel);
                    if (qLevel < 2) {
                        boolean bl = clash = !noDups.add(name);
                        if (clash) {
                            ++qLevel;
                            continue block0;
                        }
                    }
                    items.addElement(name);
                    String descName = this._getQualifiedName(desc, locale, 2);
                    if (descName.equals(selectedName)) {
                        foundSelected = true;
                    }
                    if (!descName.equals(originalName)) continue;
                    foundOriginal = true;
                }
            }
            if (!foundSelected && this._selectedDescriptorAfterChange != null) {
                name = this._getQualifiedName(this._selectedDescriptorAfterChange, locale, qLevel);
                if (qLevel < 2) {
                    boolean bl = clash = !noDups.add(name);
                    if (clash) {
                        ++qLevel;
                        continue;
                    }
                }
                items.addElement(name);
                isDescriptorListChanged = true;
            } else if (!foundOriginal && this._originalDescriptor != null) {
                name = this._getQualifiedName(this._originalDescriptor, locale, qLevel);
                if (qLevel < 2) {
                    boolean bl = clash = !noDups.add(name);
                    if (clash) {
                        ++qLevel;
                        continue;
                    }
                }
                items.addElement(name);
                isDescriptorListChanged = true;
            }
            if (this._selectedDescriptor == null) {
                this._selectedDescriptor = this._selectedDescriptorAfterChange;
            }
            if (this._selectedDescriptor != null) {
                toSelect = name = this._getQualifiedName(this._selectedDescriptor, locale, qLevel);
                continue;
            }
            if (this._item.isEditable()) continue;
            items.insertElementAt(_sDEFAULT_VALUE, 0);
            this._defaulted = true;
        } while (clash);
        this._qualificationLevel = qLevel;
        this._isDescriptorListChanged = isDescriptorListChanged;
        ComboBoxModel model = this.createComboBoxModel(items);
        this._item.setModel(model);
        this._item.setSelectedItem(toSelect);
        this.selectedDescriptorChanged(old != this._selectedDescriptor);
        this._ignoreSelectionChanges = false;
    }

    protected JComboBox createDescriptorSelector() {
        return new DescriptorCombo();
    }

    protected JComboBox getDescriptorSelector() {
        return this._item;
    }

    protected void fireDataDescriptorChange() {
        DataDescriptor newValue = this.getDataDescriptor();
        this.firePropertyChange(PROPERTY_DATA_DESCRIPTOR, this._oldDescriptorValue, newValue);
        this._oldDescriptorValue = newValue;
    }

    protected ComboBoxModel createComboBoxModel(Vector items) {
        return new DefaultComboBoxModel(items);
    }

    boolean acceptDrag(DropTargetDragEvent dtde) {
        DataFlavor[] flavors = dtde.getCurrentDataFlavors();
        if (flavors == null) {
            return true;
        }
        return TransferUtils.supportsDataFlavor((DataFlavor[])flavors, (DataFlavor)DBUIDataFlavors.DATA_DESCRIPTOR_FLAVOR);
    }

    void dragEnter(Component comp) {
        this._background = comp.getBackground();
        this._foreground = comp.getForeground();
        comp.setBackground(this._foreground);
        comp.setForeground(this._background);
    }

    void dragExit(Component comp) {
        comp.setForeground(this._foreground);
        comp.setBackground(this._background);
    }

    void drop(Component comp, DataDescriptor data) {
        String name = this._getQualifiedName(data, LocaleUtils.getDefaultableLocale((Component)((Object)this)), this._qualificationLevel);
        this._item.setSelectedItem(name);
        this.selectedItemChanged();
        this.fireDataConstraintChange();
    }

    void updateItems() {
        this._selectedDescriptorAfterChange = this._selectedDescriptor;
        this.setChoiceItems(LocaleUtils.getDefaultableLocale((Component)((Object)this)));
        this.setItemWidth(0);
    }

    private void _initState(DataConstraint dc, Locale l) {
        if (dc == null) {
            this.selectedDescriptorChanged(true);
            this.setChoiceItems(l);
            this._initConstraintComponent(dc);
            return;
        }
        DCVariable variable = null;
        if (dc instanceof DCExpression) {
            DCExpression e = (DCExpression)dc;
            int count = e.getConstraintCount();
            for (int i = 0; i < count; ++i) {
                DataConstraint temp = e.getConstraint(i);
                if (!(temp instanceof DCVariable)) continue;
                variable = (DCVariable)temp;
                break;
            }
        }
        if (this._selectedDescriptor == null && variable != null) {
            this._selectedDescriptor = this._findDescriptor(variable.getVariable());
        }
        this.selectedDescriptorChanged(true);
        this.setChoiceItems(l);
        this._initConstraintComponent(dc);
    }

    private void _initConstraintComponent(DataConstraint dc) {
        this._constraintComponent.initState(this._selectedDescriptor, dc);
    }

    private DataDescriptor _findDescriptor(Object variable) {
        String name;
        Locale locale = LocaleUtils.getDefaultableLocale((Component)((Object)this));
        String string = variable instanceof Column ? this._getQualifiedName((Column)variable, locale, 2) : (name = variable instanceof String ? (String)variable : null);
        if (this._originalDescriptor != null && this._getQualifiedName(this._originalDescriptor, locale, 2).equals(name)) {
            return this._originalDescriptor;
        }
        if (this._selectedDescriptorAfterChange != null && this._getQualifiedName(this._selectedDescriptorAfterChange, locale, 2).equals(name)) {
            return this._selectedDescriptorAfterChange;
        }
        if (this._provider != null) {
            for (int i = 0; i < this._provider.getDescriptorCount(); ++i) {
                DataDescriptor temp = this._provider.getDescriptor(i);
                if (!this._getQualifiedName(temp, locale, 2).equals(name)) continue;
                return temp;
            }
        }
        return null;
    }

    private String _getQualifiedName(DataDescriptor d, Locale locale, int level) {
        Column column;
        Column column2 = column = d instanceof Column ? (Column)d : null;
        if (column == null || level == 0) {
            return d.getDisplayName(locale);
        }
        switch (level) {
            case 1: {
                return column.getTable().getDisplayName(locale) + "." + column.getDisplayName(locale);
            }
            case 2: {
                return column.getTable().getSchema().getDisplayName(locale) + "." + column.getTable().getDisplayName(locale) + "." + column.getDisplayName(locale);
            }
        }
        return d.getDisplayName(locale);
    }

    private class Item
    implements ItemListener {
        private Item() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getSource() == MultiDescriptorComponent.this._item) {
                MultiDescriptorComponent.this.selectedItemChanged();
            }
            if (!MultiDescriptorComponent.this._ignoreSelectionChanges) {
                MultiDescriptorComponent.this.fireDataConstraintChange();
            }
        }
    }

    private class B
    implements DropTargetListener {
        private B() {
        }

        public void dragEnter(DropTargetDragEvent dtde) {
            if (MultiDescriptorComponent.this.acceptDrag(dtde)) {
                MultiDescriptorComponent.this.dragEnter(dtde.getDropTargetContext().getComponent());
            } else {
                dtde.rejectDrag();
            }
        }

        public void dragOver(DropTargetDragEvent dtde) {
            if (!MultiDescriptorComponent.this.acceptDrag(dtde)) {
                dtde.rejectDrag();
            }
        }

        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        public void dragExit(DropTargetEvent dtde) {
            MultiDescriptorComponent.this.dragExit(dtde.getDropTargetContext().getComponent());
        }

        public void drop(DropTargetDropEvent dtde) {
            Component comp = dtde.getDropTargetContext().getComponent();
            MultiDescriptorComponent.this.dragExit(comp);
            DropTargetContext context = dtde.getDropTargetContext();
            dtde.acceptDrop(2);
            Transferable transfer = dtde.getTransferable();
            try {
                Object data = transfer.getTransferData(DBUIDataFlavors.DATA_DESCRIPTOR_FLAVOR);
                if (data instanceof DataDescriptor) {
                    context.dropComplete(true);
                    MultiDescriptorComponent.this.drop(comp, (DataDescriptor)data);
                } else {
                    context.dropComplete(false);
                }
            }
            catch (Exception e) {
                context.dropComplete(false);
            }
        }
    }

    private class Update
    implements PropertyChangeListener {
        private Update() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if ("dataConstraint".equals(prop)) {
                MultiDescriptorComponent.this.fireDataConstraintChange();
            } else if ("descriptorCount".equals(prop) || "descriptorChanged".equals(prop)) {
                MultiDescriptorComponent.this.updateItems();
            }
        }
    }

    private class UpdateOnSelection
    implements PropertyChangeListener {
        private UpdateOnSelection() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (MultiDescriptorComponent.PROPERTY_DATA_DESCRIPTOR.equals(e.getPropertyName()) && MultiDescriptorComponent.this._isDescriptorListChanged) {
                MultiDescriptorComponent.this.updateItems();
            }
        }
    }

    public class DescriptorCombo
    extends JComboBox {
        public DescriptorCombo() {
            this.setEditable(false);
        }

        @Override
        public void setPopupVisible(boolean visible) {
            if (MultiDescriptorComponent.this._defaulted && visible) {
                if (!MultiDescriptorComponent.this._item.isEditable()) {
                    this.removeItem(MultiDescriptorComponent._sDEFAULT_VALUE);
                }
                MultiDescriptorComponent.this._defaulted = false;
            }
            super.setPopupVisible(visible);
        }
    }
}

