/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.constraintComponent;

import java.util.Locale;
import java.util.ResourceBundle;
import oracle.bali.dbUI.constraint.DCComparisonExpression;
import oracle.bali.dbUI.constraint.DCConstant;
import oracle.bali.dbUI.constraint.DataConstraint;
import oracle.bali.dbUI.constraintComponent.BaseConstraintComponent;
import oracle.bali.dbUI.db.DataDescriptor;

public abstract class ComparisonConstraintComp
extends BaseConstraintComponent {
    public static final int CONDITION_GREATER_THAN = 100;
    public static final int CONDITION_LESS_THAN = 101;
    public static final int CONDITION_GREATER_THAN_OR_EQUAL_TO = 102;
    public static final int CONDITION_LESS_THAN_OR_EQUAL_TO = 103;
    private static final String _GREATER_KEY = "GREATER";
    private static final String _LESS_KEY = "LESS";
    private static final String _GREATER_OR_EQUAL_KEY = "GREATER_OR_EQUAL";
    private static final String _LESS_OR_EQUAL_KEY = "LESS_OR_EQUAL";
    private static final int _GREATER_INDEX = 2;
    private static final int _LESS_INDEX = 3;
    private static final int _GREATER_OR_EQUAL_INDEX = 4;
    private static final int _LESS_OR_EQUAL_INDEX = 5;
    private static final int _STRING_COUNT = 4;

    public ComparisonConstraintComp() {
        this.setBetweenAllowed(true);
    }

    @Override
    protected boolean isConditionValid(int condition) {
        if (condition == 100 || condition == 101 || condition == 102 || condition == 103) {
            return true;
        }
        return super.isConditionValid(condition);
    }

    @Override
    protected int convertConditionToSelection(int condition) {
        int index = -1;
        switch (condition) {
            case 100: {
                index = 2;
                break;
            }
            case 101: {
                index = 3;
                break;
            }
            case 102: {
                index = 4;
                break;
            }
            case 103: {
                index = 5;
                break;
            }
            default: {
                index = super.convertConditionToSelection(condition);
            }
        }
        return index;
    }

    @Override
    protected int convertSelectionToCondition(int selection) {
        int condition = -1;
        switch (selection) {
            case 2: {
                condition = 100;
                break;
            }
            case 3: {
                condition = 101;
                break;
            }
            case 4: {
                condition = 102;
                break;
            }
            case 5: {
                condition = 103;
                break;
            }
            default: {
                condition = super.convertSelectionToCondition(selection);
            }
        }
        return condition;
    }

    @Override
    protected int getBaseBetweenIndex() {
        return super.getBaseBetweenIndex() + 4;
    }

    @Override
    protected int getBaseNullIndex() {
        return super.getBaseNullIndex() + 4;
    }

    @Override
    protected int getItemCount() {
        return super.getItemCount() + 4;
    }

    @Override
    protected String[] getChoiceValues(Locale locale) {
        ResourceBundle b = ResourceBundle.getBundle("oracle.bali.dbUI.resource.DBUIBundle", locale);
        String[] strings = super.getChoiceValues(locale);
        strings[2] = b.getString(_GREATER_KEY);
        strings[3] = b.getString(_LESS_KEY);
        strings[4] = b.getString(_GREATER_OR_EQUAL_KEY);
        strings[5] = b.getString(_LESS_OR_EQUAL_KEY);
        return strings;
    }

    @Override
    protected DataConstraint getDataConstraint(DataDescriptor descriptor, int condition) {
        DataConstraint d = null;
        DataConstraint value = this.getValueDataConstraint(this.getValueComponent(), descriptor, condition);
        DataConstraint item = this.getItemDataConstraint(descriptor, condition);
        switch (condition) {
            case 100: {
                int operand = 1;
                d = new DCComparisonExpression(value, item, operand);
                break;
            }
            case 101: {
                int operand = 2;
                d = new DCComparisonExpression(value, item, operand);
                break;
            }
            case 102: {
                int operand = 5;
                d = new DCComparisonExpression(value, item, operand);
                break;
            }
            case 103: {
                int operand = 6;
                d = new DCComparisonExpression(value, item, operand);
                break;
            }
            default: {
                d = super.getDataConstraint(descriptor, condition);
            }
        }
        return d;
    }

    @Override
    protected void parseConstraint(DataConstraint constraint) {
        if (constraint == null || !(constraint instanceof DCComparisonExpression)) {
            super.parseConstraint(constraint);
        } else {
            DCComparisonExpression compare = (DCComparisonExpression)constraint;
            int operand = compare.getOperand();
            if (operand == 3 || operand == 4) {
                super.parseConstraint(constraint);
            } else {
                DCComparisonExpression b = (DCComparisonExpression)constraint;
                int condition = -1;
                switch (b.getOperand()) {
                    case 1: {
                        condition = 100;
                        break;
                    }
                    case 2: {
                        condition = 101;
                        break;
                    }
                    case 5: {
                        condition = 102;
                        break;
                    }
                    case 6: {
                        condition = 103;
                    }
                }
                this.setTestCondition(condition);
                DCConstant value = this._getConstant(b.getConstraint(0), b.getConstraint(1));
                Object realValue = value == null ? null : value.getValue();
                this.initValueComponent(this.getValueComponent(), realValue);
            }
        }
    }

    @Override
    protected int getNotCondition(int condition) {
        switch (condition) {
            case 100: {
                condition = 103;
                break;
            }
            case 101: {
                condition = 102;
                break;
            }
            case 102: {
                condition = 101;
                break;
            }
            case 103: {
                condition = 100;
                break;
            }
            default: {
                condition = super.getNotCondition(condition);
            }
        }
        return condition;
    }

    private DCConstant _getConstant(DataConstraint c1, DataConstraint c2) {
        if (c1 instanceof DCConstant) {
            return (DCConstant)c1;
        }
        if (c2 instanceof DCConstant) {
            return (DCConstant)c2;
        }
        return null;
    }
}

