/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share.stylex;

import java.awt.Color;
import oracle.mapviewer.share.SizeDefinition;
import oracle.mapviewer.share.XMLUtil;
import oracle.mapviewer.share.style.AbstractStyleModel;
import oracle.mapviewer.share.style.StyleUtils;
import oracle.mapviewer.share.stylex.PieSliceInfo;

public class PieChartStyleModel
extends AbstractStyleModel {
    static final long serialVersionUID = 4490848579357926061L;
    SizeDefinition pieRadiusSize = new SizeDefinition(0.0, null);
    int numSlices = 0;
    PieSliceInfo[] pieSlices = null;
    Color strokeColor = Color.black;

    public PieChartStyleModel() {
        this.type = 9;
        this.pieSlices = new PieSliceInfo[0];
    }

    public PieChartStyleModel(int n, PieSliceInfo[] pieSliceInfoArray) {
        this.type = 9;
        if (n < 1 || pieSliceInfoArray == null || pieSliceInfoArray.length == 0) {
            throw new IllegalArgumentException("invalid argument(s).");
        }
        this.pieRadiusSize.setValue(n);
        this.pieSlices = pieSliceInfoArray;
        this.numSlices = pieSliceInfoArray.length;
    }

    @Override
    public Object clone() {
        PieChartStyleModel pieChartStyleModel = (PieChartStyleModel)super.clone();
        if (this.pieSlices != null) {
            pieChartStyleModel.pieSlices = new PieSliceInfo[this.pieSlices.length];
            for (int i = 0; i < this.pieSlices.length; ++i) {
                pieChartStyleModel.pieSlices[i] = new PieSliceInfo(this.pieSlices[i].name, this.pieSlices[i].color);
            }
        }
        pieChartStyleModel.setPieRadiusSize(this.pieRadiusSize);
        return pieChartStyleModel;
    }

    public SizeDefinition getPieRadiusSize() {
        return this.pieRadiusSize;
    }

    public void setPieRadiusSize(SizeDefinition sizeDefinition) {
        this.pieRadiusSize = new SizeDefinition(0.0, null);
        if (sizeDefinition == null) {
            return;
        }
        this.pieRadiusSize.setValue(sizeDefinition.getValue());
        this.pieRadiusSize.setUnit(sizeDefinition.getUnit());
    }

    @Override
    public String getTypeName() {
        return "ADVANCED";
    }

    @Override
    public String toXMLString() {
        String string = "";
        if (this.pieRadiusSize.getUnit() != null && !this.pieRadiusSize.getUnit().equalsIgnoreCase("px")) {
            string = this.pieRadiusSize.getUnit();
        }
        String string2 = StyleUtils.getUSLocaleFormat(this.pieRadiusSize.getValue());
        string2 = StyleUtils.cleanDecimalZeros(string2, 1);
        if (this.pieRadiusSize.isPixelUnit()) {
            string2 = String.valueOf((int)this.pieRadiusSize.getValue());
        }
        String string3 = "<?xml version=\"1.0\" ?>\n";
        string3 = string3 + "<AdvancedStyle>\n   <PieChartStyle";
        string3 = string3 + " pieradius=\"" + string2 + string + "\"";
        if (this.strokeColor != null && (this.strokeColor.getRed() != 0 || this.strokeColor.getGreen() != 0 || this.strokeColor.getBlue() != 0 || this.strokeColor.getAlpha() != 255)) {
            String string4 = " stroke=\"" + StyleUtils.getHexidecimalString(this.strokeColor) + "\"";
            int n = this.strokeColor.getAlpha();
            if (n < 255) {
                string4 = string4 + " stroke-opacity=\"" + n + "\"";
            }
            string3 = string3 + string4;
        }
        string3 = string3 + ">\n";
        if (this.pieSlices != null) {
            for (int i = 0; i < this.pieSlices.length; ++i) {
                PieSliceInfo pieSliceInfo = this.pieSlices[i];
                string3 = string3 + "       <PieSlice name=\"" + XMLUtil.replaceXMLEntities(pieSliceInfo.name) + "\"";
                if (pieSliceInfo.color != null) {
                    string3 = string3 + " color=\"" + StyleUtils.getHexidecimalString(pieSliceInfo.color) + "\"";
                }
                string3 = string3 + " />\n";
            }
        }
        string3 = string3 + "   </PieChartStyle>\n</AdvancedStyle>\n";
        return string3;
    }

    public void setPieRadius(int n) {
        this.pieRadiusSize.setValue(n);
    }

    public void setPieRadius(double d) {
        this.pieRadiusSize.setValue(d);
    }

    public int getPieRadius() {
        return (int)this.pieRadiusSize.getValue();
    }

    public double getDoublePieRadius() {
        return this.pieRadiusSize.getValue();
    }

    public String getPieRadiusUnit() {
        return this.pieRadiusSize.getUnit();
    }

    public void setPieRadiusUnit(String string) {
        this.pieRadiusSize.setUnit(string);
    }

    public void setNumSlices(int n) {
        this.numSlices = n;
    }

    public int getNumSlices() {
        return this.numSlices;
    }

    public void setPieSlices(PieSliceInfo[] pieSliceInfoArray) {
        this.pieSlices = pieSliceInfoArray;
    }

    public PieSliceInfo[] getPieSlices() {
        return this.pieSlices;
    }

    public PieSliceInfo getPieSlice(int n) {
        return this.pieSlices != null ? this.pieSlices[n] : null;
    }

    @Override
    public String[] getStyleDependency() {
        return null;
    }

    public void setStrokeColor(Color color) {
        this.strokeColor = color == null ? Color.black : color;
    }

    public Color getStrokeColor() {
        return this.strokeColor;
    }
}

