/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share;

import java.awt.Color;
import java.awt.Font;
import java.io.Serializable;

public class ScaleBar
implements Serializable {
    static final long serialVersionUID = 3230604429528980407L;
    protected boolean rendered = true;
    public static final String US_MODE = "US_MODE";
    public static final String METRIC_MODE = "METRIC_MODE";
    public static final String DUAL_MODES = "DUAL_MODES";
    public static final Color DEFAULT_COLOR1 = new Color(68, 68, 68, 210);
    public static final Color DEFAULT_COLOR2 = new Color(238, 238, 238, 210);
    public static final Font DEFAULT_FONT = new Font("Serif", 0, 12);
    private Color color1 = DEFAULT_COLOR1;
    private Color color2 = DEFAULT_COLOR2;
    private int lengthHint = 0;
    private Color labelColor = Color.black;
    private Font labelFont = DEFAULT_FONT;
    private float labelHaloSize = 0.0f;
    private String mode = "METRIC_MODE";
    private String position = "NORTH_EAST";
    private String labelPosition = "TOP";
    private int offsetX = 0;
    private int offsetY = 0;
    private boolean transformToWGS84 = false;

    public Object clone() {
        ScaleBar scaleBar = new ScaleBar();
        scaleBar.color1 = this.color1;
        scaleBar.color2 = this.color2;
        scaleBar.lengthHint = this.lengthHint;
        scaleBar.labelColor = this.labelColor;
        scaleBar.labelFont = this.labelFont;
        scaleBar.labelHaloSize = this.labelHaloSize;
        scaleBar.mode = this.mode;
        scaleBar.position = this.position;
        scaleBar.labelPosition = this.labelPosition;
        scaleBar.offsetX = this.offsetX;
        scaleBar.offsetY = this.offsetY;
        return scaleBar;
    }

    public void setMode(String string) {
        if (string != null) {
            this.mode = string.toUpperCase();
        }
    }

    public String getMode() {
        return this.mode;
    }

    public void setColor1(Color color) {
        this.color1 = color;
    }

    public Color getColor1() {
        return this.color1;
    }

    public void setColor2(Color color) {
        this.color2 = color;
    }

    public Color getColor2() {
        return this.color2;
    }

    public void setLengthHint(int n) {
        this.lengthHint = n;
    }

    public int getLengthHint() {
        return this.lengthHint;
    }

    public void setLabelColor(Color color) {
        this.labelColor = color;
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setLabelFont(Font font) {
        this.labelFont = font;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelHaloSize(float f) {
        this.labelHaloSize = f;
    }

    public float getLabelHaloSize() {
        return this.labelHaloSize;
    }

    public void setPosition(String string) {
        if ("SOUTH_EAST".equals(string = string.toUpperCase()) || "NORTH_EAST".equals(string) || "SOUTH_WEST".equals(string) || "NORTH_WEST".equals(string) || "NORTH".equals(string) || "SOUTH".equals(string)) {
            this.position = string;
        } else {
            System.err.println("invalid position for scale bar specified.");
        }
    }

    public String getPosition() {
        return this.position;
    }

    public void setRendered(boolean bl) {
        this.rendered = bl;
    }

    public boolean isRendered() {
        return this.rendered;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public void setOffsetX(int n) {
        this.offsetX = n <= 0 ? 0 : n;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public void setOffsetY(int n) {
        this.offsetY = n <= 0 ? 0 : n;
    }

    public String getLabelPosition() {
        return this.labelPosition;
    }

    public void setLabelPosition(String string) {
        if (string == null || !string.equalsIgnoreCase("TOP") && !string.equalsIgnoreCase("BOTTOM")) {
            return;
        }
        this.labelPosition = string.toUpperCase();
    }

    public void setTransformToWGS84(boolean bl) {
        this.transformToWGS84 = bl;
    }

    public boolean getTransformToWGS84() {
        return this.transformToWGS84;
    }
}

