/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import oracle.spatial.rdf.server.OptimizerUtils;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.SparqlQueryOptimizer;
import oracle.spatial.rdf.server.parser.sparql.ASTConstructQuery;
import oracle.spatial.rdf.server.parser.sparql.ASTConstructTemplate;
import oracle.spatial.rdf.server.parser.sparql.ASTGraphGraphPattern;
import oracle.spatial.rdf.server.parser.sparql.ASTGraphPatternNotTriples;
import oracle.spatial.rdf.server.parser.sparql.ASTGroupGraphPattern;
import oracle.spatial.rdf.server.parser.sparql.ASTSelectQuery;
import oracle.spatial.rdf.server.parser.sparql.ASTSolutionModifier;
import oracle.spatial.rdf.server.parser.sparql.ASTValuesClause;
import oracle.spatial.rdf.server.parser.sparql.Node;
import oracle.spatial.rdf.server.parser.sparql.ParseException;
import oracle.spatial.rdf.server.parser.sparql.SimpleNode;
import oracle.spatial.rdf.server.parser.sparql.SparqlSolnModDesc;

public class ConstructExpandOptimizer
implements SparqlQueryOptimizer {
    private static final String EMPTY_TMPLATE_MSG = "An empty CONSTRUCT template is not allowed";
    private static final String UNEXPECTED_NUM_CHILDREN_MSG = "Unexpected number of children under ASTConstructQuery";

    @Override
    public Node optimizeQuery(Node node) throws RDFException, ParseException {
        this.expandConstruct(node);
        return node;
    }

    private void expandConstruct(Node node) throws RDFException {
        if (((SimpleNode)node).id == 10) {
            this.rewriteConstruct((ASTConstructQuery)node);
        } else {
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                this.expandConstruct(node.jjtGetChild(i));
            }
        }
    }

    private void rewriteConstruct(ASTConstructQuery aSTConstructQuery) throws RDFException {
        Object object;
        int n;
        List<Node> list;
        ASTSelectQuery aSTSelectQuery = null;
        ArrayList<Node> arrayList = new ArrayList<Node>();
        int n2 = 0;
        ArrayList<SimpleNode> arrayList2 = new ArrayList<SimpleNode>();
        List<Object> list2 = new ArrayList();
        Node node = aSTConstructQuery.jjtGetParent();
        int n3 = node.jjtGetNumChildren() - 1;
        if (((SimpleNode)node.jjtGetChild((int)n3)).id == 23) {
            ASTValuesClause aSTValuesClause = (ASTValuesClause)node.jjtGetChild(n3);
            aSTConstructQuery.jjtAddChild(aSTValuesClause, aSTConstructQuery.jjtGetNumChildren());
            aSTValuesClause.jjtSetParent(aSTConstructQuery);
            node.jjtRemoveChild(n3);
        }
        if (aSTConstructQuery.jjtGetNumChildren() < 1 || (((SimpleNode)aSTConstructQuery.jjtGetChild((int)0)).id != 59 || aSTConstructQuery.jjtGetChild(0).jjtGetNumChildren() <= 0) && ((SimpleNode)aSTConstructQuery.jjtGetChild((int)0)).id != 47 && ((SimpleNode)aSTConstructQuery.jjtGetChild((int)0)).id != 46) {
            throw new RDFException(EMPTY_TMPLATE_MSG);
        }
        if (aSTConstructQuery.jjtGetNumChildren() > 4) {
            throw new RDFException(UNEXPECTED_NUM_CHILDREN_MSG);
        }
        if (aSTConstructQuery.jjtGetNumChildren() > 0 && (((SimpleNode)aSTConstructQuery.jjtGetChild((int)0)).id == 47 || ((SimpleNode)aSTConstructQuery.jjtGetChild((int)0)).id == 46)) {
            for (int i = 0; i < aSTConstructQuery.jjtGetNumChildren(); ++i) {
                SimpleNode simpleNode = (SimpleNode)aSTConstructQuery.jjtGetChild(i);
                if (simpleNode.id == 47) {
                    if (simpleNode.jjtGetNumChildren() < 3) {
                        throw new RDFException(EMPTY_TMPLATE_MSG);
                    }
                    arrayList2.add(simpleNode);
                    continue;
                }
                if (simpleNode.id != 46) continue;
                if (simpleNode.jjtGetNumChildren() < 2) {
                    throw new RDFException(EMPTY_TMPLATE_MSG);
                }
                arrayList2.add(simpleNode);
            }
        } else if (aSTConstructQuery.jjtGetNumChildren() > 0 && ((SimpleNode)aSTConstructQuery.jjtGetChild((int)0)).id == 59) {
            list2 = OptimizerUtils.collectBNVars(aSTConstructQuery.jjtGetChild(0));
        }
        if (aSTConstructQuery.jjtGetNumChildren() > 1 && ((SimpleNode)aSTConstructQuery.jjtGetChild((int)1)).id == 48) {
            list = (ASTGroupGraphPattern)aSTConstructQuery.jjtGetChild(1);
            for (n = 0; n < ((SimpleNode)((Object)list)).jjtGetNumChildren(); ++n) {
                arrayList.add(((SimpleNode)((Object)list)).jjtGetChild(n));
            }
            n2 = 1;
        } else {
            int n4;
            int n5;
            list = new ASTConstructTemplate(59);
            list.jjtSetInitCapacity(arrayList2.size());
            aSTConstructQuery.jjtAddChild((Node)((Object)list), 0);
            list.jjtSetParent(aSTConstructQuery);
            n = 0;
            for (Node node2 : arrayList2) {
                Node n42 = node2.cloneSubTree();
                n42 = this.qntToGGP(n42);
                arrayList.add(n42);
                list.jjtAddChild(node2, n);
                ++n;
                node2.jjtSetParent((Node)((Object)list));
            }
            Object object2 = null;
            boolean n52 = false;
            for (n5 = 1; n5 < aSTConstructQuery.jjtGetNumChildren(); ++n5) {
                object2 = (SimpleNode)aSTConstructQuery.jjtGetChild(n5);
                if (((SimpleNode)object2).id != 47 && ((SimpleNode)object2).id != 46) continue;
                ++n4;
            }
            for (n5 = 0; n5 < n4; ++n5) {
                aSTConstructQuery.jjtRemoveChild(1);
            }
            n2 = 0;
        }
        list = Collections.emptyList();
        try {
            object = null;
            if (aSTConstructQuery.getsolnMod().hasGroupBy()) {
                object = new HashSet<String>(aSTConstructQuery.getsolnMod().getGroupByVars());
            }
            if (list2.size() > 0) {
                list = OptimizerUtils.buildBNListFromBNVars(list2);
            }
            aSTSelectQuery = OptimizerUtils.genSelectQuery(arrayList, list, true, object);
        }
        catch (ParseException parseException) {
            throw new RDFException(parseException.getMessage());
        }
        if (aSTConstructQuery.jjtGetNumChildren() > ++n2 && ((SimpleNode)aSTConstructQuery.jjtGetChild((int)n2)).id == 13) {
            object = (ASTSolutionModifier)aSTConstructQuery.jjtGetChild(n2);
            aSTConstructQuery.jjtRemoveChild(n2);
            aSTSelectQuery.setsolnMod(aSTConstructQuery.getsolnMod());
            aSTSelectQuery.jjtAddChild((Node)object, aSTSelectQuery.jjtGetNumChildren());
            ((SimpleNode)object).jjtSetParent(aSTSelectQuery);
            aSTConstructQuery.setsolnMod(new SparqlSolnModDesc());
        }
        if (aSTConstructQuery.jjtGetNumChildren() > n2 && ((SimpleNode)aSTConstructQuery.jjtGetChild((int)n2)).id == 23) {
            object = (ASTValuesClause)aSTConstructQuery.jjtGetChild(n2);
            aSTConstructQuery.jjtRemoveChild(n2);
            aSTSelectQuery.jjtAddChild((Node)object, aSTSelectQuery.jjtGetNumChildren());
            ((SimpleNode)object).jjtSetParent(aSTSelectQuery);
        }
        aSTConstructQuery.jjtAddChild(aSTSelectQuery, 1);
        aSTSelectQuery.jjtSetParent(aSTConstructQuery);
    }

    private Node qntToGGP(Node node) {
        Stack<SimpleNode> stack = new Stack<SimpleNode>();
        Stack<Integer> stack2 = new Stack<Integer>();
        stack.push((SimpleNode)node);
        stack2.push(0);
        SimpleNode simpleNode = null;
        int n = 0;
        Node node2 = node;
        while (!stack.isEmpty()) {
            SimpleNode simpleNode2;
            simpleNode = (SimpleNode)stack.pop();
            n = (Integer)stack2.pop();
            for (int i = 0; i < simpleNode.jjtGetNumChildren(); ++i) {
                stack.push((SimpleNode)simpleNode.jjtGetChild(i));
                stack2.push(i);
            }
            if (simpleNode.id != 46) continue;
            ASTGraphPatternNotTriples aSTGraphPatternNotTriples = new ASTGraphPatternNotTriples(49);
            ASTGraphGraphPattern aSTGraphGraphPattern = new ASTGraphGraphPattern(51);
            aSTGraphPatternNotTriples.jjtAddChild(aSTGraphGraphPattern, 0);
            aSTGraphGraphPattern.jjtSetParent(aSTGraphPatternNotTriples);
            Node node3 = simpleNode.jjtGetParent();
            if (node3 != null) {
                aSTGraphPatternNotTriples.jjtSetParent(node3);
                node3.jjtAddChild(aSTGraphPatternNotTriples, n);
            } else {
                node2 = aSTGraphPatternNotTriples;
            }
            aSTGraphGraphPattern.jjtSetInitCapacity(simpleNode.jjtGetNumChildren());
            aSTGraphGraphPattern.jjtSetInitCapacity(2);
            if (simpleNode.jjtGetNumChildren() > 0) {
                simpleNode2 = (SimpleNode)simpleNode.jjtGetChild(0);
                aSTGraphGraphPattern.jjtAddChild(simpleNode2, 0);
                simpleNode2.jjtSetParent(aSTGraphGraphPattern);
            }
            if (simpleNode.jjtGetNumChildren() <= 1) continue;
            simpleNode2 = new ASTGroupGraphPattern(48);
            aSTGraphGraphPattern.jjtAddChild(simpleNode2, 1);
            simpleNode2.jjtSetParent(aSTGraphGraphPattern);
            simpleNode2.jjtSetInitCapacity(simpleNode.jjtGetNumChildren() - 1);
            for (int i = 1; i < simpleNode.jjtGetNumChildren(); ++i) {
                SimpleNode simpleNode3 = (SimpleNode)simpleNode.jjtGetChild(i);
                simpleNode2.jjtAddChild(simpleNode3, i - 1);
                simpleNode3.jjtSetParent(simpleNode2);
            }
        }
        return node2;
    }
}

