/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.model;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.PatternFilters;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.dialogs.JDevDialogHeader;
import oracle.jdeveloper.resource.ModelArb;

public class DirectoriesPatternFilterPanel
extends JPanel
implements DocumentListener {
    private GridBagLayout gridBag = new GridBagLayout();
    private JLabel lblDirectories = new JLabel();
    private JRadioButton rbInclude = new JRadioButton();
    private JRadioButton rbExclude = new JRadioButton();
    private JTextField txtDirectories = new JTextField();
    private JCheckBox checkSubdirectories = new JCheckBox();
    private JDevDialogHeader dlgHeader;
    private JEWTDialog dialog;
    private static boolean recurse = false;
    private static boolean show = false;
    private static final String HELP_TOPIC = "f1_idedadddirectoryfilter_html";

    public DirectoriesPatternFilterPanel() {
        try {
            this.initializePanel();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean showDialog(Component parent, PatternFilters filters, String selectedDir) {
        String directory = selectedDir;
        if (selectedDir.endsWith("/")) {
            directory = selectedDir.substring(0, selectedDir.length() - 1);
        } else if (directory.length() == 0) {
            directory = ModelArb.getString((int)78);
        }
        ResourceUtils.resButton((AbstractButton)this.checkSubdirectories, (String)ModelArb.format((int)75, (Object)directory));
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, HELP_TOPIC);
        this.dialog = DialogUtil.createJEWTDialogOwnedBy((Component)parent);
        if (this.dialog == null) {
            return false;
        }
        this.dialog.setContent((Component)this);
        this.dialog.setOKButtonEnabled(false);
        this.dialog.setTitle(ModelArb.getString((int)70));
        this.dialog.setButtonMask(7);
        this.dialog.setInitialFocus((Component)this.txtDirectories);
        this.dialog.setResizable(true);
        this.dialog.pack();
        if (this.dialog.runDialog()) {
            this.commitTo(filters, selectedDir);
            return true;
        }
        this.dialog.dispose();
        return false;
    }

    private void commitTo(PatternFilters filters, String selectedDirectory) {
        String RECURSE_PATTERN = "**/";
        if (((String)selectedDirectory).length() > 0 && !((String)selectedDirectory).endsWith("/")) {
            selectedDirectory = (String)selectedDirectory + "/";
        }
        boolean applyRecursively = this.checkSubdirectories.isSelected();
        boolean include = this.rbInclude.isSelected();
        String filterText = this.txtDirectories.getText();
        if (filterText.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(filterText, ";");
            while (tokenizer.hasMoreTokens()) {
                String pattern;
                String token = tokenizer.nextToken();
                String string = pattern = applyRecursively ? (String)selectedDirectory + RECURSE_PATTERN + token : (String)selectedDirectory + token;
                if (include) {
                    filters.addInclude(pattern);
                    continue;
                }
                filters.addExclude(pattern);
            }
        }
        show = include;
        recurse = applyRecursively;
    }

    private JDevDialogHeader getDialogHeader() {
        if (this.dlgHeader == null) {
            this.dlgHeader = new JDevDialogHeader();
            this.dlgHeader.setHeaderTitle(ModelArb.getString((int)80));
            this.dlgHeader.setHeaderDescription(ModelArb.getString((int)71));
        }
        return this.dlgHeader;
    }

    private void initializePanel() throws Exception {
        ResourceUtils.resButton((AbstractButton)this.rbInclude, (String)ModelArb.getString((int)73));
        ResourceUtils.resButton((AbstractButton)this.rbExclude, (String)ModelArb.getString((int)74));
        ResourceUtils.resLabel((JLabel)this.lblDirectories, (Component)this.txtDirectories, (String)ModelArb.getString((int)72));
        ResourceUtils.resButton((AbstractButton)this.checkSubdirectories, (String)ModelArb.getString((int)75));
        ButtonGroup includeGroup = new ButtonGroup();
        includeGroup.add(this.rbInclude);
        includeGroup.add(this.rbExclude);
        if (show) {
            this.rbInclude.setSelected(true);
        } else {
            this.rbExclude.setSelected(true);
        }
        this.checkSubdirectories.setSelected(recurse);
        this.txtDirectories.getDocument().addDocumentListener(this);
        this.setLayout(this.gridBag);
        int Y = -1;
        int INDENT = 10;
        Insets emptyInsets = new Insets(0, 0, 0, 0);
        Insets header = new Insets(10, 0, 0, 0);
        Insets inset = new Insets(3, 0, 0, 0);
        this.add((Component)this.rbInclude, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, emptyInsets, 0, 0));
        this.add((Component)this.rbExclude, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 17, 2, emptyInsets, 0, 0));
        this.add((Component)this.lblDirectories, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, header, 0, 0));
        this.add((Component)this.txtDirectories, new GridBagConstraints(0, -1, 2, 1, 0.0, 0.0, 17, 2, inset, 0, 0));
        this.add((Component)this.checkSubdirectories, new GridBagConstraints(0, -1, 2, 1, 1.0, 1.0, 18, 0, header, 0, 0));
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (this.dialog != null) {
            this.dialog.setOKButtonEnabled(e.getDocument().getLength() > 0);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (this.dialog != null) {
            this.dialog.setOKButtonEnabled(e.getDocument().getLength() > 0);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }
}

