/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.config.GlobalIgnoreList;
import oracle.ide.controls.OverlayIcon;
import oracle.ide.controls.WaitCursor;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.URLPath;
import oracle.ide.util.PatternFilter;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.TriStateBoolean;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.model.ContentFolder;
import oracle.jdeveloper.model.ContentSetFilterChooser;
import oracle.jdeveloper.resource.ModelArb;

public class ContentSetFilterPanel
extends JTabbedPane {
    private static final String EMPTY_FILTER_LIST = ModelArb.getString((int)106);
    private static final String NO_EXCLUSIONS = ModelArb.getString((int)102);
    private static final String NO_COMMON_EXCLUSIONS = ModelArb.getString((int)103);
    private static final String NO_INCLUSIONS = ModelArb.getString((int)104);
    private static final String NO_COMMON_INCLUSIONS = ModelArb.getString((int)105);
    private static final Icon ICON_INCLUDE = ModelArb.getIcon((int)108);
    private static final Icon ICON_EXCLUDE = ModelArb.getIcon((int)109);
    private FilterPanel _inclusionsTab;
    private FilterPanel _exclusionsTab;
    private ContentFolder[] _activeContentFlders;

    public ContentSetFilterPanel() {
        try {
            this._inclusionsTab = new FilterPanel(true);
            this._exclusionsTab = new FilterPanel(false);
            this.add(ModelArb.getString((int)100), this._inclusionsTab);
            this.add(ModelArb.getString((int)101), this._exclusionsTab);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setData(ContentFolder[] folders) {
        this._inclusionsTab.loadFrom(folders);
        this._exclusionsTab.loadFrom(folders);
    }

    void refreshAllFilters() {
        this._inclusionsTab.refreshFilters();
        this._exclusionsTab.refreshFilters();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this._inclusionsTab.enableControls();
        this._exclusionsTab.enableControls();
    }

    private class FilterPanel
    extends JPanel
    implements ActionListener,
    ItemListener,
    ListSelectionListener {
        private final JButton _addFilterButton = new JButton();
        private final JButton _removeFilterButton = new JButton();
        private final DefaultListModel _filterListModel = new DefaultListModel();
        private final JList _filterList = new JList(this._filterListModel);
        private final JScrollPane _scroller = new JScrollPane(this._filterList);
        private final GridBagLayout layout = new GridBagLayout();
        private final JCheckBox _includeSubFolders = new JCheckBox();
        private FilterListCellRenderer _cellRenderer;
        private boolean _includeExcludeMode;

        FilterPanel(boolean includeMode) throws Exception {
            ContentSetFilterPanel.this._activeContentFlders = new ContentFolder[0];
            this._includeExcludeMode = includeMode;
            this.jbInit();
        }

        public void loadFrom(ContentFolder[] folders) {
            ContentSetFilterPanel.this._activeContentFlders = folders;
            this.refreshInclude();
            this.refreshFilters();
        }

        private FilterListCellRenderer getCellRenderer(Icon overlayIcon) {
            if (this._cellRenderer == null) {
                this._cellRenderer = new FilterListCellRenderer(overlayIcon);
            }
            return this._cellRenderer;
        }

        private void enableControls() {
            if (!this.isEnabled() || ContentSetFilterPanel.this._activeContentFlders.length == 0) {
                this._filterList.setEnabled(false);
                this._includeSubFolders.setEnabled(false);
                this._addFilterButton.setEnabled(false);
                this._removeFilterButton.setEnabled(false);
            } else {
                this._filterList.setEnabled(true);
                boolean hasContent = this.containsFilesOrFolders();
                this._addFilterButton.setEnabled(hasContent);
                this._includeSubFolders.setEnabled(hasContent);
                int selectedFilters = this._filterList.getSelectedIndices().length;
                Object selectedValue = this._filterList.getSelectedValue();
                if (selectedValue == EMPTY_FILTER_LIST) {
                    this._removeFilterButton.setEnabled(true);
                } else if (selectedFilters > 1 || selectedFilters == 1 && NO_EXCLUSIONS != selectedValue && NO_COMMON_EXCLUSIONS != selectedValue && NO_COMMON_INCLUSIONS != selectedValue && NO_INCLUSIONS != selectedValue) {
                    this._removeFilterButton.setEnabled(true);
                    this._includeSubFolders.setEnabled(false);
                } else {
                    this._removeFilterButton.setEnabled(false);
                    this._includeSubFolders.setEnabled(true);
                }
            }
        }

        private boolean containsFilesOrFolders() {
            for (ContentFolder folder : ContentSetFilterPanel.this._activeContentFlders) {
                URL[] children = URLFileSystem.list((URL)folder.getContentFolderURL(), (URLFilter)GlobalIgnoreList.getURLFilter());
                if (children == null || children.length <= 0) continue;
                return true;
            }
            return false;
        }

        private void setCheckboxState(TriStateBoolean bool) {
            boolean triState = bool.isTriState();
            if (!triState) {
                this._includeSubFolders.setSelected(bool.isTrue());
            }
            ButtonModel bm = this._includeSubFolders.getModel();
            bm.setArmed(triState);
            bm.setPressed(triState);
        }

        private void refreshInclude() {
            if (ContentSetFilterPanel.this._activeContentFlders == null || ContentSetFilterPanel.this._activeContentFlders.length == 0) {
                return;
            }
            boolean includeSubs = ContentSetFilterPanel.this._activeContentFlders[0].isIncludeSubfolders();
            TriStateBoolean bool = includeSubs ? TriStateBoolean.TRUE : TriStateBoolean.FALSE;
            for (int i = 0; i < ContentSetFilterPanel.this._activeContentFlders.length; ++i) {
                if (includeSubs == ContentSetFilterPanel.this._activeContentFlders[i].isIncludeSubfolders()) continue;
                bool = TriStateBoolean.TRI_STATE;
                break;
            }
            this.setCheckboxState(bool);
        }

        private void refreshFilters() {
            this._filterListModel.clear();
            ArrayList intersected = null;
            ArrayList nextGroup = new ArrayList();
            for (int i = 0; i < ContentSetFilterPanel.this._activeContentFlders.length; ++i) {
                ContentFolder curContentFolder = ContentSetFilterPanel.this._activeContentFlders[i];
                ArrayList filters = this.isExclude() ? curContentFolder.getExcludeFilters() : curContentFolder.getIncludeFilters();
                for (PatternFilter filter : filters) {
                    this.addFilterToGroup(nextGroup, filter.getPattern(), curContentFolder);
                }
                if (intersected != null) {
                    intersected.retainAll(nextGroup);
                } else {
                    intersected = new ArrayList(nextGroup);
                }
                nextGroup.clear();
            }
            if (intersected != null) {
                Iterator iter = intersected.iterator();
                while (iter.hasNext()) {
                    this._filterListModel.addElement(iter.next());
                }
            }
            if (this._filterListModel.size() == 0) {
                String element = this.isExclude() ? (ContentSetFilterPanel.this._activeContentFlders.length == 1 ? (ContentSetFilterPanel.this._activeContentFlders[0].isExcludeAll() ? EMPTY_FILTER_LIST : NO_EXCLUSIONS) : NO_COMMON_EXCLUSIONS) : (ContentSetFilterPanel.this._activeContentFlders.length == 1 ? NO_INCLUSIONS : NO_COMMON_INCLUSIONS);
                this._filterListModel.addElement(element);
            }
            this._filterList.setSelectedIndex(0);
        }

        private void addFilterToGroup(ArrayList groups, String excludePattern, ContentFolder contentFolder) {
            for (FilterGroup group : groups) {
                if (!group._pattern.equals(excludePattern)) continue;
                group._contentFolders.add(contentFolder);
                return;
            }
            FilterGroup newGroup = new FilterGroup(contentFolder, excludePattern);
            newGroup._contentFolders.add(contentFolder);
            groups.add(newGroup);
        }

        private boolean isInclude() {
            return true == this._includeExcludeMode;
        }

        private boolean isExclude() {
            return false == this._includeExcludeMode;
        }

        private void jbInit() throws Exception {
            ResourceUtils.resButton((AbstractButton)this._includeSubFolders, (String)ModelArb.getString((int)91));
            ResourceUtils.resButton((AbstractButton)this._addFilterButton, (String)ModelArb.getString((int)98));
            ResourceUtils.resButton((AbstractButton)this._removeFilterButton, (String)ModelArb.getString((int)99));
            this._includeSubFolders.addItemListener(this);
            this._addFilterButton.addActionListener(this);
            this._removeFilterButton.addActionListener(this);
            this._filterList.addListSelectionListener(this);
            this._filterList.setCellRenderer(this.getCellRenderer(this.isExclude() ? ICON_EXCLUDE : ICON_INCLUDE));
            this._filterList.getSelectionModel().setSelectionMode(2);
            this.setLayout(this.layout);
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            Insets empty = new Insets(0, 0, 0, 0);
            Insets checkbox = new Insets(0, 0, 4, 0);
            Insets button = new Insets(0, 8, 5, 0);
            Insets lastButton = new Insets(0, 8, 0, 0);
            int y = -1;
            if (this.isInclude()) {
                this.add((Component)this._includeSubFolders, new GridBagConstraints(0, -1, 2, 1, 0.0, 0.0, 17, 0, checkbox, 0, 0));
            }
            this.add((Component)this._scroller, new GridBagConstraints(0, -1, 1, 2, 1.0, 1.0, 10, 1, empty, 0, 0));
            this.add((Component)this._addFilterButton, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 11, 2, button, 0, 0));
            this.add((Component)this._removeFilterButton, new GridBagConstraints(1, -1, 1, 1, 0.0, 1.0, 12, 2, lastButton, 0, 0));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            if (src == this._addFilterButton) {
                WaitCursor waitCursor = new WaitCursor((Component)ContentSetFilterPanel.this);
                waitCursor.show();
                URL[] activeURLs = new URL[ContentSetFilterPanel.this._activeContentFlders.length];
                for (int i = 0; i < ContentSetFilterPanel.this._activeContentFlders.length; ++i) {
                    activeURLs[i] = ContentSetFilterPanel.this._activeContentFlders[i].getContentFolderURL();
                }
                URLPath urlPath = new URLPath(activeURLs);
                int dialogMode = activeURLs.length > 1 ? 0 : 1;
                ContentSetFilterChooser chooser = new ContentSetFilterChooser(dialogMode, urlPath);
                chooser.setPreferredSize(new Dimension(300, 225));
                waitCursor.hide();
                waitCursor.dispose();
                int[] newSelection = new int[]{};
                if (chooser.showDialog(this.getParent(), this.isInclude()) == 0) {
                    String[] selectedPackages = chooser.getSelections();
                    newSelection = new int[selectedPackages.length];
                    for (int i = 0; i < selectedPackages.length; ++i) {
                        String pattern = selectedPackages[i];
                        for (int x = 0; x < ContentSetFilterPanel.this._activeContentFlders.length; ++x) {
                            ContentFolder folder = ContentSetFilterPanel.this._activeContentFlders[x];
                            if (this.isExclude()) {
                                folder.addRelativeExcludeFilter(pattern);
                                continue;
                            }
                            folder.addRelativeIncludeFilter(pattern);
                        }
                    }
                    ContentSetFilterPanel.this.refreshAllFilters();
                    int length = this._filterListModel.size();
                    int index = length - newSelection.length;
                    for (int i = 0; i < newSelection.length; ++i) {
                        newSelection[i] = index++;
                    }
                    this._filterList.setSelectedIndices(newSelection);
                }
            } else if (src == this._removeFilterButton) {
                int index = this._filterList.getSelectedIndex();
                for (int i = 0; i < ContentSetFilterPanel.this._activeContentFlders.length; ++i) {
                    ContentFolder folder = ContentSetFilterPanel.this._activeContentFlders[i];
                    Object[] selection = this._filterList.getSelectedValues();
                    for (int x = 0; x < selection.length; ++x) {
                        if (selection[x] == EMPTY_FILTER_LIST) {
                            folder.addFilter(folder.getPrimaryIncludeFilter());
                            continue;
                        }
                        FilterGroup group = (FilterGroup)selection[x];
                        if (this.isExclude()) {
                            folder.removeRelativeExcludeFilter(group._pattern);
                            continue;
                        }
                        folder.removeRelativeIncludeFilter(group._pattern);
                    }
                }
                ContentSetFilterPanel.this.refreshAllFilters();
                int length = this._filterListModel.size();
                if (length > 0 && index <= length) {
                    if (index == length) {
                        --index;
                    }
                    this._filterList.setSelectedIndex(index);
                }
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                this.enableControls();
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getSource() == this._includeSubFolders) {
                boolean include = this._includeSubFolders.isSelected();
                for (int i = 0; i < ContentSetFilterPanel.this._activeContentFlders.length; ++i) {
                    ContentFolder folder = ContentSetFilterPanel.this._activeContentFlders[i];
                    folder.setIncludeSubfolders(include);
                }
                this.refreshInclude();
            }
        }
    }

    private static class FilterListCellRenderer
    extends DefaultListCellRenderer {
        private OverlayIcon _folderIcon;
        private OverlayIcon _fileIcon;
        private Icon _warningIcon = OracleIcons.getIcon((String)"warning.png");

        FilterListCellRenderer(Icon icon) {
            this._folderIcon = new OverlayIcon(OracleIcons.getIcon((String)"folder.png"), icon);
            this._fileIcon = new OverlayIcon(OracleIcons.getIcon((String)"file.png"), icon);
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof FilterGroup) {
                if (((FilterGroup)value)._isFolderFilter) {
                    label.setIcon((Icon)this._folderIcon);
                } else {
                    label.setIcon((Icon)this._fileIcon);
                }
            } else if (value == EMPTY_FILTER_LIST) {
                label.setIcon(this._warningIcon);
            } else if (!(value instanceof String)) {
                System.err.println("**** Warning. Unrecognized list item type: " + (value != null ? value.getClass() : null));
            }
            return label;
        }
    }

    private static class FilterGroup {
        private final char SEPARATOR_CHAR = File.separatorChar;
        final boolean _isFolderFilter;
        final String _pattern;
        final String _displayPattern;
        final ArrayList _contentFolders;

        FilterGroup(ContentFolder contentFolder, String pattern) {
            URLPath urlPath;
            if (pattern == null) {
                throw new IllegalArgumentException();
            }
            this._pattern = pattern;
            this._contentFolders = new ArrayList();
            this._isFolderFilter = !pattern.endsWith("/") ? URLFileSystem.isDirectory((URL)(urlPath = new URLPath(contentFolder.getRootURL())).toQualifiedURL(pattern)) : true;
            String s = this._pattern.endsWith("/") ? this._pattern.substring(0, this._pattern.length() - 1) : this._pattern;
            this._displayPattern = s.replace('/', this.SEPARATOR_CHAR);
        }

        public String toString() {
            return this._displayPattern;
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            return this._pattern.equals(((FilterGroup)o)._pattern);
        }

        public int hashCode() {
            return this._pattern.hashCode();
        }
    }
}

