/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import oracle.ide.model.TechId;
import oracle.ide.panels.ActionDescriptionPanel;
import oracle.javatools.dialogs.DetailDialog;
import oracle.jdeveloper.resource.TechArb;

class ConfirmDeleteTechScopesDialog {
    private final List<TechId> m_techIds;
    private final DetailDialog m_detailDialog;
    private final JTable m_table;

    public ConfirmDeleteTechScopesDialog(Component parent, List<TechId> techIds) {
        this.m_techIds = techIds;
        this.m_table = new JTable();
        Component detailsComponent = this.createDeleteDetailsComponent(this.m_table);
        this.m_detailDialog = DetailDialog.createDetailDialog((Component)parent, (String)TechArb.getString(33), (int)7);
        ActionDescriptionPanel panel = ActionDescriptionPanel.build((String)TechArb.getString(34), (String)TechArb.getString(35), (String[])new String[0]);
        this.m_detailDialog.setContent((Component)panel);
        this.m_detailDialog.setDetailContent(detailsComponent);
        this.m_detailDialog.setHelpTopicId("f1_idedconfirmfeatureremoval_html");
    }

    public boolean runDialog() {
        return this.m_detailDialog.runDialog();
    }

    private Component createDeleteDetailsComponent(JTable table) {
        table.setModel(this.createTableModel());
        table.setRowHeight(20);
        table.setShowGrid(true);
        table.setShowHorizontalLines(true);
        table.setShowVerticalLines(true);
        table.setSelectionMode(0);
        table.getColumnModel().getColumn(0).setPreferredWidth(50);
        table.getColumnModel().getColumn(0).setMaxWidth(100);
        JScrollPane scroll = new JScrollPane(table);
        table.setFillsViewportHeight(true);
        table.setPreferredScrollableViewportSize(new Dimension(430, 100));
        JLabel unusedFeaturesLabel = new JLabel(TechArb.getString(36));
        unusedFeaturesLabel.setLabelFor(table);
        unusedFeaturesLabel.setDisplayedMnemonicIndex(0);
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout(new GridBagLayout());
        tablePanel.add((Component)unusedFeaturesLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        tablePanel.add((Component)scroll, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(3, 0, 0, 0), 0, 0));
        return tablePanel;
    }

    private TableModel createTableModel() {
        Vector<String> columnNames = new Vector<String>(2);
        columnNames.add(TechArb.getString(38));
        columnNames.add(TechArb.getString(39));
        Vector data = new Vector(this.m_techIds.size());
        for (TechId techId : this.m_techIds) {
            Vector<Object> entry = new Vector<Object>(2);
            entry.add(0, true);
            entry.add(1, techId.getName());
            data.add(entry);
        }
        return new DefaultTableModel(data, columnNames){

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return this.getValueAt(0, columnIndex).getClass();
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == 0;
            }
        };
    }

    public List<TechId> getLeftInTechIds() {
        ArrayList<TechId> removedTechIds = new ArrayList<TechId>();
        for (int i = 0; i < this.m_techIds.size(); ++i) {
            Boolean selected = (Boolean)this.m_table.getModel().getValueAt(i, 0);
            if (selected.booleanValue()) continue;
            removedTechIds.add(this.m_techIds.get(i));
        }
        return removedTechIds;
    }
}

