/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cmd;

import java.awt.Component;
import java.net.URL;
import java.util.Collection;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.FileOpenHistory;
import oracle.ide.controller.Command;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.migration.MigrationInfo;
import oracle.ide.migration.NodeMigrator;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeMigrationTracker;
import oracle.ide.model.Project;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.panels.Traversable;
import oracle.ide.util.Assert;
import oracle.jdeveloper.resource.ExtensionManifest;

public class OpenProjectCommand
extends Command {
    public static final String OPEN_PROJECT_CMD = OpenProjectCommand.class.getName();
    public static final int OPEN_PROJECT_CMD_ID = Ide.findOrCreateCmdID((String)OPEN_PROJECT_CMD);
    private Project project;
    private static final String JAVA_PROJECT_TYPE_NAME = "Java Project";
    private static final String HELP_TOPIC_OPEN = "f1_idedopenorcreatefile_html";

    public OpenProjectCommand() {
        super(OPEN_PROJECT_CMD_ID);
    }

    public final int doit() throws Exception {
        Context context = this.getContext();
        this.project = context.getProject();
        if (this.project == null) {
            this.project = Ide.getActiveProject();
        }
        String dialogTitle = ExtensionManifest.get("OPEN_PROJECT_TITLE");
        URLChooser projectURLChooser = new URLChooser();
        projectURLChooser.setHelpID(HELP_TOPIC_OPEN);
        DialogUtil.initURLChooser((URLChooser)projectURLChooser, (Context)context);
        projectURLChooser.setSelectionScope(0);
        if (this.project != null) {
            projectURLChooser.setSelectedURL(this.project.getURL());
        }
        projectURLChooser.clearChooseableURLFilters();
        JavaProjectURLFilter javaProjectFilter = new JavaProjectURLFilter();
        projectURLChooser.addChooseableURLFilter((URLFilter)javaProjectFilter);
        URLChooser content = projectURLChooser;
        int returnVal = projectURLChooser.showOpenDialog((Component)Ide.getMainWindow(), (Traversable)content, dialogTitle);
        if (returnVal == 0) {
            block0: for (URL selectedProject : projectURLChooser.getSelectedURLs()) {
                Project projectToBeOpened;
                NodeMigrator migrator;
                URL projectURLInCanonicalForm = URLFileSystem.canonicalize((URL)selectedProject);
                Collection allOpenProjects = Ide.getActiveWorkspace().projects();
                for (Project nextOpenProject : allOpenProjects) {
                    if (!nextOpenProject.getURL().equals(projectURLInCanonicalForm)) continue;
                    continue block0;
                }
                Node projectNode = NodeFactory.findOrCreate((URL)projectURLInCanonicalForm);
                if (!(projectNode instanceof Project) || (migrator = NodeMigrator.getNodeMigrator((String)NodeMigrator.getLookupKey((Node)(projectToBeOpened = (Project)projectNode)))) == null) continue;
                MigrationInfo migInfo = migrator.getMigrationInfo((Node)projectToBeOpened);
                if (migInfo.getVersionStatus() == MigrationInfo.VERSION_CURRENT) {
                    OpenProjectCommand.openProject(projectToBeOpened);
                    continue;
                }
                NodeMigrationTracker.getInstance().startTracking(projectToBeOpened.getURL());
                MigrationInfo.MigrationStatus migrationStatus = migrator.migrate(migInfo).getMigrationStatus();
                if (migrationStatus != MigrationInfo.MIGRATION_DONE) {
                    Assert.print((String)(projectToBeOpened.getShortLabel() + " did not migrate fully. Status was " + migrationStatus));
                }
                if (migrationStatus != MigrationInfo.MIGRATION_CANCELED) {
                    OpenProjectCommand.openProject(projectToBeOpened);
                }
                NodeMigrationTracker.getInstance().stopTracking(projectToBeOpened.getURL());
            }
        } else {
            return 1;
        }
        return 0;
    }

    private static void openProject(Project projectToBeOpened) throws Exception {
        Ide.getActiveWorkspace().add((Element)projectToBeOpened);
        UpdateMessage.fireChildAdded((Subject)Ide.getActiveWorkspace(), (Element)projectToBeOpened);
        Ide.setActiveProject((Project)projectToBeOpened);
        projectToBeOpened.open();
        UpdateMessage.fireObjectOpened((Subject)projectToBeOpened);
        FileOpenHistory.getInstance().updateHistory((Node)projectToBeOpened);
    }

    private class JavaProjectURLFilter
    extends DefaultURLFilter {
        JavaProjectURLFilter() {
            super(OpenProjectCommand.JAVA_PROJECT_TYPE_NAME, ".jpr");
        }
    }
}

