/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cms;

import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Enumeration;
import java.util.Vector;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.cert.AttributeSet;
import oracle.security.crypto.cms.CMS;
import oracle.security.crypto.cms.CMSKEKRecipientInfo;
import oracle.security.crypto.cms.CMSKEKRecipientInfoSpec;
import oracle.security.crypto.cms.CMSKeyTransRecipientInfo;
import oracle.security.crypto.cms.CMSKeyTransRecipientInfoSpec;
import oracle.security.crypto.cms.CMSOutputConnector;
import oracle.security.crypto.cms.CMSOutputStream;
import oracle.security.crypto.cms.CMSRecipientInfo;
import oracle.security.crypto.cms.CMSRecipientInfoSpec;
import oracle.security.crypto.cms.CMSUtils;
import oracle.security.crypto.cms.ECIOutputStream;
import oracle.security.crypto.cms.OriginatorInfo;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.CBCAlgorithmIdentifier;
import oracle.security.crypto.util.OutputGenerationException;

public class CMSEnvelopedDataOutputStream
extends CMSOutputStream {
    private ASN1ObjectID enclosedContentType;
    private Cipher cipher;
    private AlgorithmIdentifier contentEncryptionAlgID;
    private ECIOutputStream content_out;
    private boolean writingToConnector;
    private Vector recipients;
    private SecretKey contentEncryptionKey;
    private boolean terminated = false;
    private boolean writeContent;
    private OriginatorInfo origInfo;
    private AttributeSet unprotectedAttribs;
    private boolean prefaceOutput = false;

    public CMSEnvelopedDataOutputStream(OutputStream out, AlgorithmIdentifier contentEncryptionAlgID, Vector recipients) throws NoSuchAlgorithmException {
        this(out, CMS.id_data, contentEncryptionAlgID, recipients, true, null, null);
    }

    public CMSEnvelopedDataOutputStream(OutputStream out, ASN1ObjectID enclosedContentType, AlgorithmIdentifier contentEncryptionAlgID, Vector recipients) throws NoSuchAlgorithmException {
        this(out, enclosedContentType, contentEncryptionAlgID, recipients, true, null, null);
    }

    public CMSEnvelopedDataOutputStream(OutputStream out, ASN1ObjectID enclosedContentType, AlgorithmIdentifier contentEncryptionAlgID, Vector recipients, boolean writeContent) throws NoSuchAlgorithmException {
        this(out, enclosedContentType, contentEncryptionAlgID, recipients, writeContent, null, null);
    }

    public CMSEnvelopedDataOutputStream(OutputStream out, ASN1ObjectID enclosedContentType, AlgorithmIdentifier contentEncryptionAlgID, Vector recipients, boolean writeContent, OriginatorInfo origInfo, AttributeSet unprotectedAttribs) throws NoSuchAlgorithmException {
        super(out);
        this.enclosedContentType = enclosedContentType;
        byte[] random = new byte[8];
        SecureRandom sr = new SecureRandom();
        String algoName = CMSUtils.getAlgoName(contentEncryptionAlgID, true);
        KeyGenerator kg = KeyGenerator.getInstance(algoName);
        int keysize = 0;
        if (contentEncryptionAlgID.equals((Object)CMS.aes128_cbc) || contentEncryptionAlgID.equals((Object)CMS.aes192_cbc) || contentEncryptionAlgID.equals((Object)CMS.aes256_cbc)) {
            keysize = CMSUtils.getKeySize(contentEncryptionAlgID);
            kg.init(keysize, sr);
        } else {
            kg.init(sr);
        }
        this.contentEncryptionKey = kg.generateKey();
        this.cipher = null;
        try {
            String AlgoName = CMSUtils.getAlgoName(contentEncryptionAlgID);
            this.cipher = contentEncryptionAlgID.equals((Object)CMS.aes128_cbc) || contentEncryptionAlgID.equals((Object)CMS.aes192_cbc) || contentEncryptionAlgID.equals((Object)CMS.aes256_cbc) ? Cipher.getInstance("AES/CBC/PKCS5Padding") : Cipher.getInstance(CMSUtils.addPadding(AlgoName));
            if (AlgoName.indexOf("CBC") != -1) {
                byte[] iv = null;
                iv = contentEncryptionAlgID.equals((Object)CMS.aes128_cbc) || contentEncryptionAlgID.equals((Object)CMS.aes192_cbc) || contentEncryptionAlgID.equals((Object)CMS.aes256_cbc) ? CMSUtils.generateRandomBytes(16) : CMSUtils.generateRandomBytes(8);
                this.cipher.init(1, (Key)this.contentEncryptionKey, new IvParameterSpec(iv));
                this.contentEncryptionAlgID = new CBCAlgorithmIdentifier(contentEncryptionAlgID.getOID(), iv);
            } else {
                this.cipher.init(1, this.contentEncryptionKey);
                this.contentEncryptionAlgID = contentEncryptionAlgID;
            }
        }
        catch (InvalidKeyException ex) {
            throw new NoSuchAlgorithmException(ex.toString());
        }
        catch (NoSuchPaddingException ex) {
            throw new NoSuchAlgorithmException(ex.toString());
        }
        catch (InvalidAlgorithmParameterException ex) {
            throw new NoSuchAlgorithmException(ex.toString());
        }
        this.recipients = recipients;
        this.writeContent = writeContent;
        this.origInfo = origInfo;
        this.unprotectedAttribs = unprotectedAttribs;
        this.writingToConnector = false;
    }

    public CMSEnvelopedDataOutputStream(CMSOutputConnector conn, ASN1ObjectID enclosedContentType, AlgorithmIdentifier contentEncryptionAlgID, Vector recipients, boolean writeContent) throws NoSuchAlgorithmException {
        super(conn.getOutputStream());
        byte[] random = new byte[8];
        SecureRandom sr = new SecureRandom();
        String algoName = CMSUtils.getAlgoName(contentEncryptionAlgID, true);
        KeyGenerator kg = KeyGenerator.getInstance(algoName);
        int keysize = 0;
        if (contentEncryptionAlgID.equals((Object)CMS.aes128_cbc) || contentEncryptionAlgID.equals((Object)CMS.aes192_cbc) || contentEncryptionAlgID.equals((Object)CMS.aes256_cbc)) {
            keysize = CMSUtils.getKeySize(contentEncryptionAlgID);
            kg.init(keysize, sr);
        } else {
            kg.init(sr);
        }
        this.contentEncryptionKey = kg.generateKey();
        this.cipher = null;
        try {
            String AlgoName = CMSUtils.getAlgoName(contentEncryptionAlgID);
            this.cipher = contentEncryptionAlgID.equals((Object)CMS.aes128_cbc) || contentEncryptionAlgID.equals((Object)CMS.aes192_cbc) || contentEncryptionAlgID.equals((Object)CMS.aes256_cbc) ? Cipher.getInstance("AES/CBC/PKCS5Padding") : Cipher.getInstance(CMSUtils.addPadding(AlgoName));
            if (AlgoName.indexOf("CBC") != -1) {
                byte[] iv = null;
                iv = contentEncryptionAlgID.equals((Object)CMS.aes128_cbc) || contentEncryptionAlgID.equals((Object)CMS.aes192_cbc) || contentEncryptionAlgID.equals((Object)CMS.aes256_cbc) ? CMSUtils.generateRandomBytes(16) : CMSUtils.generateRandomBytes(8);
                this.cipher.init(1, (Key)this.contentEncryptionKey, new IvParameterSpec(iv));
                this.contentEncryptionAlgID = new CBCAlgorithmIdentifier(contentEncryptionAlgID.getOID(), iv);
            } else {
                this.cipher.init(1, this.contentEncryptionKey);
                this.contentEncryptionAlgID = contentEncryptionAlgID;
            }
        }
        catch (InvalidKeyException ex) {
            throw new NoSuchAlgorithmException(ex.toString());
        }
        catch (NoSuchPaddingException ex) {
            throw new NoSuchAlgorithmException(ex.toString());
        }
        catch (InvalidAlgorithmParameterException ed) {
            throw new NoSuchAlgorithmException(ed.toString());
        }
        this.recipients = recipients;
        this.writeContent = writeContent;
        this.enclosedContentType = enclosedContentType;
        this.writingToConnector = true;
    }

    public CMSEnvelopedDataOutputStream(CMSOutputConnector conn, ASN1ObjectID enclosedContentType, AlgorithmIdentifier contentEncryptionAlgID, Vector recipients, boolean writeContent, OriginatorInfo origInfo, AttributeSet unprotectedAttribs) throws NoSuchAlgorithmException {
        super(conn.getOutputStream());
        this.enclosedContentType = enclosedContentType;
        byte[] random = new byte[8];
        SecureRandom sr = new SecureRandom();
        String algoName = CMSUtils.getAlgoName(contentEncryptionAlgID, true);
        KeyGenerator kg = KeyGenerator.getInstance(algoName);
        int keysize = 0;
        if (contentEncryptionAlgID.equals((Object)CMS.aes128_cbc) || contentEncryptionAlgID.equals((Object)CMS.aes192_cbc) || contentEncryptionAlgID.equals((Object)CMS.aes256_cbc)) {
            keysize = CMSUtils.getKeySize(contentEncryptionAlgID);
            kg.init(keysize, sr);
        } else {
            kg.init(sr);
        }
        this.contentEncryptionKey = kg.generateKey();
        this.cipher = null;
        String AlgoName = null;
        try {
            AlgoName = CMSUtils.getAlgoName(contentEncryptionAlgID);
            this.cipher = contentEncryptionAlgID.equals((Object)CMS.aes128_cbc) || contentEncryptionAlgID.equals((Object)CMS.aes192_cbc) || contentEncryptionAlgID.equals((Object)CMS.aes256_cbc) ? Cipher.getInstance("AES/CBC/PKCS5Padding") : Cipher.getInstance(CMSUtils.addPadding(AlgoName));
            if (AlgoName.indexOf("CBC") != -1) {
                byte[] iv = null;
                iv = contentEncryptionAlgID.equals((Object)CMS.aes128_cbc) || contentEncryptionAlgID.equals((Object)CMS.aes192_cbc) || contentEncryptionAlgID.equals((Object)CMS.aes256_cbc) ? CMSUtils.generateRandomBytes(16) : CMSUtils.generateRandomBytes(8);
                this.cipher.init(1, (Key)this.contentEncryptionKey, new IvParameterSpec(iv));
                this.contentEncryptionAlgID = new CBCAlgorithmIdentifier(contentEncryptionAlgID.getOID(), iv);
            } else {
                this.cipher.init(1, this.contentEncryptionKey);
                this.contentEncryptionAlgID = contentEncryptionAlgID;
            }
        }
        catch (InvalidKeyException ex) {
            throw new NoSuchAlgorithmException(ex.toString());
        }
        catch (NoSuchPaddingException ex) {
            throw new NoSuchAlgorithmException(ex.toString());
        }
        catch (InvalidAlgorithmParameterException ex) {
            throw new NoSuchAlgorithmException(ex.toString());
        }
        this.recipients = recipients;
        this.writeContent = writeContent;
        this.origInfo = origInfo;
        this.unprotectedAttribs = unprotectedAttribs;
        this.writingToConnector = true;
    }

    private void ensurePrefaceOutput() throws IOException {
        if (!this.prefaceOutput) {
            if (!this.writingToConnector) {
                ASN1Utils.outputHeader((OutputStream)this.out, (int)16, (int)0);
                CMS.id_envelopedData.output(this.out);
                ASN1Utils.outputHeader((OutputStream)this.out, (int)0, (int)128);
            }
            ASN1Utils.outputHeader((OutputStream)this.out, (int)16, (int)0);
            boolean version0 = true;
            if (this.origInfo != null) {
                version0 = false;
            }
            Enumeration e = this.recipients.elements();
            while (version0 && e.hasMoreElements()) {
                CMSRecipientInfoSpec ris = (CMSRecipientInfoSpec)e.nextElement();
                if (!(ris instanceof CMSKeyTransRecipientInfoSpec)) {
                    version0 = false;
                    continue;
                }
                if (((CMSKeyTransRecipientInfoSpec)ris).getSPKI() == null) continue;
                version0 = false;
            }
            if (this.unprotectedAttribs != null) {
                version0 = false;
            }
            if (version0) {
                ASN1Integer.outputValue((OutputStream)this.out, (int)0);
            } else {
                ASN1Integer.outputValue((OutputStream)this.out, (int)2);
            }
            if (this.origInfo != null) {
                ((ASN1GenericConstructed)ASN1Utils.addImplicitTag((ASN1Object)this.origInfo, (int)0)).output(this.out);
            }
            ASN1Utils.outputHeader((OutputStream)this.out, (int)17, (int)0);
            try {
                e = this.recipients.elements();
                while (e.hasMoreElements()) {
                    CMSRecipientInfo ri;
                    CMSRecipientInfoSpec rispec;
                    CMSRecipientInfoSpec spec = (CMSRecipientInfoSpec)e.nextElement();
                    if (spec instanceof CMSKeyTransRecipientInfoSpec) {
                        rispec = (CMSKeyTransRecipientInfoSpec)spec;
                        if (((CMSKeyTransRecipientInfoSpec)rispec).getSPKI() == null) {
                            ri = new CMSKeyTransRecipientInfo(this.contentEncryptionKey, ((CMSKeyTransRecipientInfoSpec)rispec).getRecipientKey(), ((CMSKeyTransRecipientInfoSpec)rispec).getIASN(), ((CMSKeyTransRecipientInfoSpec)rispec).getKeyEncryptionAlgID());
                            ((CMSKeyTransRecipientInfo)ri).output(this.out);
                            continue;
                        }
                        ri = new CMSKeyTransRecipientInfo(this.contentEncryptionKey, ((CMSKeyTransRecipientInfoSpec)rispec).getRecipientKey(), ((CMSKeyTransRecipientInfoSpec)rispec).getSPKI(), ((CMSKeyTransRecipientInfoSpec)rispec).getKeyEncryptionAlgID());
                        ((CMSKeyTransRecipientInfo)ri).output(this.out);
                        continue;
                    }
                    if (spec instanceof CMSKEKRecipientInfoSpec) {
                        rispec = (CMSKEKRecipientInfoSpec)spec;
                        ri = new CMSKEKRecipientInfo(this.contentEncryptionKey, (CMSKEKRecipientInfoSpec)rispec);
                        ((ASN1GenericConstructed)ASN1Utils.addImplicitTag((ASN1Object)ri, (int)2)).output(this.out);
                        continue;
                    }
                    throw new IOException("unknown CMSRecipientInfo ");
                }
            }
            catch (NoSuchPaddingException ex) {
                throw new OutputGenerationException((Exception)ex);
            }
            catch (InvalidKeyException ex) {
                throw new OutputGenerationException((Exception)ex);
            }
            catch (NoSuchAlgorithmException ex) {
                throw new OutputGenerationException((Exception)ex);
            }
            catch (BadPaddingException ex) {
                throw new OutputGenerationException((Exception)ex);
            }
            catch (IllegalBlockSizeException ex) {
                throw new OutputGenerationException((Exception)ex);
            }
            catch (InvalidAlgorithmParameterException ex) {
                throw new OutputGenerationException((Exception)ex);
            }
            catch (InvalidKeySpecException ex) {
                throw new OutputGenerationException((Exception)ex);
            }
            ASN1Utils.outputEndOfContents((OutputStream)this.out);
            this.content_out = new ECIOutputStream(this.out, this.cipher, this.enclosedContentType, this.contentEncryptionAlgID);
            this.content_out.writeInitial(this.writeContent);
            this.prefaceOutput = true;
        }
    }

    @Override
    public void terminate() throws IOException {
        this.ensurePrefaceOutput();
        this.content_out.writeFinal();
        if (this.unprotectedAttribs != null) {
            ASN1Utils.addImplicitTag((ASN1Object)this.unprotectedAttribs, (int)1).output(this.out);
        }
        ASN1Utils.outputEndOfContents((OutputStream)this.out);
        if (!this.writingToConnector) {
            ASN1Utils.outputEndOfContents((OutputStream)this.out);
            ASN1Utils.outputEndOfContents((OutputStream)this.out);
        } else {
            ((CMSOutputStream)this.out).terminate();
        }
        this.terminated = true;
    }

    @Override
    public void write(int ch) throws IOException {
        this.ensurePrefaceOutput();
        this.content_out.write(ch);
    }

    @Override
    public void write(byte[] b, int offset, int len) throws IOException {
        this.ensurePrefaceOutput();
        this.content_out.write(b, offset, len);
    }

    @Override
    public void close() throws IOException {
        if (!this.terminated) {
            this.terminate();
        }
        super.close();
    }

    @Override
    public ASN1ObjectID getExposedContentType() {
        return CMS.id_envelopedData;
    }
}

