/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.htmlBrowser;

import ice.pilots.html4.ThePilot;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import oracle.bali.ewt.plaf.UIUtils;
import oracle.bali.share.thread.Task;
import oracle.bali.share.thread.TaskEvent;
import oracle.bali.share.thread.TaskScheduler;
import oracle.help.htmlBrowser.ICEBrowser;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.MouseEvent;

public class ICEToolTipManager
implements EventListener,
AncestorListener {
    private String _currentAltText = null;
    private Point _lastPoint = new Point();
    private ToolTipTask _currentTask = null;
    private BrowserToolTip _theTip = new BrowserToolTip();
    private ICEBrowser _browser;
    private JLayeredPane _currentOwner;
    private static final int TOOLTIP_DELAY = 500;
    private static final int CURSOR_SIZE = 18;
    private static final String EVENT_MOUSE_OVER = "mouseover";
    private static final String EVENT_MOUSE_OUT = "mouseout";
    private static final String EVENT_MOUSE_MOVE = "mousemove";
    private static final String ATTR_ALT = "alt";
    private static final String ATTR_TITLE = "title";

    public ICEToolTipManager(ICEBrowser browser) {
        this._browser = browser;
        this._browser.addAncestorListener(this);
    }

    public void registerToolTipListeners(ThePilot htmlPilot) {
        if (htmlPilot != null) {
            htmlPilot.addPersistentDOMEventListener(EVENT_MOUSE_OVER, (EventListener)this, true);
            htmlPilot.addPersistentDOMEventListener(EVENT_MOUSE_OUT, (EventListener)this, true);
            htmlPilot.addPersistentDOMEventListener(EVENT_MOUSE_MOVE, (EventListener)this, true);
        }
    }

    @Override
    public void handleEvent(Event e) {
        String type = e.getType();
        if (type != null) {
            if (EVENT_MOUSE_OVER.equals(type)) {
                Node target;
                if (this._currentOwner != null) {
                    this._hideToolTip();
                }
                String altText = null;
                for (Node current = target = (Node)((Object)e.getTarget()); current != null && altText == null; current = current.getParentNode()) {
                    if (!(current instanceof Element)) continue;
                    Element elem = (Element)current;
                    altText = elem.getAttribute(ATTR_ALT);
                    if (altText == null) {
                        altText = elem.getAttribute(ATTR_TITLE);
                    }
                    if (altText == null || (altText = altText.trim()).length() != 0) continue;
                    altText = null;
                }
                if (altText != null) {
                    this._currentAltText = altText;
                    this._currentTask = new ToolTipTask(target);
                    TaskScheduler.getDefaultTaskScheduler().schedule((Task)this._currentTask, 500);
                }
            } else if (EVENT_MOUSE_OUT.equals(type)) {
                if (this._currentTask != null && this._currentTask.getToolTipNode() == e.getTarget()) {
                    this._hideToolTip();
                }
            } else if (EVENT_MOUSE_MOVE.equals(type)) {
                MouseEvent mEvent = (MouseEvent)e;
                this._lastPoint.x = mEvent.getClientX();
                this._lastPoint.y = mEvent.getClientY();
                if (this._currentOwner == null && this._currentTask != null) {
                    this._currentTask = new ToolTipTask(this._currentTask.getToolTipNode());
                    TaskScheduler.getDefaultTaskScheduler().schedule((Task)this._currentTask, 500);
                }
            }
        }
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
        this._hideToolTip();
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
    }

    private void _showToolTip(Task forTask) {
        if (forTask != this._currentTask) {
            return;
        }
        if (this._currentAltText != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ICEToolTipManager.this._theTip.setTipText(ICEToolTipManager.this._currentAltText);
                    JRootPane rootPane = ICEToolTipManager.this._browser.getRootPane();
                    ICEToolTipManager.this._currentOwner = rootPane.getLayeredPane();
                    ICEToolTipManager.this._currentOwner.add((Component)ICEToolTipManager.this._theTip, JLayeredPane.POPUP_LAYER);
                    Point location = ICEToolTipManager.this._translatePoint(ICEToolTipManager.this._browser, rootPane, ICEToolTipManager.this._lastPoint.x, ICEToolTipManager.this._lastPoint.y);
                    ICEToolTipManager.this._theTip.setLocation(location.x, location.y + 18);
                    ICEToolTipManager.this._theTip.setVisible(true);
                }
            });
        }
    }

    private void _hideToolTip() {
        if (this._currentTask != null) {
            TaskScheduler.getDefaultTaskScheduler().cancel((Task)this._currentTask);
            this._currentTask = null;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ICEToolTipManager.this._currentOwner != null) {
                    ICEToolTipManager.this._theTip.setVisible(false);
                    ICEToolTipManager.this._currentOwner.remove(ICEToolTipManager.this._theTip);
                    ICEToolTipManager.this._currentOwner = null;
                }
            }
        });
    }

    private Point _translatePoint(Component from, Component to, int x, int y) {
        while (from != to) {
            Point location = from.getLocation();
            x += location.x;
            y += location.y;
            from = from.getParent();
        }
        return new Point(x, y);
    }

    private class ToolTipTask
    implements Task {
        private Node _node;

        public ToolTipTask(Node toolTipNode) {
            this._node = toolTipNode;
        }

        public void runTask(TaskEvent e) {
            ICEToolTipManager.this._showToolTip(this);
        }

        public Node getToolTipNode() {
            return this._node;
        }
    }

    private class BrowserToolTip
    extends JComponent {
        private JLabel _tipLabel = new JLabel("");

        public BrowserToolTip() {
            this.setLayout(new BorderLayout());
            this.add((Component)this._tipLabel, "Center");
            this.setBackground(UIManager.getColor("ToolTip.background"));
            this.setForeground(UIManager.getColor("ToolTip.foreground"));
            this.setBorder(UIManager.getBorder("ToolTip.border"));
        }

        public void setTipText(String tipText) {
            this._tipLabel.setText(" " + tipText + " ");
            Dimension labelSize = this._tipLabel.getPreferredSize();
            this.setSize(labelSize.width + 8, labelSize.height + 8);
        }

        @Override
        protected void paintComponent(Graphics g) {
            UIUtils.fillBackground((Graphics)g, (JComponent)this);
        }
    }
}

