/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp.transport;

import java.io.IOException;
import java.io.InputStream;
import oracle.security.crypto.cmp.transport.TCPMessage;
import oracle.security.crypto.util.FixedByteArrayOutputStream;
import oracle.security.crypto.util.StreamableOutputException;
import oracle.security.crypto.util.Utils;

public class PollResponseTCPMsg
extends TCPMessage {
    private static final TCPMessage.Type TYPE = TCPMessage.Type.POLL_REP;
    private int pollRef;
    private int checkBackTime;
    private transient byte[] contents;

    public PollResponseTCPMsg(TCPMessage.Version version, int pollRef, int checkBackTime) {
        super(version);
        this.pollRef = pollRef;
        this.checkBackTime = checkBackTime;
    }

    public PollResponseTCPMsg(int pollRef, int checkBackTime) {
        this(TCPMessage.Version.CMP2000, pollRef, checkBackTime);
    }

    public PollResponseTCPMsg(InputStream is) throws IOException {
        this.input(is);
    }

    @Override
    public TCPMessage.Type getType() {
        return TYPE;
    }

    public int getPollRef() {
        return this.pollRef;
    }

    public int getCheckBackTime() {
        return this.checkBackTime;
    }

    @Override
    byte[] getValueBytes() {
        if (this.contents == null) {
            try {
                FixedByteArrayOutputStream baos = new FixedByteArrayOutputStream(8);
                baos.write(Utils.wordToBytes((int)this.pollRef));
                baos.write(Utils.wordToBytes((int)this.checkBackTime));
                this.contents = baos.toByteArray();
            }
            catch (IOException ie) {
                throw new StreamableOutputException("Error generating PollResponseTCPMsg bytes");
            }
        }
        return this.contents;
    }

    @Override
    void setValueBytes(byte[] value) {
        this.pollRef = Utils.bytesToWord((int)value[0], (int)value[1], (int)value[2], (int)value[3]);
        this.checkBackTime = Utils.bytesToWord((int)value[4], (int)value[5], (int)value[6], (int)value[7]);
        this.contents = value;
    }

    @Override
    void clearCache() {
        this.contents = null;
    }

    public String toString() {
        return TYPE + " { pollRef = " + this.pollRef + ", checkBackTime = " + this.checkBackTime + " }";
    }
}

