/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1ConstructedInputStream;
import oracle.security.crypto.asn1.ASN1Date;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.asn1.ASN1String;
import oracle.security.crypto.cert.AttributeTypeAndValue;
import oracle.security.crypto.cert.AttributeTypeAndValueList;
import oracle.security.crypto.cert.GeneralName;
import oracle.security.crypto.cmp.CMPUtils;
import oracle.security.crypto.cmp.PKIMessage;
import oracle.security.crypto.cmp.attribute.InfoTypeAndValue;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.PasswordBasedMAC;
import oracle.security.crypto.core.RandomBitsSource;
import oracle.security.crypto.util.OIDManager;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VersionException;

public class PKIMessageHeader
implements ASN1Object {
    private PKIMessage.Version version;
    private GeneralName sender;
    private GeneralName recipient;
    private Date messageTime;
    private AlgorithmIdentifier protectionAlg;
    private byte[] senderKID;
    private byte[] recipKID;
    private byte[] transactionID;
    private byte[] senderNonce;
    private byte[] recipNonce;
    private Vector freeText;
    private AttributeTypeAndValueList generalInfo;
    private transient PasswordBasedMAC pbMac;
    private transient Signature sig;
    private transient ASN1Object contents;

    public PKIMessageHeader() {
    }

    public PKIMessageHeader(GeneralName sender, GeneralName recipient) {
        this(sender, recipient, PKIMessage.Version.CMP2000);
    }

    public PKIMessageHeader(GeneralName sender, GeneralName recipient, PKIMessage.Version version) {
        this.sender = sender;
        this.recipient = recipient;
        this.version = version;
    }

    public PKIMessageHeader(InputStream is) throws IOException {
        this.input(is);
    }

    public GeneralName getSender() {
        return this.sender;
    }

    public GeneralName getRecipient() {
        return this.recipient;
    }

    public PKIMessage.Version getVersion() {
        return this.version;
    }

    public void setMessageTime(Date messageTime) {
        this.messageTime = messageTime;
        this.update();
    }

    public Date getMessageTime() {
        return this.messageTime;
    }

    public void setMessageProtection(AlgorithmIdentifier macAlgID, byte[] password) throws AlgorithmIdentifierException {
        this.pbMac = macAlgID.getParameters() != null ? new PasswordBasedMAC(macAlgID, password) : new PasswordBasedMAC(macAlgID, password, RandomBitsSource.getDefault());
        this.sig = null;
        this.setProtectionAlgID(this.pbMac.getAlgID());
    }

    public void setMessageProtection(byte[] password) throws AlgorithmIdentifierException {
        this.setMessageProtection(AlgID.PasswordBasedMac, password);
    }

    public void setMessageProtection(AlgorithmIdentifier sigAlgID, PrivateKey privKey) throws NoSuchAlgorithmException, InvalidKeyException {
        this.sig = Signature.getInstance(CMPUtils.getAlgoName(sigAlgID));
        this.sig.initSign(privKey);
        this.pbMac = null;
        this.setProtectionAlgID(CMPUtils.getAlgoID(this.sig.getAlgorithm()));
    }

    public void setMessageProtection(PrivateKey privKey) throws NoSuchAlgorithmException, InvalidKeyException {
        String algo = null;
        algo = privKey.getAlgorithm().equals("RSA") ? "MD5withRSA" : (privKey.getAlgorithm().equals("DSA") ? "SHA-1withDSA" : privKey.getAlgorithm());
        this.sig = Signature.getInstance(algo);
        this.sig.initSign(privKey);
        this.pbMac = null;
        this.setProtectionAlgID(CMPUtils.getAlgoID(this.sig.getAlgorithm()));
    }

    private void setProtectionAlgID(AlgorithmIdentifier protectionAlg) {
        this.protectionAlg = protectionAlg;
        this.update();
    }

    public AlgorithmIdentifier getProtectionAlgID() {
        return this.protectionAlg;
    }

    byte[] computeProtectionBytes(byte[] protectedPart) throws SignatureException {
        if (this.pbMac != null) {
            return this.pbMac.computeDigest(protectedPart);
        }
        if (this.sig != null) {
            this.sig.update(protectedPart);
            return this.sig.sign();
        }
        return null;
    }

    public void setSenderKID(byte[] senderKID) {
        this.senderKID = senderKID;
        this.update();
    }

    public byte[] getSenderKID() {
        return this.senderKID;
    }

    public void setRecipKID(byte[] recipKID) {
        this.recipKID = recipKID;
        this.update();
    }

    public byte[] getRecipKID() {
        return this.recipKID;
    }

    public void setTransactionID(byte[] transactionID) {
        this.transactionID = transactionID;
        this.update();
    }

    public byte[] getTransactionID() {
        return this.transactionID;
    }

    public void setSenderNonce(byte[] senderNonce) {
        this.senderNonce = senderNonce;
        this.update();
    }

    public byte[] generateSenderNonce() throws NoSuchAlgorithmException {
        SecureRandom sr = SecureRandom.getInstance("SHA1PRNG");
        byte[] random = new byte[16];
        byte[] seed = SecureRandom.getSeed(20);
        sr.setSeed(seed);
        sr.nextBytes(random);
        this.setSenderNonce(random);
        return this.senderNonce;
    }

    public byte[] getSenderNonce() {
        return this.senderNonce;
    }

    public void setRecipNonce(byte[] recipNonce) {
        this.recipNonce = recipNonce;
        this.update();
    }

    public byte[] getRecipNonce() {
        return this.recipNonce;
    }

    public void addFreeText(String text) {
        if (this.freeText == null) {
            this.freeText = new Vector();
        }
        this.freeText.addElement(text);
        this.update();
    }

    public Vector getFreeText() {
        return this.freeText;
    }

    public void addGeneralInfo(InfoTypeAndValue info) {
        if (this.generalInfo == null) {
            this.generalInfo = new AttributeTypeAndValueList();
        }
        this.generalInfo.addAttribute((AttributeTypeAndValue)info);
        this.update();
    }

    public void addGeneralInfo(ASN1ObjectID type, ASN1Object value) {
        InfoTypeAndValue info = null;
        Class c = OIDManager.getOIDManager().getMapping(type, "infoTypeAndValue");
        if (c != null) {
            try {
                info = (InfoTypeAndValue)((Object)c.newInstance());
                info.setValue(value);
            }
            catch (IllegalAccessException ex) {
                info = null;
            }
            catch (InstantiationException ex) {
                info = null;
            }
            catch (ClassCastException ex) {
                info = null;
            }
        }
        if (info == null) {
            info = new InfoTypeAndValue(type, value);
        }
        this.addGeneralInfo(info);
    }

    public void addGeneralInfo(ASN1ObjectID type) {
        this.addGeneralInfo(type, null);
    }

    public AttributeTypeAndValueList getGeneralInfo() {
        return this.generalInfo;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("{ version = ");
        s.append(this.version);
        s.append(", sender = ");
        s.append(this.sender);
        s.append(", recipient = ");
        s.append(this.recipient);
        s.append(',');
        if (this.messageTime != null) {
            s.append(" messageTime = ");
            s.append(this.messageTime);
            s.append(',');
        }
        if (this.protectionAlg != null) {
            s.append(" protectionAlg = ");
            s.append(this.protectionAlg);
            s.append(',');
        }
        if (this.senderKID != null) {
            s.append(" senderKID = ");
            s.append(Utils.toHexString((byte[])this.senderKID));
            s.append(',');
        }
        if (this.recipKID != null) {
            s.append(" recipKID = ");
            s.append(Utils.toHexString((byte[])this.recipKID));
            s.append(',');
        }
        if (this.transactionID != null) {
            s.append(" transactionID = ");
            s.append(Utils.toHexString((byte[])this.transactionID));
            s.append(',');
        }
        if (this.senderNonce != null) {
            s.append(" senderNonce = ");
            s.append(Utils.toHexString((byte[])this.senderNonce));
            s.append(',');
        }
        if (this.recipNonce != null) {
            s.append(" recipNonce = ");
            s.append(Utils.toHexString((byte[])this.recipNonce));
            s.append(',');
        }
        if (this.freeText != null) {
            s.append(" freeText = {");
            int n = this.freeText.size();
            for (int i = 0; i < n; ++i) {
                s.append(" \"");
                s.append((String)this.freeText.elementAt(i));
                s.append('\"');
                if (i == n - 1) continue;
                s.append(',');
            }
            s.append(" }");
            s.append(',');
        }
        if (this.generalInfo != null) {
            s.append(" generalInfo = ");
            s.append(this.generalInfo);
        }
        if (s.charAt(s.length() - 1) == ',') {
            s.setLength(s.length() - 1);
        }
        s.append(" }");
        return s.toString();
    }

    public void input(InputStream is) throws IOException {
        ASN1ConstructedInputStream cis;
        this.update();
        this.contents = new ASN1Sequence(is);
        ASN1SequenceInputStream seq = new ASN1SequenceInputStream(Utils.toStream((Streamable)this.contents));
        this.version = PKIMessage.Version.getVersion(ASN1Integer.inputValue((InputStream)seq).intValue());
        if (this.version != PKIMessage.Version.CMP1999 && this.version != PKIMessage.Version.CMP2000) {
            throw new VersionException("Unsupported version: " + this.version);
        }
        this.sender = new GeneralName((InputStream)seq);
        this.recipient = new GeneralName((InputStream)seq);
        if (seq.hasMoreData() && seq.getCurrentTag() == 0) {
            cis = new ASN1ConstructedInputStream((InputStream)seq, 0);
            this.messageTime = ASN1Date.inputValue((InputStream)cis);
            cis.terminate();
        } else {
            this.messageTime = null;
        }
        if (seq.hasMoreData() && seq.getCurrentTag() == 1) {
            cis = new ASN1ConstructedInputStream((InputStream)seq, 1);
            this.protectionAlg = new AlgorithmIdentifier((InputStream)cis);
            cis.terminate();
        } else {
            this.protectionAlg = null;
        }
        if (seq.hasMoreData() && seq.getCurrentTag() == 2) {
            cis = new ASN1ConstructedInputStream((InputStream)seq, 2);
            this.senderKID = ASN1OctetString.inputValue((InputStream)cis);
            cis.terminate();
        } else {
            this.senderKID = null;
        }
        if (seq.hasMoreData() && seq.getCurrentTag() == 3) {
            cis = new ASN1ConstructedInputStream((InputStream)seq, 3);
            this.recipKID = ASN1OctetString.inputValue((InputStream)cis);
            cis.terminate();
        } else {
            this.recipKID = null;
        }
        if (seq.hasMoreData() && seq.getCurrentTag() == 4) {
            cis = new ASN1ConstructedInputStream((InputStream)seq, 4);
            this.transactionID = ASN1OctetString.inputValue((InputStream)cis);
            cis.terminate();
        } else {
            this.transactionID = null;
        }
        if (seq.hasMoreData() && seq.getCurrentTag() == 5) {
            cis = new ASN1ConstructedInputStream((InputStream)seq, 5);
            this.senderNonce = ASN1OctetString.inputValue((InputStream)cis);
            cis.terminate();
        } else {
            this.senderNonce = null;
        }
        if (seq.hasMoreData() && seq.getCurrentTag() == 6) {
            cis = new ASN1ConstructedInputStream((InputStream)seq, 6);
            this.recipNonce = ASN1OctetString.inputValue((InputStream)cis);
            cis.terminate();
        } else {
            this.recipNonce = null;
        }
        if (seq.hasMoreData() && seq.getCurrentTag() == 7) {
            cis = new ASN1ConstructedInputStream((InputStream)seq, 7);
            ASN1SequenceInputStream fis = new ASN1SequenceInputStream((InputStream)cis);
            this.freeText = new Vector();
            while (fis.hasMoreData()) {
                this.freeText.addElement(ASN1String.inputValue((InputStream)fis));
            }
            fis.terminate();
            cis.terminate();
        } else {
            this.freeText = null;
        }
        if (seq.hasMoreData() && seq.getCurrentTag() == 8) {
            cis = new ASN1ConstructedInputStream((InputStream)seq, 8);
            this.generalInfo = new AttributeTypeAndValueList();
            ASN1SequenceInputStream sisInfo = new ASN1SequenceInputStream((InputStream)cis);
            while (sisInfo.hasMoreData()) {
                this.generalInfo.addAttribute((AttributeTypeAndValue)InfoTypeAndValue.inputInstance((InputStream)sisInfo));
            }
            sisInfo.terminate();
            cis.terminate();
        } else {
            this.generalInfo = null;
        }
        if (seq.hasMoreData()) {
            throw new ASN1FormatException("Unexpected header field tag: " + seq.getCurrentTag());
        }
        seq.terminate();
    }

    public void output(OutputStream os) throws IOException {
        this.toASN1().output(os);
    }

    public int length() {
        return this.toASN1().length();
    }

    private ASN1Object toASN1() {
        if (this.contents == null) {
            ASN1Sequence s = new ASN1Sequence();
            s.addElement((ASN1Object)new ASN1Integer((long)this.version.getValue()));
            s.addElement((ASN1Object)this.sender);
            s.addElement((ASN1Object)this.recipient);
            if (this.messageTime != null) {
                Calendar c = Calendar.getInstance();
                c.setTime(this.messageTime);
                s.addElement((ASN1Object)new ASN1GenericConstructed((ASN1Object)new ASN1Date(this.messageTime, c.get(1) > 2049), 0));
            }
            if (this.protectionAlg != null) {
                s.addElement((ASN1Object)new ASN1GenericConstructed((ASN1Object)this.protectionAlg, 1));
            }
            if (this.senderKID != null) {
                s.addElement((ASN1Object)new ASN1GenericConstructed((ASN1Object)new ASN1OctetString(this.senderKID), 2));
            }
            if (this.recipKID != null) {
                s.addElement((ASN1Object)new ASN1GenericConstructed((ASN1Object)new ASN1OctetString(this.recipKID), 3));
            }
            if (this.transactionID != null) {
                s.addElement((ASN1Object)new ASN1GenericConstructed((ASN1Object)new ASN1OctetString(this.transactionID), 4));
            }
            if (this.senderNonce != null) {
                s.addElement((ASN1Object)new ASN1GenericConstructed((ASN1Object)new ASN1OctetString(this.senderNonce), 5));
            }
            if (this.recipNonce != null) {
                s.addElement((ASN1Object)new ASN1GenericConstructed((ASN1Object)new ASN1OctetString(this.recipNonce), 6));
            }
            if (this.freeText != null && this.freeText.size() > 0) {
                ASN1Sequence f = new ASN1Sequence();
                int n = this.freeText.size();
                for (int i = 0; i < n; ++i) {
                    f.addElement((ASN1Object)new ASN1String((String)this.freeText.elementAt(i), 12));
                }
                s.addElement((ASN1Object)new ASN1GenericConstructed((ASN1Object)f, 7));
            }
            if (this.generalInfo != null) {
                s.addElement((ASN1Object)new ASN1GenericConstructed((ASN1Object)this.generalInfo, 8));
            }
            this.contents = s;
        }
        return this.contents;
    }

    private void update() {
        this.contents = null;
    }
}

