/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.fe.common;

import java.sql.SQLException;
import java.util.HashMap;
import oracle.dmt.dataminer.core.dal.sql.builder.Conditional;
import oracle.dmt.dataminer.core.dal.sql.builder.Distinct;
import oracle.dmt.dataminer.core.dal.sql.builder.SqlBuilder;
import oracle.dmt.dataminer.core.dal.sql.mapping.common.SqlStringMapper;
import oracle.dmt.dataminer.core.dal.sql.queries.SqlBaseModelQuery;
import oracle.dmt.dataminer.core.model.common.build.ModelDescriptor;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.workflow.xmlschema.ExplicitSemanticAnalysisModelType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NonNegativeMatrixFactorModelType;
import oracle.dmt.dataminer.workflow.xmlschema.PCAModelType;
import oracle.dmt.dataminer.workflow.xmlschema.SVDModelType;
import oracle.javatools.util.Version;
import oracle.jdbc.internal.OraclePreparedStatement;

public class GetFeatureAttributesQuery
extends SqlBaseModelQuery<String, OraclePreparedStatement> {
    protected Class<? extends ModelType> modelType;

    public GetFeatureAttributesQuery(Version version, Class<? extends ModelType> clazz, ModelDescriptor modelDescriptor) {
        super(version, new SqlStringMapper(), modelDescriptor);
        assert (clazz != null) : "Model Type cannot be null";
        this.modelType = clazz;
    }

    @Override
    protected String getSQLCommand() {
        SqlBuilder sqlBuilder = new SqlBuilder().select(Distinct.columns("ATTRIBUTE_NAME")).from(this.getCoefficientsTable()).where(Conditional.equals("PARTITION_NAME", this.getPartitionId()));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("SCHEMA", this.getSchema());
        hashMap.put("MODEL_NAME", this.getModelName());
        String string = StringUtils.getReplacedString(sqlBuilder.toString(), hashMap);
        return string;
    }

    @Override
    protected void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
        if (this.isPartitioned()) {
            oraclePreparedStatement.setStringAtName("PARTITION_NAME", this.getPartitionId());
        }
    }

    protected String getCoefficientsTable() {
        assert (ExplicitSemanticAnalysisModelType.class.equals(this.modelType) || PCAModelType.class.equals(this.modelType) || SVDModelType.class.equals(this.modelType) || NonNegativeMatrixFactorModelType.class.equals(this.modelType)) : "Invalid Model Type";
        String string = "";
        if (DbVersionHelper.isDB122Up(this.dbVersion)) {
            if (ExplicitSemanticAnalysisModelType.class.equals(this.modelType)) {
                string = "{$SCHEMA}.DM$VA{$MODEL_NAME}";
            } else if (PCAModelType.class.equals(this.modelType) || SVDModelType.class.equals(this.modelType)) {
                string = "{$SCHEMA}.DM$VV{$MODEL_NAME}";
            } else if (NonNegativeMatrixFactorModelType.class.equals(this.modelType)) {
                string = "{$SCHEMA}.DM$VE{$MODEL_NAME}";
            }
        } else if (PCAModelType.class.equals(this.modelType) || SVDModelType.class.equals(this.modelType)) {
            string = "TABLE(dbms_data_mining.GET_MODEL_DETAILS_SVD('{$SCHEMA}.{$MODEL_NAME}'))";
        } else if (NonNegativeMatrixFactorModelType.class.equals(this.modelType)) {
            string = "TABLE(dbms_data_mining.GET_MODEL_DETAILS_NMF('{$SCHEMA}.{$MODEL_NAME}')) T, TABLE (T.ATTRIBUTE_SET)";
        }
        return string;
    }
}

