/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.builder;

import java.util.List;
import java.util.stream.Collectors;
import oracle.dmt.dataminer.core.model.filter.SortSpec;

public class Order {
    public static String ASC(String ... stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return "";
        }
        return String.format("%s %s", new Object[]{String.join((CharSequence)",", stringArray), SortDirection.ASC});
    }

    public static String DESC(String ... stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return "";
        }
        return String.format("%s %s", new Object[]{String.join((CharSequence)",", stringArray), SortDirection.DESC});
    }

    public static String BySpec(List<SortSpec> list) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        String string = list.stream().filter(sortSpec -> sortSpec.isUseIt()).map(sortSpec -> String.format("\"%s\" %s", new Object[]{sortSpec.getAttributeName(), sortSpec.isAscending() ? SortDirection.ASC : SortDirection.DESC_NULLS_LAST})).collect(Collectors.joining(","));
        return string;
    }

    private static enum SortDirection {
        ASC("ASC"),
        DESC("DESC"),
        DESC_NULLS_LAST("DESC NULLS LAST");

        private String sqlSymbol;

        private SortDirection(String string2) {
            this.sqlSymbol = string2;
        }

        public String toString() {
            return this.sqlSymbol;
        }
    }
}

