/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.ruler;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.UIManager;
import oracle.bali.ewt.elaf.EWTRulerUI;
import oracle.bali.ewt.graphics.GraphicUtils;
import oracle.bali.ewt.ruler.RulerStyle;
import oracle.bali.ewt.scrolling.ScrollableComponent;

public class Ruler
extends ScrollableComponent
implements Accessible {
    public static final int MARKER_NOT_VISIBLE = -1;
    private static final int _DEFAULT_SIZE = 20;
    private static final String _TEST_STRING = "111";
    private static final int _NUMBERGAP = 2;
    private static final int _MINIMUMTICKGAP = 3;
    private static final int _EXTRA_SIZE = 7;
    private int _orientation;
    private boolean _showNumbers;
    private RulerStyle _rulerStyle;
    private int _markerPosition;
    private int _scrollPosition;
    private int _increment;

    public Ruler() {
        this(0);
    }

    public Ruler(int orientation) {
        this._orientation = orientation;
        this._markerPosition = -1;
        this._scrollPosition = 0;
        this._showNumbers = true;
        this._increment = 1;
        this.updateUI();
    }

    public int getMarkerPosition() {
        return this._markerPosition;
    }

    public int getScrollPosition() {
        return this._scrollPosition;
    }

    public RulerStyle getRulerStyle() {
        if (this._rulerStyle == null) {
            this._rulerStyle = RulerStyle.getInches();
        }
        return this._rulerStyle;
    }

    public int getOrientation() {
        return this._orientation;
    }

    public boolean getShowNumbers() {
        return this._showNumbers;
    }

    public void setRulerStyle(RulerStyle style) {
        if (style != this._rulerStyle) {
            RulerStyle old = this._rulerStyle;
            this._rulerStyle = style;
            AccessibleContext ac = this.accessibleContext;
            if (ac != null) {
                ac.firePropertyChange("AccessibleVisibleData", old, this._rulerStyle);
            }
            this.repaintInterior();
        }
    }

    public void setOrientation(int orientation) {
        if (orientation != this._orientation) {
            int oldOrientation = this._orientation;
            this._orientation = orientation;
            this.firePropertyChange("orientation", oldOrientation, orientation);
            this.repaintInterior();
        }
    }

    public void setMarkerPosition(int markerPosition) {
        if (this._markerPosition != markerPosition) {
            int old = this._markerPosition;
            this.freezeRepaints();
            try {
                if (this._isHorizontal()) {
                    this.repaintCanvas(this._markerPosition - 1, 0, 2, this.getInnerSize().height);
                } else {
                    this.repaintCanvas(0, this._markerPosition, this.getInnerSize().width, 2);
                }
                this._markerPosition = markerPosition;
                this.firePropertyChange("markerPosition", old, markerPosition);
                if (this._isHorizontal()) {
                    this.repaintCanvas(this._markerPosition - 1, 0, 2, this.getInnerSize().height);
                } else {
                    this.repaintCanvas(0, this._markerPosition, this.getInnerSize().width, 2);
                }
            }
            finally {
                this.unfreezeRepaints();
            }
        }
    }

    public void setShowNumbers(boolean showNumbers) {
        if (showNumbers != this.getShowNumbers()) {
            Boolean old = this._showNumbers;
            this._showNumbers = showNumbers;
            this.firePropertyChange("showNumbers", !showNumbers, showNumbers);
            this.repaintInterior();
        }
    }

    public void setScrollPosition(int scrollPosition) {
        if (scrollPosition != this.getScrollPosition()) {
            int old = this._scrollPosition;
            this._scrollPosition = scrollPosition;
            this.firePropertyChange("scrollPosition", old, this._scrollPosition);
            if (this._isHorizontal()) {
                this.setCanvasOrigin(-this._scrollPosition, 0);
            } else {
                this.setCanvasOrigin(0, -this._scrollPosition);
            }
        }
    }

    public void setNumberIncrement(int increment) {
        if (this._increment != increment) {
            int oldIncrement = this._increment;
            this._increment = increment;
            this.firePropertyChange("numberIncrement", oldIncrement, this._increment);
            this.repaintInterior();
        }
    }

    public int getNumberIncrement() {
        return this._increment;
    }

    public EWTRulerUI getRulerUI() {
        return (EWTRulerUI)this.ui;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleRuler();
        }
        return this.accessibleContext;
    }

    @Override
    public boolean isHScrollable() {
        return this._isHorizontal();
    }

    @Override
    public boolean isVScrollable() {
        return !this._isHorizontal();
    }

    @Override
    public void updateUI() {
        this.setUI((EWTRulerUI)UIManager.getUI(this));
    }

    @Override
    public String getUIClassID() {
        return "EWTRulerUI";
    }

    @Override
    protected Object getPaintData(Object key) {
        if ("ruler.horizontal".equals(key)) {
            return this._isHorizontal() ? Boolean.TRUE : Boolean.FALSE;
        }
        return super.getPaintData(key);
    }

    @Override
    protected void paintCanvasInterior(Graphics g) {
        int pos;
        int minor;
        int major;
        boolean horizontal;
        Rectangle rect = g.getClipBounds();
        if (rect == null) {
            rect = this.getInnerBounds();
        }
        int rulerSize = (horizontal = this._isHorizontal()) ? this.getInnerHeight() : this.getInnerWidth();
        FontMetrics metrics = g.getFontMetrics();
        Color tickColor = g.getColor();
        Color textColor = this.getUIDefaults().getColor("EWTRuler.numberColor");
        int fontHeight = metrics.getAscent() + metrics.getLeading();
        g.setColor(this.getBackground());
        g.fillRect(rect.x, rect.y, rect.width, rect.height);
        if (horizontal) {
            major = rect.x + rect.width;
            minor = rulerSize;
        } else {
            minor = rulerSize;
            major = rect.y + rect.height;
        }
        int textSize = 2 + metrics.stringWidth("888");
        major += textSize;
        RulerStyle rulerStyle = this.getRulerStyle();
        if (rulerStyle.getTickCount() == 0) {
            this._paintMarker(g, rulerSize);
            return;
        }
        double pixels = rulerStyle.getPixelsPerTick();
        if (pixels == 0.0) {
            this._paintMarker(g, rulerSize);
            return;
        }
        int frequency = rulerStyle.getTick(0).getFrequency();
        if (frequency != 0) {
            pixels /= (double)frequency;
        }
        int temp = horizontal ? rect.x : rect.y;
        int tickCount = rulerStyle.getTickCount();
        int tick = (int)Math.round((double)(temp -= textSize) / pixels);
        while ((pos = (int)Math.round(pixels * (double)tick)) <= major) {
            int freq;
            int size = 0;
            for (int i = 0; i < tickCount && (freq = rulerStyle.getTick(i).getFrequency()) != 0; ++i) {
                if (tick % freq != 0 || !(pixels * (double)freq >= 3.0)) continue;
                size = rulerStyle.getTick(i).getSize() * minor / 100;
                break;
            }
            if (size > 0) {
                g.setColor(tickColor);
                if (horizontal) {
                    g.drawLine(pos, rulerSize - size - 1, pos, rulerSize - 1);
                } else {
                    g.drawLine(rulerSize - size - 1, pos, rulerSize - 1, pos);
                }
            }
            freq = rulerStyle.getTick(0).getFrequency();
            if (this.getShowNumbers() && freq != 0 && tick % freq == 0 && pixels * (double)freq >= 3.0) {
                int tempY;
                int tempX;
                long number = (long)tick * (long)this.getNumberIncrement();
                String numberText = Long.toString(number / (long)freq);
                if (horizontal) {
                    tempX = pos + 2;
                    tempY = fontHeight;
                } else {
                    tempX = 2;
                    tempY = pos + fontHeight;
                }
                g.setColor(textColor);
                GraphicUtils.drawString(g, numberText, tempX, tempY);
            }
            ++tick;
        }
        this._paintMarker(g, rulerSize);
    }

    @Override
    protected Dimension layoutCanvas() {
        int width = 0;
        int height = 0;
        Font font = this.getFont();
        int size = font == null ? 20 : this.getFontMetrics(font).stringWidth(_TEST_STRING) + 7;
        Dimension d = this._getScrollPaneContentPreferredSize();
        if (this._isHorizontal()) {
            width = d == null ? 0x1FFFFFFF : d.width;
            height = size;
        } else {
            height = d == null ? 0x1FFFFFFF : d.height;
            width = size;
        }
        return new Dimension(width, height);
    }

    private Dimension _getScrollPaneContentPreferredSize() {
        JScrollPane pane;
        Container gp;
        Object scrollPane = null;
        Container parent = this.getParent();
        if (parent instanceof JViewport && (gp = parent.getParent()) instanceof JScrollPane && (pane = (JScrollPane)gp).getViewport() != null) {
            return pane.getViewport().getViewSize();
        }
        return null;
    }

    private void _paintMarker(Graphics g, int rulerSize) {
        int pos = this.getMarkerPosition();
        if (pos != -1) {
            g.setColor(this.getUIDefaults().getColor("EWTRuler.numberColor"));
            if (this._isHorizontal()) {
                g.drawLine(pos, 0, pos, rulerSize);
            } else {
                g.drawLine(0, pos, rulerSize, pos);
            }
        }
    }

    private boolean _isHorizontal() {
        return this.getOrientation() == 0;
    }

    protected class AccessibleRuler
    extends JComponent.AccessibleJComponent {
        protected AccessibleRuler() {
            super(Ruler.this);
        }
    }
}

