/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.olaf.OracleUIUtils;
import oracle.bali.ewt.olaf.SplitterButton;
import oracle.bali.ewt.painter.FixedImagePainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.painter.PainterTiler;

public class OracleSplitPaneUI
extends BasicSplitPaneUI {
    private static Painter _sDynamicDividerPainter;
    private static Painter _sCenterDynamicDividerPainter;
    private static final Cursor _sHorizontalCursor;
    private static final Cursor _sVerticalCursor;
    private static final Cursor _sDefaultCursor;
    private static final Insets _sEmptyInsets;
    private static final Color _SDividerDotColor;

    public static ComponentUI createUI(JComponent c) {
        return new OracleSplitPaneUI();
    }

    @Override
    public void installUI(JComponent component) {
        super.installUI(component);
        OracleUIUtils.putPaintContext(component);
    }

    @Override
    public void uninstallUI(JComponent component) {
        super.uninstallUI(component);
        OracleUIUtils.removePaintContext(component);
    }

    @Override
    public BasicSplitPaneDivider createDefaultDivider() {
        return new Divider(this);
    }

    @Override
    public void finishedPaintingChildren(JSplitPane splitPane, Graphics g) {
        boolean center;
        int height;
        int width;
        int y;
        int x;
        int lastDrag = this.getLastDragLocation();
        if (lastDrag == -1 || this.isContinuousLayout() || this.draggingHW) {
            return;
        }
        PaintContext context = OracleUIUtils.getPaintContext(splitPane);
        Dimension size = splitPane.getSize();
        int dividerLocation = this.getDividerLocation(splitPane);
        if (this.getOrientation() == 1) {
            x = lastDrag;
            y = 0;
            width = this.dividerSize - 1;
            height = size.height - 1;
            center = x == dividerLocation;
        } else {
            x = 0;
            y = lastDrag;
            width = size.width - 1;
            height = this.dividerSize - 1;
            center = y == dividerLocation;
        }
        Painter painter = center ? this._getCenterDynamicDividerPainter() : this._getDynamicDividerPainter();
        painter.paint(context, g, x, y, width, height);
    }

    private OracleSplitPaneUI() {
    }

    @Override
    protected void resetLayoutManager() {
        super.resetLayoutManager();
        SplitterButton button = ((Divider)this.getDivider()).getSplitterButton();
        button.setOrientation(this.splitPane.getOrientation());
    }

    private Painter _getDynamicDividerPainter() {
        if (_sDynamicDividerPainter == null) {
            _sDynamicDividerPainter = new PainterTiler(new FixedImagePainter(ImageUtils.getImageResource(OracleSplitPaneUI.class, "/oracle/bali/ewt/olaf/icons/SplitpaneDivider.gif")));
        }
        return _sDynamicDividerPainter;
    }

    private Painter _getCenterDynamicDividerPainter() {
        if (_sCenterDynamicDividerPainter == null) {
            _sCenterDynamicDividerPainter = new PainterTiler(new FixedImagePainter(ImageUtils.getImageResource(OracleSplitPaneUI.class, "/oracle/bali/ewt/olaf/icons/SplitpaneCentralDivider.gif")));
        }
        return _sCenterDynamicDividerPainter;
    }

    static {
        _sHorizontalCursor = Cursor.getPredefinedCursor(11);
        _sVerticalCursor = Cursor.getPredefinedCursor(9);
        _sDefaultCursor = Cursor.getPredefinedCursor(0);
        _sEmptyInsets = new Insets(0, 0, 0, 0);
        _SDividerDotColor = new Color(156, 154, 156);
    }

    private class Divider
    extends BasicSplitPaneDivider {
        private SplitterButton _splitterButton;
        private SplitButtonHandler _splitButtonHandler;

        public Divider(BasicSplitPaneUI ui) {
            super(ui);
            this.setLayout(new OracleDividerLayout());
            this._splitterButton = new SplitterButton(this.orientation, this.splitPane.isOneTouchExpandable());
            this._splitterButton.addMouseListener(this.mouseHandler);
            this._splitterButton.addMouseMotionListener(this.mouseHandler);
            this._splitterButton.addActionListener(this._splitButtonHandler);
            this.add(this._splitterButton);
            this._splitterButton.setCursor(_sDefaultCursor);
            this.setCursor(null);
        }

        @Override
        public void setCursor(Cursor c) {
            if (c == null || c.equals(Cursor.getPredefinedCursor(0))) {
                c = this.orientation == 1 ? _sHorizontalCursor : _sVerticalCursor;
            }
            super.setCursor(c);
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Dimension dividerSize = this.getSize();
            Dimension temp = this._splitterButton.getMinimumSize();
            Insets insets = this.getInsets();
            if (insets == null) {
                insets = _sEmptyInsets;
            }
            boolean isHorizontal = this._splitterButton.getOrientation() == 0;
            int alongBaseSize = 0;
            int perpSize = 0;
            int minButtonSize = 0;
            int startX = 0;
            int startY = 0;
            int borders = 0;
            if (isHorizontal) {
                alongBaseSize = dividerSize.width;
                perpSize = dividerSize.height;
                borders = insets.top + insets.bottom;
                minButtonSize = temp.height;
                startX = insets.top;
            } else {
                alongBaseSize = dividerSize.height;
                perpSize = dividerSize.width;
                borders = insets.left + insets.right;
                minButtonSize = temp.width;
                startX = insets.left;
            }
            if (perpSize > borders && perpSize < minButtonSize + borders) {
                if ((perpSize - borders) % 2 == 1) {
                    startX += (perpSize - borders) / 2;
                } else {
                    startX += (perpSize - borders) / 2;
                    if (this._splitterButton.getActualReadingDirection() == 1) {
                        --startX;
                    }
                }
                if (isHorizontal) {
                    startY = startX;
                    startX = alongBaseSize / 2;
                } else {
                    startY = alongBaseSize / 2;
                }
                g.setColor(_SDividerDotColor);
                g.drawLine(startX, startY, startX, startY);
                if (isHorizontal) {
                    if (startX + 12 <= alongBaseSize && startX - 12 >= 0) {
                        g.drawLine(startX + 12, startY, startX + 12, startY);
                        g.drawLine(startX - 12, startY, startX - 12, startY);
                    }
                } else if (startY + 12 <= alongBaseSize && startY - 12 >= 0) {
                    g.drawLine(startX, startY + 12, startX, startY + 12);
                    g.drawLine(startX, startY - 12, startX, startY - 12);
                }
                for (int i = 1; i <= 2; ++i) {
                    int factor = 8 * i + 12;
                    if (isHorizontal) {
                        if (startX + factor > alongBaseSize || startX - factor < 0) continue;
                        g.drawLine(startX + factor, startY, startX + factor, startY);
                        g.drawLine(startX - factor, startY, startX - factor, startY);
                        continue;
                    }
                    if (startY + factor > alongBaseSize || startY - factor < 0) continue;
                    g.drawLine(startX, startY + factor, startX, startY + factor);
                    g.drawLine(startX, startY - factor, startX, startY - factor);
                }
            }
        }

        @Override
        public void setBasicSplitPaneUI(BasicSplitPaneUI newUI) {
            if (this.splitPane != null) {
                this.splitPane.removePropertyChangeListener(this);
                if (this.mouseHandler != null) {
                    this.removeMouseListener(this.mouseHandler);
                    this.removeMouseMotionListener(this.mouseHandler);
                    this.mouseHandler = null;
                }
                if (this._splitButtonHandler != null) {
                    this.splitPane.removePropertyChangeListener(this._splitButtonHandler);
                    this._splitButtonHandler = null;
                }
            }
            this.splitPaneUI = newUI;
            if (newUI != null) {
                this.splitPane = newUI.getSplitPane();
                if (this.splitPane != null) {
                    if (this.mouseHandler == null) {
                        this.mouseHandler = new OracleMouseHandler();
                    }
                    this.addMouseListener(this.mouseHandler);
                    this.addMouseMotionListener(this.mouseHandler);
                    this.splitPane.addPropertyChangeListener(this);
                    if (this._splitButtonHandler == null) {
                        this._splitButtonHandler = new SplitButtonHandler();
                    }
                    this.splitPane.addPropertyChangeListener(this._splitButtonHandler);
                }
            } else {
                this.splitPane = null;
            }
        }

        public SplitterButton getSplitterButton() {
            return this._splitterButton;
        }

        @Override
        protected void oneTouchExpandableChanged() {
            this._splitterButton.setOneTouchExpandable(this.splitPane.isOneTouchExpandable());
        }

        @Override
        public void propertyChange(PropertyChangeEvent pe) {
            boolean toSetCursor;
            Cursor c = null;
            boolean bl = toSetCursor = pe.getSource() == this.splitPane && "orientation".equals(pe.getPropertyName());
            if (toSetCursor) {
                c = this.getCursor();
            }
            super.propertyChange(pe);
            if (toSetCursor) {
                if (c != null && (c.equals(Cursor.getPredefinedCursor(0)) || c.equals(_sHorizontalCursor) || c.equals(_sVerticalCursor))) {
                    c = null;
                }
                this.setCursor(c);
            }
        }

        private class OracleDividerLayout
        implements LayoutManager {
            private OracleDividerLayout() {
            }

            @Override
            public void layoutContainer(Container c) {
                Dimension dividerSize = c.getSize();
                Dimension temp = Divider.this._splitterButton.getMinimumSize();
                Insets insets = c.getInsets();
                if (insets == null) {
                    insets = _sEmptyInsets;
                }
                boolean isHorizontal = Divider.this._splitterButton.getOrientation() == 0;
                int perpSize = 0;
                int alongBaseSize = 0;
                int minPerpButtonSize = 0;
                int minAlongBaseButtonSize = 0;
                int bordersPerp = 0;
                int borderAlongBase = 0;
                if (isHorizontal) {
                    perpSize = dividerSize.height;
                    alongBaseSize = dividerSize.width;
                    minPerpButtonSize = temp.height;
                    minAlongBaseButtonSize = temp.width;
                    bordersPerp = insets.top + insets.bottom;
                    borderAlongBase = insets.left + insets.right;
                } else {
                    perpSize = dividerSize.width;
                    alongBaseSize = dividerSize.height;
                    minPerpButtonSize = temp.width;
                    minAlongBaseButtonSize = temp.height;
                    bordersPerp = insets.left + insets.right;
                    borderAlongBase = insets.top + insets.bottom;
                }
                if (perpSize >= minPerpButtonSize + bordersPerp && alongBaseSize > minAlongBaseButtonSize + borderAlongBase) {
                    int startX = 0;
                    int startY = 0;
                    dividerSize.width -= insets.left + insets.right;
                    dividerSize.height -= insets.top + insets.bottom;
                    startX = insets.left;
                    startY = insets.top;
                    Dimension buttonSize = Divider.this._splitterButton.getButtonSize(dividerSize);
                    if (isHorizontal) {
                        startX += (dividerSize.width - buttonSize.width) / 2;
                    } else {
                        startY += (dividerSize.height - buttonSize.height) / 2;
                        if (Divider.this._splitterButton.getActualReadingDirection() == 2) {
                            startX += dividerSize.width - buttonSize.width;
                        }
                    }
                    Divider.this._splitterButton.setBounds(startX, startY, buttonSize.width, buttonSize.height);
                } else {
                    Divider.this._splitterButton.setBounds(-10, -10, 2, 2);
                }
            }

            @Override
            public Dimension minimumLayoutSize(Container c) {
                return new Dimension(0, 0);
            }

            @Override
            public Dimension preferredLayoutSize(Container c) {
                return new Dimension(0, 0);
            }

            @Override
            public void removeLayoutComponent(Component c) {
            }

            @Override
            public void addLayoutComponent(String string, Component c) {
            }
        }

        private class SplitButtonHandler
        implements ActionListener,
        PropertyChangeListener {
            private SplitButtonHandler() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getID() == 1) {
                    return;
                }
                boolean toMinimum = true;
                if (e.getID() == 3) {
                    toMinimum = false;
                }
                if (Divider.this.orientation == 1 && Divider.this._splitterButton.getActualReadingDirection() == 1) {
                    toMinimum = !toMinimum;
                }
                Insets insets = Divider.this.splitPane.getInsets();
                int lastLoc = Divider.this.splitPane.getLastDividerLocation();
                int currentLoc = Divider.this.splitPaneUI.getDividerLocation(Divider.this.splitPane);
                int newLoc = toMinimum ? (Divider.this.orientation == 0 ? (currentLoc >= Divider.this.splitPane.getHeight() - insets.bottom - Divider.this.getDividerSize() ? lastLoc : insets.top) : (currentLoc >= Divider.this.splitPane.getWidth() - insets.right - Divider.this.getDividerSize() ? lastLoc : insets.left)) : (Divider.this.orientation == 0 ? (currentLoc == insets.top ? lastLoc : Divider.this.splitPane.getHeight() - Divider.this.getHeight() - insets.bottom) : (currentLoc == insets.left ? lastLoc : Divider.this.splitPane.getWidth() - Divider.this.getWidth() - insets.right));
                if (currentLoc != newLoc) {
                    Divider.this.splitPane.setDividerLocation(newLoc);
                    Divider.this.splitPane.setLastDividerLocation(currentLoc);
                }
            }

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (Divider.this.splitPane.isOneTouchExpandable() && e.getSource() == Divider.this.splitPane && "dividerLocation".equals(e.getPropertyName())) {
                    Insets insets = Divider.this.splitPane.getInsets();
                    int firstLoc = insets.top;
                    int secondLoc = Divider.this.splitPane.getHeight() - Divider.this.getHeight() - insets.bottom;
                    if (Divider.this.orientation == 1) {
                        if (Divider.this._splitterButton.getActualReadingDirection() == 1) {
                            firstLoc = Divider.this.splitPane.getWidth() - Divider.this.getWidth() - insets.right;
                            secondLoc = insets.left;
                        } else {
                            firstLoc = insets.left;
                            secondLoc = Divider.this.splitPane.getWidth() - Divider.this.getWidth() - insets.right;
                        }
                    }
                    int dividerLocation = Divider.this.splitPane.getDividerLocation();
                    Divider.this._splitterButton.setFirstEnabled(dividerLocation != firstLoc);
                    Divider.this._splitterButton.setSecondEnabled(dividerLocation != secondLoc);
                }
            }
        }

        private class OracleMouseHandler
        extends BasicSplitPaneDivider.MouseHandler {
            private boolean _fakeEvent;

            private OracleMouseHandler() {
                super(Divider.this);
                this._fakeEvent = true;
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getSource() != Divider.this._splitterButton) {
                    super.mousePressed(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (Divider.this.dragger != null) {
                    if (e.getSource() == Divider.this._splitterButton) {
                        SplitterButton button;
                        this._fakeEvent = true;
                        Insets inset = Divider.this.getInsets();
                        if (inset == null) {
                            inset = _sEmptyInsets;
                        }
                        if ((button = (SplitterButton)e.getSource()).getCursor() != _sDefaultCursor) {
                            button.setCursor(_sDefaultCursor);
                        }
                        MouseEvent mEvent = new MouseEvent(Divider.this, e.getID(), e.getWhen(), e.getModifiers(), e.getX() + inset.left, e.getY() + inset.top, e.getClickCount(), e.isPopupTrigger());
                        super.mouseReleased(mEvent);
                        e.consume();
                    } else {
                        super.mouseReleased(e);
                    }
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (e.getSource() == Divider.this._splitterButton) {
                    Insets inset = Divider.this.getInsets();
                    if (inset == null) {
                        inset = _sEmptyInsets;
                    }
                    SplitterButton button = (SplitterButton)e.getSource();
                    if ((e.getX() <= 0 || e.getX() >= button.getWidth() || e.getY() <= 0 || e.getY() >= button.getHeight()) && this._fakeEvent) {
                        Cursor newCursor;
                        this._fakeEvent = false;
                        Cursor cursor = newCursor = button.getOrientation() == 0 ? _sVerticalCursor : _sHorizontalCursor;
                        if (button.getCursor() != newCursor) {
                            button.setCursor(newCursor);
                        }
                        MouseEvent press = new MouseEvent(Divider.this, e.getID(), e.getWhen(), e.getModifiers(), Divider.this.getWidth() / 2, Divider.this.getHeight() / 2, e.getClickCount(), e.isPopupTrigger());
                        super.mousePressed(press);
                    }
                    MouseEvent drag = new MouseEvent(Divider.this, e.getID(), e.getWhen(), e.getModifiers(), e.getX() + inset.left, e.getY() + inset.top, e.getClickCount(), e.isPopupTrigger());
                    super.mouseDragged(drag);
                } else {
                    super.mouseDragged(e);
                }
            }
        }
    }
}

