/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.windows;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.UIDefaults;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.painter.AbstractBorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.util.ImmInsets;

class WindowsInsetBorderPainter
extends AbstractBorderPainter {
    private static final ImmInsets _SMALL_INSETS = new ImmInsets(1, 1, 1, 1);
    private static final ImmInsets _NORMAL_INSETS = new ImmInsets(2, 2, 2, 2);
    private boolean _isButton;
    private boolean _isSmall;

    public WindowsInsetBorderPainter() {
        this(null, false, false);
    }

    public WindowsInsetBorderPainter(boolean isButton) {
        this(null, isButton, false);
    }

    public WindowsInsetBorderPainter(Painter wrappedPainter, boolean isButton, boolean isSmall) {
        super(wrappedPainter);
        this._isButton = isButton;
        this._isSmall = isSmall;
    }

    @Override
    protected ImmInsets getOwnInsets(PaintContext context) {
        if (this._isSmall) {
            return _SMALL_INSETS;
        }
        return _NORMAL_INSETS;
    }

    @Override
    protected void paintBorder(PaintContext context, Graphics g, int x, int y, int width, int height) {
        UIDefaults defaults = context.getPaintUIDefaults();
        Color savedColor = g.getColor();
        int right = x + width - 1;
        int bottom = y + height - 1;
        Color lightHighlight = defaults.getColor(LookAndFeel.CONTROL_LT_HIGHLIGHT);
        Color shadow = defaults.getColor(LookAndFeel.CONTROL_SHADOW);
        Color highlight = defaults.getColor(LookAndFeel.CONTROL_HIGHLIGHT);
        Color darkShadow = defaults.getColor(LookAndFeel.CONTROL_DK_SHADOW);
        if (this._isButton && (context.getPaintState() & 2) == 0) {
            if (this._isSmall) {
                Color tempColor = lightHighlight;
                lightHighlight = shadow;
                shadow = tempColor;
            } else {
                Color tempColor = lightHighlight;
                lightHighlight = darkShadow;
                darkShadow = tempColor;
                tempColor = shadow;
                shadow = highlight;
                highlight = tempColor;
            }
        }
        g.setColor(lightHighlight);
        g.drawLine(x, bottom, right, bottom);
        g.drawLine(right, y, right, bottom);
        g.setColor(shadow);
        g.drawLine(x, y, --right, y);
        g.drawLine(x, y, x, --bottom);
        if (!this._isSmall) {
            g.setColor(highlight);
            g.drawLine(++x, bottom, right, bottom);
            g.drawLine(right, ++y, right, bottom);
            g.setColor(darkShadow);
            g.drawLine(x, y, --right, y);
            g.drawLine(x, y, x, --bottom);
        }
        g.setColor(savedColor);
    }

    @Override
    public int getRepaintFlags(PaintContext context) {
        return super.getRepaintFlags(context) | 1 | 0x80;
    }

    @Override
    protected boolean isBorderTransparent(PaintContext context) {
        return false;
    }
}

