/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.oracle;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.UIDefaults;
import oracle.bali.ewt.elaf.EWTStatusBarUI;
import oracle.bali.ewt.olaf.ColorScheme;
import oracle.bali.ewt.olaf.OracleButtonPainter;
import oracle.bali.ewt.painter.AbstractBorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.util.ImmInsets;

class OracleStatusBarPainter
extends AbstractBorderPainter {
    private static final int _EXTRA_CURVE_WIDTH = 5;
    private static final int _NORMAL_BORDER = 2;
    private static final int _EXTRA_BORDER = 7;
    private static ImmInsets _sInsets = new ImmInsets(2, 7, 2, 7);

    public OracleStatusBarPainter() {
    }

    public OracleStatusBarPainter(Painter wrappedPainter) {
        super(wrappedPainter);
    }

    @Override
    protected ImmInsets getOwnInsets(PaintContext context) {
        return _sInsets;
    }

    @Override
    protected void paintBorder(PaintContext context, Graphics g, int x, int y, int width, int height) {
        int state = context.getPaintState();
        UIDefaults defaults = context.getPaintUIDefaults();
        Color savedColor = g.getColor();
        int bottom = y + height - 1;
        int right = x + width - 1;
        boolean isInactive = (state & 4) != 0;
        Color background = context.getPaintBackground();
        Color inactiveColor = defaults.getColor(ColorScheme.CONTROL_SHADOW_DARK);
        Color darkToLight = isInactive ? inactiveColor : defaults.getColor("EWTStatusBar.shadow");
        OracleButtonPainter.drawSideCurve(g, inactiveColor, inactiveColor, inactiveColor, darkToLight, darkToLight, background, x += 5, y, bottom, 1);
        OracleButtonPainter.drawSideCurve(g, inactiveColor, darkToLight, darkToLight, darkToLight, darkToLight, background, right -= 5, y, bottom, -1);
        g.setColor(inactiveColor);
        g.drawLine(x += 2, y, right -= 2, y);
        g.setColor(darkToLight);
        g.drawLine(x, bottom, right, bottom);
        g.setColor(background);
        g.drawLine(x, y + 1, right, y + 1);
        g.drawLine(x, bottom - 1, right, bottom - 1);
        int[] splits = (int[])context.getPaintData(EWTStatusBarUI.RESIZABLE_SPLITTERS_KEY);
        if (splits != null) {
            for (int i = 0; i < splits.length; ++i) {
                int xCoord = splits[i];
                if (isInactive) {
                    g.setColor(inactiveColor);
                    g.drawLine(xCoord + 1, y + 1, xCoord + 1, y + 1);
                    g.drawLine(xCoord + 1, bottom - 1, xCoord + 1, bottom - 1);
                    continue;
                }
                g.setColor(background);
                g.drawLine(xCoord, y, xCoord + 2, y);
                g.drawLine(xCoord, bottom, xCoord + 2, bottom);
                g.setColor(darkToLight);
                g.drawLine(xCoord, y + 1, xCoord, y + 1);
                g.drawLine(xCoord, bottom - 1, xCoord, bottom - 1);
                g.setColor(inactiveColor);
                g.drawLine(xCoord + 2, y + 1, xCoord + 2, y + 1);
                g.drawLine(xCoord + 2, bottom - 1, xCoord + 2, bottom - 1);
            }
        }
        g.setColor(savedColor);
    }

    @Override
    protected boolean isBorderTransparent(PaintContext context) {
        return true;
    }

    @Override
    public int getRepaintFlags(PaintContext context) {
        return super.getRepaintFlags(context) | 4 | 0x400 | 0x80;
    }
}

