/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.basic;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import oracle.bali.ewt.dTree.DTree;
import oracle.bali.ewt.dTree.DTreeButtonDecoration;
import oracle.bali.ewt.dTree.DTreeDeferringParent;
import oracle.bali.ewt.dTree.DTreeItem;
import oracle.bali.ewt.dTree.DTreeLineDecoration;
import oracle.bali.ewt.dTree.DTreeStackingDecoration;
import oracle.bali.ewt.elaf.EWTTreeUI;
import oracle.bali.ewt.elaf.basic.TreeDropHighlightPainter;
import oracle.bali.ewt.painter.LinePainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.painter.TextPainter;
import oracle.bali.ewt.util.ImmInsets;

public abstract class BasicEWTTreeUI
extends EWTTreeUI {
    private Painter _itemPainter;
    private Painter _afterItemPainter;
    private Painter _beforeItemPainter;
    private Painter _textPainter;
    private ImmInsets _selectionInsets = new ImmInsets(1, 1, 1, 1);
    private ImmInsets _focusInsets = new ImmInsets(2, 2, 2, 2);

    @Override
    public Rectangle getEditBounds(JComponent component, PaintContext context, DTreeItem item) {
        Painter textPainter = this.getTextPainter();
        Dimension textSize = textPainter.getMinimumSize(context);
        Dimension itemSize = item.getSize();
        ImmInsets selectionInsets = this.getSelectionInsets();
        ImmInsets focusInsets = this.getFocusInsets();
        textSize.height += selectionInsets.top + selectionInsets.bottom + focusInsets.top + focusInsets.bottom;
        textSize.width += selectionInsets.left + selectionInsets.right + focusInsets.left + focusInsets.right;
        return new Rectangle(selectionInsets.left + focusInsets.left + itemSize.width - textSize.width, (itemSize.height - textSize.height) / 2, textSize.width, textSize.height);
    }

    @Override
    public Painter getItemPainter(JComponent component, DTreeItem item) {
        Painter painter = this._getItemPainter();
        DTree tree = (DTree)component;
        DTreeItem dropItem = tree.getDropHighlightItem();
        if (dropItem == item) {
            int dropStyle = tree.getDropHighlightStyle();
            if (dropStyle == 2) {
                if (this._beforeItemPainter == null) {
                    this._beforeItemPainter = new TreeDropHighlightPainter(this._getItemPainter(), true);
                }
                painter = this._beforeItemPainter;
            } else if (dropStyle == 3) {
                if (this._afterItemPainter == null) {
                    this._afterItemPainter = new TreeDropHighlightPainter(this._getItemPainter(), false);
                }
                painter = this._afterItemPainter;
            }
        }
        return painter;
    }

    @Override
    public int getDeferredChildHeight(JComponent component, PaintContext context, DTreeDeferringParent parent, int childIconHeight) {
        Font font = context.getPaintFont();
        FontMetrics fm = null;
        if (font == null || (fm = context.getFontMetrics(font)) == null) {
            return 0;
        }
        int textht = fm.getAscent() + fm.getDescent();
        ImmInsets selectionInsets = this.getSelectionInsets();
        ImmInsets focusInsets = this.getFocusInsets();
        return Math.max(childIconHeight, textht += selectionInsets.top + selectionInsets.bottom + focusInsets.top + focusInsets.bottom);
    }

    @Override
    public Icon getExpansionButtonIcon(JComponent component, DTreeItem item) {
        String key = item.isExpanded() ? "Tree.expandedIcon" : "Tree.collapsedIcon";
        return ((DTree)component).getUIDefaults().getIcon(key);
    }

    @Override
    public Image getMultiItemDragImage(JComponent component) {
        return (Image)((DTree)component).getUIDefaults().get("EWTTree.multiItemDrag");
    }

    @Override
    public void installUI(JComponent component) {
        DTree tree = (DTree)component;
        UIDefaults defaults = tree.getUIDefaults();
        component.setOpaque(true);
        LookAndFeel.installColorsAndFont(component, "Tree.background", "Tree.foreground", "Tree.font");
        DTreeButtonDecoration buttons = new DTreeButtonDecoration();
        if (this.isLineDrawn()) {
            DTreeLineDecoration lines = new DTreeLineDecoration(new LinePainter(true, this.isLineDotted()), new LinePainter(false, this.isLineDotted()), defaults.getColor("darkIntensity"));
            tree.setDecoration(new DTreeStackingDecoration(lines, buttons));
        } else {
            tree.setDecoration(buttons);
        }
    }

    protected abstract Painter createItemPainter();

    protected ImmInsets getSelectionInsets() {
        return this._selectionInsets;
    }

    protected ImmInsets getFocusInsets() {
        return this._focusInsets;
    }

    protected boolean isLineDotted() {
        return false;
    }

    protected boolean isLineDrawn() {
        return true;
    }

    private Painter _getItemPainter() {
        if (this._itemPainter == null) {
            this._itemPainter = this.createItemPainter();
        }
        return this._itemPainter;
    }

    public Painter getTextPainter() {
        if (this._textPainter == null) {
            this._textPainter = this.createTextPainter();
        }
        return this._textPainter;
    }

    protected Painter createTextPainter() {
        return new TextPainter();
    }
}

