/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.runner;

import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTree;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.explorer.TNode;
import oracle.ide.help.HelpInfo;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.runner.RunProcess;
import oracle.ide.runner.Runner;
import oracle.ideimpl.runner.RunManager;
import oracle.ideimpl.runner.RunnerBundle;
import oracle.ideimpl.runner.RunnerImpl;
import oracle.ideri.navigator.DefaultNavigatorWindow;
import oracle.javatools.icons.OracleIcons;

public final class RunManagerWindow
extends DefaultNavigatorWindow {
    static final String RUN_MANAGER_WINDOW_ID = "RunManagerWindow";
    private RunnerImpl runner;

    RunManagerWindow(Context context, RunnerImpl runner) {
        super(context, RUN_MANAGER_WINDOW_ID);
        this.runner = runner;
        this.setTitle(RunnerBundle.get("RUN_MANAGER_LABEL"));
    }

    private void setProjectInContext(Context context) {
        Element[] sel = context.getSelection();
        Element e = sel != null && sel.length > 0 ? sel[sel.length - 1] : null;
        if (e instanceof RunProcess) {
            RunProcess runProcess = (RunProcess)e;
            Context runProcessContext = runProcess.getContext();
            Workspace workspace = runProcessContext.getWorkspace();
            Project project = runProcessContext.getProject();
            Workspaces workspaces = Ide.getWorkspaces();
            List list = workspaces.getListOfChildren();
            if (list != null && list.contains(workspace)) {
                context.setWorkspace(workspace);
                if (workspace.containsChild((Element)project)) {
                    context.setProject(project);
                }
            }
        } else {
            context.setWorkspace(Ide.getActiveWorkspace());
            context.setProject(Ide.getActiveProject());
        }
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_runmanagerwindow_html");
    }

    public Context getContext(EventObject event) {
        Context c = super.getContext(event);
        this.setProjectInContext(c);
        return c;
    }

    public Icon getTabIcon() {
        return OracleIcons.getIcon((String)"runmanager.png");
    }

    protected boolean coalesceTreeExplorerUpdates() {
        return false;
    }

    boolean selectProcess(RunProcess runProcess) {
        TNode processesTNode = this.findProcessesTNode();
        if (processesTNode != null) {
            for (int i = processesTNode.getChildCount() - 1; i >= 0; --i) {
                TNode tnode = (TNode)processesTNode.getChildAt(i);
                if (tnode.getData() != runProcess) continue;
                this.setSelected(tnode);
                return true;
            }
        } else {
            if (runProcess == null) {
                this.runner.selectNewActiveRunProcess(null);
                return true;
            }
            Folder processes = this.runner.getProcessesFolder();
            Iterator iter = processes.getChildren();
            if (iter == null) {
                return false;
            }
            while (iter.hasNext()) {
                Element child = (Element)iter.next();
                if (runProcess != child) continue;
                this.runner.selectNewActiveRunProcess(runProcess);
                return true;
            }
        }
        return false;
    }

    private TNode findProcessesTNode() {
        Runner runner;
        JTree tree = this.getTree();
        if (tree == null) {
            return null;
        }
        TNode rootTNode = (TNode)tree.getModel().getRoot();
        Element data = rootTNode.getData();
        if (data == RunManager.getInstance() && (runner = Runner.getRunner()) != null) {
            Folder processes = runner.getProcessesFolder();
            for (int i = rootTNode.getChildCount() - 1; i >= 0; --i) {
                TNode tnode = (TNode)rootTNode.getChildAt(i);
                if (tnode.getData() != processes) continue;
                return tnode;
            }
        }
        return null;
    }
}

