/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.util;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Graph<T>
extends AbstractCollection<T> {
    protected Map<T, Vertex<T>> _vertices = new LinkedHashMap<T, Vertex<T>>();

    public Graph(Graph<T> original) {
        this._vertices.putAll(original._vertices);
    }

    public Graph() {
    }

    public Comparator<T> createComparator() throws CycleException {
        final List<T> sorted = this.getSortedVertices();
        return new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return sorted.indexOf(o1) - sorted.indexOf(o2);
            }
        };
    }

    public Graph(Collection<T> vertices) {
        this.addAll(vertices);
    }

    @Override
    public boolean contains(Object vertex) {
        return this._vertices.containsKey(vertex);
    }

    @Override
    public boolean add(T vertex) {
        if (this._vertices.containsKey(vertex)) {
            throw new IllegalArgumentException("Already in graph: " + vertex);
        }
        this._vertices.put(vertex, new Vertex<T>(vertex));
        return true;
    }

    public void connect(T from, T to) {
        try {
            Vertex<T> fromVertex = this._vertices.get(from);
            if (fromVertex == null) {
                throw new IllegalArgumentException("from vertex is not in graph: " + from);
            }
            Vertex<T> toVertex = this._vertices.get(to);
            if (toVertex == null) {
                throw new IllegalArgumentException("to vertex is not in graph: " + to);
            }
            this.connectVertices(fromVertex, toVertex);
        }
        catch (CycleException ce) {
            throw new IllegalArgumentException(ce);
        }
    }

    public List<T> getOutwardEdges(T from) {
        Vertex<T> v = this._vertices.get(from);
        if (v == null) {
            throw new IllegalArgumentException("Not in graph: " + from);
        }
        return this.verticesToData(v._toEdges);
    }

    public List<T> getInwardEdges(T to) {
        Vertex<T> v = this._vertices.get(to);
        if (v == null) {
            throw new IllegalArgumentException("Not in graph: " + to);
        }
        return this.verticesToData(v._fromEdges);
    }

    private List<T> verticesToData(List<Vertex> l) {
        ArrayList connections = new ArrayList(l.size());
        for (Vertex vertex : l) {
            connections.add(vertex.getData());
        }
        return Collections.unmodifiableList(connections);
    }

    private void connectVertices(Vertex<T> from, Vertex<T> to) throws CycleException {
        if (from == to) {
            throw new CycleException(to.getData(), Collections.singletonList(from.getData()));
        }
        to._fromEdges.add(from);
        from._toEdges.add(to);
    }

    public Graph<T> subgraph(Collection<T> vertices) {
        Graph<T> newGraph = new Graph<T>(this);
        newGraph.retainAll(vertices);
        return newGraph;
    }

    @Override
    public Iterator<T> iterator() {
        final Iterator<T> delegate = this._vertices.keySet().iterator();
        return new Iterator<T>(){
            private T current = null;

            @Override
            public boolean hasNext() {
                return delegate.hasNext();
            }

            @Override
            public T next() {
                this.current = delegate.next();
                return this.current;
            }

            @Override
            public void remove() {
                if (this.current == null) {
                    throw new IllegalStateException("You must use next() before remove()");
                }
                Graph.this.removeAllReferencesTo(this.current);
                delegate.remove();
            }
        };
    }

    @Override
    public boolean remove(Object vertex) {
        this.removeAllReferencesTo(vertex);
        return this._vertices.remove(vertex) != null;
    }

    private void removeAllReferencesTo(T vertex) {
        for (Vertex<T> v : this._vertices.values()) {
            v._fromEdges.remove(this._vertices.get(vertex));
            v._toEdges.remove(this._vertices.get(vertex));
        }
    }

    @Override
    public int size() {
        return this._vertices.size();
    }

    public List<T> getSortedVertices() throws CycleException {
        return this.getSortedVertices(null);
    }

    public List<T> getSortedVertices(T startVertex) throws CycleException {
        HashMap colors = new HashMap(this._vertices.size());
        ArrayList sortedList = new ArrayList(this._vertices.size());
        if (startVertex != null) {
            Color c = (Color)((Object)colors.get(startVertex));
            if (c == null) {
                this.visit(new ArrayList(), colors, startVertex, sortedList);
            }
        } else {
            for (T t : this) {
                Color c = (Color)((Object)colors.get(t));
                if (c != null) continue;
                this.visit(new ArrayList(), colors, t, sortedList);
            }
        }
        Collections.reverse(sortedList);
        return Collections.unmodifiableList(sortedList);
    }

    private void visit(List<T> visiting, Map<T, Color> colors, T vertex, List<T> sortedList) throws CycleException {
        colors.put(vertex, Color.VISITING);
        visiting.add(vertex);
        for (Vertex to : this._vertices.get(vertex)) {
            Color color = colors.get(to.getData());
            if (color == Color.VISITING) {
                throw new CycleException(to.getData(), visiting);
            }
            if (color == Color.VISITED) continue;
            this.visit(visiting, colors, to.getData(), sortedList);
        }
        sortedList.add(vertex);
        visiting.remove(vertex);
        colors.put(vertex, Color.VISITED);
    }

    public List<T> getVerticesConnectedTo(T vertex) throws CycleException {
        if (vertex == null) {
            throw new NullPointerException("vertex is null");
        }
        ArrayList vertices = new ArrayList();
        HashMap colors = new HashMap();
        this.visitInReverse(colors, vertex, vertices);
        vertices.remove(vertex);
        return Collections.unmodifiableList(vertices);
    }

    private void visitInReverse(Map<T, Color> colors, T startVertex, List<T> vertices) throws CycleException {
        colors.put(startVertex, Color.VISITING);
        Vertex<T> v = this._vertices.get(startVertex);
        List<Vertex> from = v._fromEdges;
        for (Vertex fromVertex : from) {
            Color color = colors.get(fromVertex.getData());
            if (color == Color.VISITING) {
                throw new CycleException(fromVertex.getData(), vertices);
            }
            if (color == Color.VISITED) continue;
            this.visitInReverse(colors, fromVertex.getData(), vertices);
        }
        vertices.add(startVertex);
        colors.put(startVertex, Color.VISITED);
    }

    public static <Z> Graph<Z> unmodifiableGraph(Graph<? extends Z> graph) {
        return new UnmodifiableGraph<Z>(graph);
    }

    private final class Vertex<T>
    implements Iterable<Vertex> {
        private final T _data;
        private final List<Vertex> _toEdges = new ArrayList<Vertex>();
        private final List<Vertex> _fromEdges = new ArrayList<Vertex>();

        Vertex(T data) {
            this._data = data;
        }

        public T getData() {
            return this._data;
        }

        @Override
        public Iterator<Vertex> iterator() {
            return this._toEdges.iterator();
        }
    }

    public static class CycleException
    extends Exception {
        private List vertices;
        private Object vertex;

        CycleException(Object vertex, List vertices) {
            this.vertices = vertices;
            this.vertex = vertex;
        }

        @Override
        public String getMessage() {
            if (this.vertices.size() == 1 && this.vertex == this.vertices.get(0)) {
                return this.vertex + " depends on itself";
            }
            return this.vertex + " is in a dependency cycle: " + this.getDependencyChain();
        }

        public String getDependencyChain() {
            StringBuffer b = new StringBuffer();
            ArrayList l = new ArrayList(this.vertices);
            Collections.reverse(l);
            b.append(String.valueOf(this.vertex));
            for (Object t : l) {
                b.append("\n->");
                b.append(String.valueOf(t));
                if (t != this.vertex) continue;
                break;
            }
            b.append("\n");
            return b.toString();
        }
    }

    private static enum Color {
        VISITING,
        VISITED;

    }

    private static class UnmodifiableGraph<E>
    extends Graph<E> {
        private Graph<E> _graph;

        UnmodifiableGraph(Graph<E> g) {
            this._graph = g;
        }

        @Override
        public boolean equals(Object o) {
            return this._graph.equals(o);
        }

        @Override
        public int hashCode() {
            return this._graph.hashCode();
        }

        @Override
        public int size() {
            return this._graph.size();
        }

        @Override
        public boolean isEmpty() {
            return this._graph.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this._graph.contains(o);
        }

        @Override
        public Object[] toArray() {
            return this._graph.toArray();
        }

        @Override
        public <E> E[] toArray(E[] a) {
            return this._graph.toArray(a);
        }

        @Override
        public boolean add(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void connect(E e, E e2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<E> iterator() {
            final Iterator<E> i = this._graph.iterator();
            return new Iterator<E>(){

                @Override
                public boolean hasNext() {
                    return i.hasNext();
                }

                @Override
                public E next() {
                    return i.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

