/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.extension.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ide.extension.Extension;
import javax.ide.extension.ExtensionDependency;
import javax.ide.extension.spi.DefaultElementContext;
import javax.ide.extension.spi.ExtensionSource;
import javax.ide.extension.spi.MinimalExtensionParser;
import javax.ide.extension.spi.MinimalExtensionVisitor;
import javax.ide.util.Version;

public final class DependencyTree {
    private final Map _sourcesByExtension;
    private final Map _extensionsById = new HashMap();
    private List _topologicalExtensionList;
    private final Map _unsatisfiedDependencies = new HashMap();
    private final List _cycles = new ArrayList();
    private static Object STATE_NOT_VISITED = "notvisited";
    private static Object STATE_VISITING = "visiting";
    private static Object STATE_VISITED = "visited";

    DependencyTree(List failedSources, Map sourcesByExtension) {
        this._sourcesByExtension = sourcesByExtension;
        DependencyTree.removeDuplicates(sourcesByExtension);
        for (Extension extension : this._sourcesByExtension.keySet()) {
            this._extensionsById.put(extension.getID(), extension);
        }
        TopoSortState state = new TopoSortState(this._cycles);
        for (Extension thisExt : this._sourcesByExtension.keySet()) {
            if (!state.isUnvisited(thisExt)) continue;
            DependencyTree.topologicalSort(state, thisExt, this._extensionsById, this._unsatisfiedDependencies);
        }
        this._topologicalExtensionList = state.getTopoList();
    }

    public static Map<Extension, ExtensionSource> loadMinimal(DefaultElementContext initialContext, Collection<ExtensionSource> extensionSources, List<ExtensionSource> failedSources) {
        MinimalExtensionVisitor visitor = new MinimalExtensionVisitor();
        MinimalExtensionParser.loadMinimal(visitor, initialContext, extensionSources, failedSources);
        return visitor.getSourcesByExtension();
    }

    public static DependencyTree buildTree(Collection extensionSources, EnabledExtensionLookup lookup, DefaultElementContext initialContext) {
        ArrayList<ExtensionSource> failedSources = new ArrayList<ExtensionSource>();
        Map<Extension, ExtensionSource> sbe = DependencyTree.loadMinimal(initialContext, extensionSources, failedSources);
        Iterator<Extension> i = sbe.keySet().iterator();
        while (i.hasNext()) {
            Extension e = i.next();
            if (lookup.isExtensionEnabled(e)) continue;
            i.remove();
        }
        return new DependencyTree(failedSources, sbe);
    }

    public static DependencyTree buildTree(Map<Extension, ExtensionSource> extensionToExtensionSourceMap) {
        ArrayList<ExtensionSource> failedSources = new ArrayList<ExtensionSource>();
        return DependencyTree.buildTree(extensionToExtensionSourceMap, failedSources);
    }

    public static DependencyTree buildTree(Map<Extension, ExtensionSource> extensionToExtensionSourceMap, List<ExtensionSource> failedSources) {
        return new DependencyTree(failedSources, extensionToExtensionSourceMap);
    }

    public static void removeDuplicates(Map sourcesByExtension) {
        HashMap<String, Extension> latestExtensionById = new HashMap<String, Extension>();
        ArrayList<Extension> extensionsToRemove = new ArrayList<Extension>();
        for (Extension extension : sourcesByExtension.keySet()) {
            Extension latest = (Extension)latestExtensionById.get(extension.getID());
            if (latest == null) {
                latestExtensionById.put(extension.getID(), extension);
                continue;
            }
            if (extension.getVersion().compareTo(latest.getVersion()) > 0) {
                extensionsToRemove.add(latest);
                latestExtensionById.put(extension.getID(), extension);
                continue;
            }
            extensionsToRemove.add(extension);
        }
        for (Extension extension : extensionsToRemove) {
            sourcesByExtension.remove(extension);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void topologicalSort(TopoSortState state, Extension ext, Map id2Extension, Map unsatisfiedDependencies) {
        try {
            state.startVisiting(ext);
            for (ExtensionDependency dep : ext.getDependencies()) {
                Extension depExt = (Extension)id2Extension.get(dep.getID());
                if (depExt == null || state.isUnsatisfied(depExt) || !DependencyTree.isVersionSatisfied(dep, depExt)) {
                    state.markUnsatisfiedChain();
                    ArrayList<ExtensionDependency> unsat = (ArrayList<ExtensionDependency>)unsatisfiedDependencies.get(ext);
                    if (unsat == null) {
                        unsat = new ArrayList<ExtensionDependency>();
                        unsatisfiedDependencies.put(ext, unsat);
                    }
                    unsat.add(dep);
                }
                if (depExt == null) continue;
                if (state.isVisiting(depExt)) {
                    state.markCycleChain(depExt);
                }
                if (!state.isUnvisited(depExt)) continue;
                DependencyTree.topologicalSort(state, depExt, id2Extension, unsatisfiedDependencies);
            }
        }
        finally {
            if (!state.isUnsatisfied(ext)) {
                state.addToTopo(ext);
            }
            state.endVisiting(ext);
        }
    }

    private static boolean isVersionSatisfied(ExtensionDependency dep, Extension ext) {
        if (ext != null) {
            if (dep.getMinimumVersion() != null && dep.getMinimumVersion().compareTo(ext.getVersion()) > 0) {
                return false;
            }
            if (dep.getMaximumVersion() != null && dep.getMaximumVersion().compareTo(ext.getVersion()) < 0) {
                return false;
            }
        }
        return true;
    }

    public List getSortedExtensionIDs() {
        ArrayList<String> idList = new ArrayList<String>(this._topologicalExtensionList.size());
        for (Extension ext : this._topologicalExtensionList) {
            idList.add(ext.getID());
        }
        return Collections.unmodifiableList(idList);
    }

    public List<Extension> getSortedExtensions() {
        return Collections.unmodifiableList(this._topologicalExtensionList);
    }

    public Version getResolvedVersion(String id) {
        Extension ext = (Extension)this._extensionsById.get(id);
        return ext.getVersion();
    }

    public Collection getCycles() {
        return this._cycles;
    }

    public Collection getUnsatisfiedExtensions() {
        return Collections.unmodifiableCollection(this._unsatisfiedDependencies.keySet());
    }

    public Collection getUnsatisfiedDependencies(Extension unsatisfied) {
        if (unsatisfied == null) {
            throw new NullPointerException("unsatisfied is null");
        }
        Collection result = (Collection)this._unsatisfiedDependencies.get(unsatisfied);
        if (result == null) {
            throw new IllegalArgumentException("Not in the list of unsatisfied extensions: " + unsatisfied);
        }
        return Collections.unmodifiableCollection(result);
    }

    public ExtensionSource getSource(String id) {
        if (id == null) {
            throw new NullPointerException("id is null");
        }
        Extension extension = (Extension)this._extensionsById.get(id);
        if (extension == null) {
            throw new IllegalArgumentException("Unknown extension id " + id);
        }
        return (ExtensionSource)this._sourcesByExtension.get(extension);
    }

    public static class TopoSortState {
        private Map _stateByExtension = new HashMap();
        private Set _unsatisfied = new HashSet();
        private List _currentlyVisiting = new ArrayList();
        private List _topoList = new ArrayList();
        private List m_cycles;

        public TopoSortState(List cycles) {
            this.m_cycles = cycles;
        }

        public List getTopoList() {
            return this._topoList;
        }

        public boolean isVisiting(Extension extension) {
            return this._stateByExtension.get(extension) == STATE_VISITING;
        }

        public boolean isUnvisited(Extension extension) {
            Object o = this._stateByExtension.get(extension);
            return o == null || o == STATE_NOT_VISITED;
        }

        public void addUnsatisfied(Extension extension) {
            this._unsatisfied.add(extension);
        }

        public boolean isUnsatisfied(Extension extension) {
            return this._unsatisfied.contains(extension);
        }

        public void startVisiting(Extension extension) {
            this._currentlyVisiting.add(extension);
            this._stateByExtension.put(extension, STATE_VISITING);
        }

        public void endVisiting(Extension extension) {
            this._currentlyVisiting.remove(extension);
            this._stateByExtension.put(extension, STATE_VISITED);
        }

        public void markUnsatisfiedChain() {
            Iterator i = this._currentlyVisiting.iterator();
            while (i.hasNext()) {
                this.addUnsatisfied((Extension)i.next());
            }
        }

        public void markCycleChain(Extension current) {
            ArrayList<Extension> al = new ArrayList<Extension>();
            al.addAll(this._currentlyVisiting);
            al.add(current);
            this.m_cycles.add(al);
        }

        public void addToTopo(Extension extension) {
            this._topoList.add(extension);
        }
    }

    public static interface EnabledExtensionLookup {
        public boolean isExtensionEnabled(Extension var1);
    }
}

