/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.identity.model.CreateApiKeyDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UploadApiKeyRequest
extends BmcRequest<CreateApiKeyDetails> {
    private String userId;
    private CreateApiKeyDetails createApiKeyDetails;
    private String opcRetryToken;

    public String getUserId() {
        return this.userId;
    }

    public CreateApiKeyDetails getCreateApiKeyDetails() {
        return this.createApiKeyDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public CreateApiKeyDetails getBody$() {
        return this.createApiKeyDetails;
    }

    public Builder toBuilder() {
        return new Builder().userId(this.userId).createApiKeyDetails(this.createApiKeyDetails).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",userId=").append(String.valueOf(this.userId));
        sb.append(",createApiKeyDetails=").append(String.valueOf((Object)this.createApiKeyDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UploadApiKeyRequest)) {
            return false;
        }
        UploadApiKeyRequest other = (UploadApiKeyRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.userId, other.userId) && Objects.equals((Object)this.createApiKeyDetails, (Object)other.createApiKeyDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.userId == null ? 43 : this.userId.hashCode());
        result = result * 59 + (this.createApiKeyDetails == null ? 43 : this.createApiKeyDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UploadApiKeyRequest, CreateApiKeyDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String userId = null;
        private CreateApiKeyDetails createApiKeyDetails = null;
        private String opcRetryToken = null;

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder createApiKeyDetails(CreateApiKeyDetails createApiKeyDetails) {
            this.createApiKeyDetails = createApiKeyDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UploadApiKeyRequest o) {
            this.userId(o.getUserId());
            this.createApiKeyDetails(o.getCreateApiKeyDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UploadApiKeyRequest build() {
            UploadApiKeyRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateApiKeyDetails body) {
            this.createApiKeyDetails(body);
            return this;
        }

        public UploadApiKeyRequest buildWithoutInvocationCallback() {
            UploadApiKeyRequest request = new UploadApiKeyRequest();
            request.userId = this.userId;
            request.createApiKeyDetails = this.createApiKeyDetails;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

