/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.sparql.language;

import java.awt.Color;
import oracle.javatools.editor.language.BaseStyle;
import oracle.javatools.editor.language.BuiltInStyles;
import oracle.javatools.editor.language.StyleRegistry;

public class SPARQLStyles {
    public static final String SPARQL_COMMENT_STYLE = "sparql-comment-style";
    public static final String SPARQL_KEYWORD_STYLE = "sparql-keyword-style";
    public static final String SPARQL_IDENTIFIER_STYLE = "sparql-identifier-style";
    public static final String SPARQL_STRING_STYLE = "sparql-string-style";
    public static final String SPARQL_NUMBER_STYLE = "sparql-number-style";
    public static final String SPARQL_BRACE_STYLE = "sparql-brace-style";
    public static final String SPARQL_OPERATOR_STYLE = "sparql-operator-style";
    public static final String SPARQL_ERROR_HIGHLIGHT_STYLE = "sparql-error-highlight-style";
    public static final String SPARQL_WARNING_HIGHLIGHT_STYLE = "sparql-warning-highlight-style";
    public static final String SPARQL_FATAL_HIGHLIGHT_STYLE = "sparql-fatal-highlight-style";
    public static final String SPARQL_BIND_VAR_STYLE = "sparql-bind-var-highlight-style";
    public static final String SPARQL_IRI_REF_STYLE = "sparql-iri-ref-highlight-style";
    static final String SPARQL_LEXICAL_ERROR_STYLE = "sparql-lexical-error";
    public static final String[] STYLE_NAMES = new String[]{"sparql-comment-style", "sparql-keyword-style", "sparql-identifier-style", "sparql-string-style", "sparql-number-style", "sparql-brace-style", "sparql-operator-style", "sparql-bind-var-highlight-style", "sparql-iri-ref-highlight-style", "sparql-lexical-error"};
    public static BaseStyle sparqlPlainStyle;
    public static BaseStyle sparqlCommentStyle;
    public static BaseStyle sparqlKeywordStyle;
    public static BaseStyle sparqlIdentifierStyle;
    public static BaseStyle sparqlStringStyle;
    public static BaseStyle sparqlNumberStyle;
    public static BaseStyle sparqlBraceStyle;
    public static BaseStyle sparqlOperatorStyle;
    public static BaseStyle sparqlBindVarStyle;
    public static BaseStyle sparqlIRIRefVarStyle;
    public static BaseStyle sparqlLexicalError;

    public SPARQLStyles(StyleRegistry styleRegistry) {
        this.reloadStyles(styleRegistry);
    }

    public void reloadStyles(StyleRegistry styleRegistry) {
        String string;
        BuiltInStyles builtInStyles = new BuiltInStyles(styleRegistry);
        sparqlPlainStyle = builtInStyles.plainStyle;
        sparqlCommentStyle = styleRegistry.lookupStyle(SPARQL_COMMENT_STYLE);
        if (sparqlCommentStyle == null) {
            string = SPARQL_COMMENT_STYLE;
            sparqlCommentStyle = styleRegistry.createStyle(SPARQL_COMMENT_STYLE, string, "base-comment-style");
        }
        if ((sparqlStringStyle = styleRegistry.lookupStyle(SPARQL_STRING_STYLE)) == null) {
            string = SPARQL_STRING_STYLE;
            sparqlStringStyle = styleRegistry.createStyle(SPARQL_STRING_STYLE, string, "base-string-style");
        }
        if ((sparqlKeywordStyle = styleRegistry.lookupStyle(SPARQL_KEYWORD_STYLE)) == null) {
            string = SPARQL_KEYWORD_STYLE;
            sparqlKeywordStyle = styleRegistry.createStyle(SPARQL_KEYWORD_STYLE, string, "base-keyword-style");
        }
        if ((sparqlIdentifierStyle = styleRegistry.lookupStyle(SPARQL_IDENTIFIER_STYLE)) == null) {
            string = SPARQL_IDENTIFIER_STYLE;
            sparqlIdentifierStyle = styleRegistry.createStyle(SPARQL_IDENTIFIER_STYLE, string, "base-identifier-style");
        }
        if ((sparqlNumberStyle = styleRegistry.lookupStyle(SPARQL_NUMBER_STYLE)) == null) {
            string = SPARQL_NUMBER_STYLE;
            sparqlNumberStyle = styleRegistry.createStyle(SPARQL_NUMBER_STYLE, string, "base-number-style");
        }
        if ((sparqlBraceStyle = styleRegistry.lookupStyle(SPARQL_BRACE_STYLE)) == null) {
            string = SPARQL_BRACE_STYLE;
            sparqlBraceStyle = styleRegistry.createStyle(SPARQL_BRACE_STYLE, string, "base-brace-style");
        }
        if ((sparqlOperatorStyle = styleRegistry.lookupStyle(SPARQL_OPERATOR_STYLE)) == null) {
            string = SPARQL_OPERATOR_STYLE;
            sparqlOperatorStyle = styleRegistry.createStyle(SPARQL_OPERATOR_STYLE, string, "base-operator-style");
        }
        if ((sparqlBindVarStyle = styleRegistry.lookupStyle(SPARQL_BIND_VAR_STYLE)) == null) {
            string = SPARQL_BIND_VAR_STYLE;
            sparqlBindVarStyle = styleRegistry.createStyle(SPARQL_BIND_VAR_STYLE, string, "base-plain-style", 1);
        }
        if ((sparqlIRIRefVarStyle = styleRegistry.lookupStyle(SPARQL_IRI_REF_STYLE)) == null) {
            string = SPARQL_IRI_REF_STYLE;
            sparqlIRIRefVarStyle = styleRegistry.createStyle(SPARQL_IRI_REF_STYLE, string, "base-plain-style", Color.magenta);
        }
        if ((sparqlLexicalError = styleRegistry.lookupStyle(SPARQL_LEXICAL_ERROR_STYLE)) == null) {
            string = SPARQL_LEXICAL_ERROR_STYLE;
            sparqlLexicalError = styleRegistry.createStyle(SPARQL_LEXICAL_ERROR_STYLE, string, "base-plain-style");
        }
    }
}

