/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.hadoop.ui;

import java.awt.Component;
import java.awt.Container;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import oracle.dbtools.common.utils.BasicDBObject;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.extract.ExtractReconciler;
import oracle.dbtools.extract.models.ExtractListModel;
import oracle.dbtools.extract.models.ExtractObject;
import oracle.dbtools.raptor.controls.SpringUtilities;
import oracle.dbtools.raptor.hadoop.ui.HadoopWizArb;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.controls.tree.CustomJTree;
import oracle.ide.controls.tree.JTreeCellData;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.TriStateBoolean;

public class HadoopPartitionTreePanel
extends JPanel {
    protected String _conn;
    protected BasicDBObject _dbo;
    protected DefaultMutableTreeNode _root;
    private static final long serialVersionUID = 1L;
    private CustomJTree _tree;
    private DefaultTreeModel _model;
    private ArrayList<String> _selectedObjs = null;
    private ExtractObject _extractObject;
    private ExtractListModel _listModel;

    public HadoopPartitionTreePanel(ExtractObject extractObject, ArrayList<String> arrayList) {
        this._extractObject = extractObject;
        this._listModel = this._extractObject.getListModel();
        this.setSelectedObjects(arrayList);
        if (this._listModel.isTypeDBO()) {
            this._dbo = extractObject.getDBObject();
            this.showPanel(this._dbo.getConnectionName());
        }
    }

    public void showPanel(String string) {
        this._conn = string;
        this.draw();
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_exporttablecolumnselect_html");
    }

    public void draw() {
        this.setLayout(new SpringLayout());
        this._root = new DefaultMutableTreeNode(HadoopWizArb.getString("PARTITIONS"));
        this._model = new DefaultTreeModel(this._root);
        this._tree = new CustomJTree((TreeModel)this._model);
        this._tree.setSize(200, 200);
        this.addToTree();
        this._tree.expandAllRows();
        this.add(new JLabel(HadoopWizArb.getString("PARTITIONS")));
        this.add(new JScrollPane((Component)this._tree));
        SpringUtilities.makeCompactGrid((Container)this, (int)2, (int)1, (int)0, (int)0, (int)2, (int)2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToTree() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ResultSet resultSet = null;
        hashMap.put("OWNER", this._dbo.getSchemaName());
        hashMap.put("NAME", this._dbo.getObjectName());
        if (Connections.getInstance().lock(this._conn)) {
            try {
                boolean bl = ExtractReconciler.isConnDba((Connection)Connections.getInstance().getConnection(this._conn));
                String string = "select partition_name from " + (bl ? "dba_tab_partitions" : "all_tab_partitions") + " where table_owner = :OWNER  and table_name = :NAME ";
                resultSet = DBUtil.getInstance((String)this._conn).executeQuery(string, hashMap);
                while (resultSet.next()) {
                    this._root.add(new DefaultMutableTreeNode(resultSet.getString(1)));
                }
            }
            catch (Exception exception) {
                DBUtil.closeResultSet(resultSet);
                Connections.getInstance().unlock(this._conn);
            }
            catch (Throwable throwable) {
                DBUtil.closeResultSet(resultSet);
                Connections.getInstance().unlock(this._conn);
                throw throwable;
            }
            DBUtil.closeResultSet((ResultSet)resultSet);
            Connections.getInstance().unlock(this._conn);
        }
    }

    public TriStateBoolean getRootState() {
        return ((JTreeCellData)this._root.getUserObject()).getCheckBoxState();
    }

    public ArrayList<String> getSelectedPartitions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        return arrayList;
    }

    public boolean allColumnsSelected() {
        return true;
    }

    private void setSelectedObjects(ArrayList<String> arrayList) {
        if (arrayList.equals(null) || arrayList.isEmpty()) {
            this._selectedObjs = new ArrayList();
            this._selectedObjs.add(HadoopWizArb.getString("ALL"));
        } else {
            this._selectedObjs = arrayList;
        }
    }

    public int getColCount() {
        return this._root.getChildCount();
    }
}

