/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.editor.bookmarks;

import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import oracle.dbtools.worksheet.editor.Worksheet;
import oracle.dbtools.worksheet.editor.bookmarks.WorksheetBookmark;
import oracle.ide.bookmarks.Bookmark;
import oracle.ide.bookmarks.BookmarkConstants;
import oracle.ide.bookmarks.BookmarkEvent;
import oracle.ide.bookmarks.BookmarkIcons;
import oracle.ide.bookmarks.BookmarkListener;
import oracle.ide.bookmarks.BookmarkManager;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorManager;
import oracle.javatools.editor.gutter.GutterColumn;
import oracle.javatools.editor.gutter.GutterColumnListener;
import oracle.javatools.editor.gutter.GutterMark;
import oracle.javatools.editor.gutter.LineGutterPlugin;

public class BookmarkTracker {
    private static GutterColumnL gutterColumnL = new GutterColumnL();
    private static boolean isInitialized = false;

    private BookmarkTracker() {
    }

    public static void initialize() {
        if (isInitialized) {
            return;
        }
        isInitialized = true;
        BookmarkManager.getBookmarkManager().addBookmarkListener((BookmarkListener)new BookmarkL());
        EditorManager.getEditorManager().addEditorListener(new EditorListener(){

            public void editorOpened(Editor editor) {
                if (!(editor instanceof Worksheet)) {
                    return;
                }
                URL uRL = editor.getContext().getNode().getURL();
                for (Bookmark bookmark : BookmarkManager.getBookmarkManager().getAllBookmarks()) {
                    WorksheetBookmark worksheetBookmark;
                    if (!(bookmark instanceof WorksheetBookmark) || (worksheetBookmark = (WorksheetBookmark)bookmark) == null || worksheetBookmark.getURL() == null || !worksheetBookmark.getURL().equals(uRL)) continue;
                    BookmarkTracker.addBookmark(worksheetBookmark, (Worksheet)editor);
                }
            }

            public void editorActivated(Editor editor) {
            }

            public void editorDeactivated(Editor editor) {
            }

            public void editorClosed(Editor editor) {
            }
        });
    }

    private static void bookmarkAdded(WorksheetBookmark worksheetBookmark) {
        for (Worksheet worksheet : BookmarkTracker.getOpenEditors(worksheetBookmark)) {
            BookmarkTracker.addBookmark(worksheetBookmark, worksheet);
        }
    }

    private static void addBookmark(WorksheetBookmark worksheetBookmark, Worksheet worksheet) {
        int n = BookmarkManager.getBookmarkManager().getBookmarkNumber((Bookmark)worksheetBookmark);
        GutterColumn gutterColumn = BookmarkTracker.getGutterColumn(worksheet, true);
        GutterMark gutterMark = gutterColumn.addGutterMark(worksheetBookmark.getLine(), BookmarkIcons.getIcon((int)n), BookmarkConstants.BOOKMARK_STYLE, 2000, 5);
        if (gutterMark == null) {
            return;
        }
        gutterMark.setUserData((Object)worksheetBookmark);
    }

    private static void bookmarkRemoved(WorksheetBookmark worksheetBookmark) {
        for (Worksheet worksheet : BookmarkTracker.getOpenEditors(worksheetBookmark)) {
            GutterColumn gutterColumn = BookmarkTracker.getGutterColumn(worksheet, false);
            if (gutterColumn == null) continue;
            for (GutterMark gutterMark : gutterColumn.lookupGutterMarks(worksheetBookmark.getLine())) {
                gutterColumn.removeGutterMark(gutterMark);
            }
        }
    }

    private static void bookmarkUpdated(WorksheetBookmark worksheetBookmark) {
        for (Worksheet worksheet : BookmarkTracker.getOpenEditors(worksheetBookmark)) {
            GutterColumn gutterColumn = BookmarkTracker.getGutterColumn(worksheet, false);
            if (gutterColumn == null) continue;
            int n = BookmarkManager.getBookmarkManager().getBookmarkNumber((Bookmark)worksheetBookmark);
            Icon icon = BookmarkIcons.getIcon((int)n);
            for (GutterMark gutterMark : gutterColumn.lookupGutterMarks(worksheetBookmark.getLine())) {
                gutterMark.setIcon(icon);
            }
        }
    }

    private static List<Worksheet> getOpenEditors(WorksheetBookmark worksheetBookmark) {
        ArrayList<Worksheet> arrayList = new ArrayList<Worksheet>();
        for (Editor editor : EditorManager.getEditorManager().getAllEditors()) {
            if (!(editor instanceof Worksheet) || !editor.getContext().getNode().getURL().equals(worksheetBookmark.getURL())) continue;
            arrayList.add((Worksheet)editor);
        }
        return arrayList;
    }

    private static GutterColumn getGutterColumn(Worksheet worksheet, boolean bl) {
        LineGutterPlugin lineGutterPlugin = worksheet.getGutter();
        GutterColumn gutterColumn = lineGutterPlugin.lookupGutterColumn("bookmark-category");
        if (gutterColumn == null && bl) {
            gutterColumn = lineGutterPlugin.createGutterColumn("bookmark-category", (GutterColumnListener)gutterColumnL);
        }
        return gutterColumn;
    }

    private static class BookmarkL
    implements BookmarkListener {
        private BookmarkL() {
        }

        public void bookmarksChanged(BookmarkEvent bookmarkEvent) {
            Bookmark bookmark = bookmarkEvent.getBookmark();
            if (!(bookmark instanceof WorksheetBookmark)) {
                return;
            }
            WorksheetBookmark worksheetBookmark = (WorksheetBookmark)bookmark;
            switch (bookmarkEvent.getType()) {
                case ADDITION: {
                    BookmarkTracker.bookmarkAdded(worksheetBookmark);
                    break;
                }
                case REMOVAL: {
                    BookmarkTracker.bookmarkRemoved(worksheetBookmark);
                    break;
                }
                case UPDATE: {
                    BookmarkTracker.bookmarkUpdated(worksheetBookmark);
                }
            }
        }
    }

    private static class GutterColumnL
    implements GutterColumnListener {
        private GutterColumnL() {
        }

        public void markMoved(GutterMark gutterMark, int n, int n2) {
            if (gutterMark.getUserData() instanceof WorksheetBookmark) {
                ((WorksheetBookmark)((Object)gutterMark.getUserData())).setLine(n2);
            }
        }

        public void markRemoved(GutterMark gutterMark, int n) {
            if (gutterMark.getUserData() instanceof WorksheetBookmark) {
                BookmarkManager.getBookmarkManager().removeBookmark((Bookmark)((WorksheetBookmark)((Object)gutterMark.getUserData())));
            }
        }

        public void markClicked(GutterMark gutterMark, int n, MouseEvent mouseEvent) {
            Bookmark bookmark = (Bookmark)gutterMark.getUserData();
            BookmarkManager.getBookmarkManager().removeBookmark(bookmark);
        }

        public String getMarkToolTip(GutterMark gutterMark, MouseEvent mouseEvent) {
            Bookmark bookmark = (Bookmark)gutterMark.getUserData();
            String string = bookmark.getDescription();
            return string;
        }
    }
}

