/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.commands.scriptrunner;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.worksheet.WorksheetCallback;
import oracle.dbtools.worksheet.WorksheetContext;
import oracle.dbtools.worksheet.WorksheetResultPanel;
import oracle.dbtools.worksheet.WorksheetTaskResultPanel;
import oracle.dbtools.worksheet.commands.scriptrunner.api.IScriptConsumer;
import oracle.dbtools.worksheet.commands.scriptrunner.task.ITabListener;
import oracle.dbtools.worksheet.commands.scriptrunner.task.ScriptRunnerPanel;
import oracle.dbtools.worksheet.commands.scriptrunner.task.consumer.DefaultScriptConsumer;

public class ConsumerManager
implements ITabListener {
    protected List<IScriptConsumer> m_consumers = new ArrayList<IScriptConsumer>();
    private String m_action;
    private WorksheetContext m_worksheetContext;

    public ConsumerManager(String string, WorksheetContext worksheetContext) {
        this.init(string, worksheetContext);
    }

    public IScriptConsumer getAvailableConsumer(boolean bl) {
        IScriptConsumer iScriptConsumer = null;
        if (this.isCurrentConsumerAvailable()) {
            iScriptConsumer = this.currentAvailableConsumer();
            this.focusScriptOutputResult(this.getWorksheetContext(), iScriptConsumer);
        } else {
            iScriptConsumer = new DefaultScriptConsumer(this.getAction(), this.getWorksheetContext(), this);
            iScriptConsumer.getPanel().setPinned(false);
            if (bl) {
                this.openScriptOutputResult(this.getWorksheetContext(), iScriptConsumer);
            }
            this.m_consumers.add(iScriptConsumer);
        }
        return iScriptConsumer;
    }

    private WorksheetContext getWorksheetContext() {
        return this.m_worksheetContext;
    }

    private String getAction() {
        return this.m_action;
    }

    private void openScriptOutputResult(WorksheetContext worksheetContext, IScriptConsumer iScriptConsumer) {
        WorksheetTaskResultPanel worksheetTaskResultPanel = iScriptConsumer.getPanel();
        worksheetTaskResultPanel.setContext(worksheetContext);
        WorksheetCallback worksheetCallback = worksheetContext.getCallback();
        worksheetCallback.showResultPanel(worksheetTaskResultPanel);
    }

    private void focusScriptOutputResult(WorksheetContext worksheetContext, IScriptConsumer iScriptConsumer) {
        WorksheetTaskResultPanel worksheetTaskResultPanel = iScriptConsumer.getPanel();
        worksheetTaskResultPanel.setContext(worksheetContext);
        WorksheetCallback worksheetCallback = worksheetContext.getCallback();
        worksheetCallback.focusPanel(worksheetTaskResultPanel);
    }

    private IScriptConsumer currentAvailableConsumer() {
        IScriptConsumer iScriptConsumer = null;
        for (IScriptConsumer iScriptConsumer2 : this.getConsumers()) {
            if (iScriptConsumer2.getPanel().isPinned()) continue;
            iScriptConsumer = iScriptConsumer2;
        }
        return iScriptConsumer;
    }

    private boolean isCurrentConsumerAvailable() {
        return this.currentAvailableConsumer() != null;
    }

    public List<IScriptConsumer> getConsumers() {
        return this.m_consumers;
    }

    public void init(String string, WorksheetContext worksheetContext) {
        this.m_action = string;
        this.m_worksheetContext = worksheetContext;
    }

    @Override
    public void tabClosed(WorksheetResultPanel worksheetResultPanel) {
        IScriptConsumer iScriptConsumer = this.getConsumer(worksheetResultPanel);
        if (worksheetResultPanel instanceof ScriptRunnerPanel) {
            ((ScriptRunnerPanel)worksheetResultPanel).close();
        }
        if (iScriptConsumer != null) {
            this.getConsumers().remove(iScriptConsumer);
        }
        iScriptConsumer = null;
    }

    private IScriptConsumer getConsumer(WorksheetResultPanel worksheetResultPanel) {
        for (IScriptConsumer iScriptConsumer : this.getConsumers()) {
            if (iScriptConsumer.getPanel() != worksheetResultPanel) continue;
            return iScriptConsumer;
        }
        return null;
    }
}

