/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.Color;
import java.awt.Font;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.mapviewer.share.style.StyleUtils;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.DataException;
import oracle.sdovis.RSBundle;
import oracle.sdovis.StyleCache;
import oracle.sdovis.StyleRowData;
import oracle.sdovis.VisContext;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleArea;
import oracle.sdovis.style.StyleColor;
import oracle.sdovis.style.StyleException;
import oracle.sdovis.style.StyleLine;
import oracle.sdovis.style.StyleMarker;
import oracle.sdovis.style.StyleText;
import oracle.sdovis.stylex.AdvancedStyle;
import oracle.sdovis.stylex.BarChartStyle;
import oracle.sdovis.stylex.BucketStyle;
import oracle.sdovis.stylex.CollectionStyle;
import oracle.sdovis.stylex.ColorSchemeStyle;
import oracle.sdovis.stylex.DotDensityStyle;
import oracle.sdovis.stylex.HeatMapStyle;
import oracle.sdovis.stylex.PieChartStyle;
import oracle.sdovis.stylex.VariableMarkerStyle;
import oracle.sdovis.stylex.VariablePieChartStyle;
import oracle.sdovis.util.Util;
import oracle.sdovis.util.XMLDOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StyleFactory {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);
    private static Style _4Point = new StyleColor(Color.red, Color.red);
    private static Style _4LineString = new StyleColor(null, Color.black);
    private static Style _4Polygon = new StyleColor(new Color(Color.darkGray.getRed(), Color.darkGray.getGreen(), Color.darkGray.getBlue(), 128), Color.black);
    private static Style _4Text = new StyleText(new Font("Dialog", 0, 12), Color.blue, 2.0f);

    public static Style createStyleFromXML(String xml) {
        if (xml == null) {
            return null;
        }
        int idx = xml.indexOf("class=");
        int idx2 = 0;
        if (idx < 0) {
            return null;
        }
        idx2 = idx += 7;
        try {
            while (xml.charAt(idx2++) != '\"') {
            }
        }
        catch (IndexOutOfBoundsException e) {
            System.err.println(RSBundle.getMsg("MAPVIEWER-01008"));
            return null;
        }
        String cls = xml.substring(idx, idx2 - 1);
        if (cls == null || cls.length() < 4) {
            System.err.println(RSBundle.getMsg("MAPVIEWER-01009"));
            return null;
        }
        cls = cls.toUpperCase();
        try {
            if (cls.equals("COLOR")) {
                return new StyleColor(xml);
            }
            if (cls.equals("LINE")) {
                return new StyleLine(xml);
            }
            if (cls.equals("TEXT")) {
                return new StyleText(xml);
            }
            if (cls.equals("MARKER")) {
                return new StyleMarker(xml);
            }
            if (cls.equals("AREA")) {
                return new StyleArea(xml, null);
            }
            System.err.println(RSBundle.getMsg("MAPVIEWER-01010"));
            return null;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return null;
        }
    }

    public static String getSimpleStyleTypeFromXML(String xml) {
        if (xml == null) {
            return null;
        }
        int idx = xml.indexOf("class=");
        int idx2 = 0;
        if (idx < 0) {
            return null;
        }
        idx2 = idx += 7;
        try {
            while (xml.charAt(idx2++) != '\"') {
            }
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
        String cls = xml.substring(idx, idx2 - 1);
        if (cls == null || cls.length() < 4) {
            return null;
        }
        if ((cls = cls.toUpperCase()).equals("COLOR")) {
            return "COLOR";
        }
        if (cls.equals("LINE")) {
            return "LINE";
        }
        if (cls.equals("TEXT")) {
            return "TEXT";
        }
        if (cls.equals("MARKER")) {
            return "MARKER";
        }
        if (cls.equals("AREA")) {
            return "AREA";
        }
        return null;
    }

    public static Style getDefaultStyle(int gtype) {
        switch (gtype) {
            case 1: 
            case 5: {
                return _4Point;
            }
            case 2: 
            case 6: {
                return _4LineString;
            }
            case 3: 
            case 4: 
            case 7: {
                return _4Polygon;
            }
        }
        return null;
    }

    public static Style getDefaultTextStyle() {
        return _4Text;
    }

    public static AdvancedStyle createAdvancedStyle(Document doc, StyleCache sc, Hashtable dynaStyles) throws DataException {
        Node adv = XMLDOMParser.getSubElement(doc, "AdvancedStyle");
        if (adv == null) {
            System.err.println("Invalid advanced style definition.");
            return null;
        }
        try {
            Node elem = XMLDOMParser.getSubElement(adv, "BucketStyle");
            if (elem != null) {
                BucketStyle bs = new BucketStyle(doc);
                bs.resolveStyles(sc, dynaStyles);
                return bs;
            }
            elem = XMLDOMParser.getSubElement(XMLDOMParser.getSubElement(adv, "ColorSchemeStyle"), "Buckets");
            if (elem != null) {
                ColorSchemeStyle cs = new ColorSchemeStyle(doc);
                cs.resolveStyles(sc, dynaStyles);
                return cs;
            }
            elem = XMLDOMParser.getSubElement(XMLDOMParser.getSubElement(adv, "VariableMarkerStyle"), "Buckets");
            if (elem != null) {
                VariableMarkerStyle vms = new VariableMarkerStyle(doc);
                vms.resolveStyles(sc, dynaStyles);
                return vms;
            }
            elem = XMLDOMParser.getSubElement(XMLDOMParser.getSubElement(adv, "VariablePieChartStyle"), "Buckets");
            if (elem != null) {
                VariablePieChartStyle vpc = new VariablePieChartStyle(doc);
                vpc.resolveStyles(sc, dynaStyles);
                return vpc;
            }
            elem = XMLDOMParser.getSubElement(adv, "PieChartStyle");
            if (elem != null) {
                PieChartStyle pcs = new PieChartStyle(doc);
                pcs.resolveStyles(sc, dynaStyles);
                return pcs;
            }
            elem = XMLDOMParser.getSubElement(adv, "DotDensityStyle");
            if (elem != null) {
                DotDensityStyle dds = new DotDensityStyle(doc);
                dds.resolveStyles(sc, dynaStyles);
                return dds;
            }
            elem = XMLDOMParser.getSubElement(adv, "CollectionStyle");
            if (elem != null) {
                CollectionStyle cs = new CollectionStyle(doc);
                cs.resolveStyles(sc, dynaStyles);
                return cs;
            }
            elem = XMLDOMParser.getSubElement(adv, "BarChartStyle");
            if (elem != null) {
                BarChartStyle bcs = new BarChartStyle(doc);
                bcs.resolveStyles(sc, dynaStyles);
                return bcs;
            }
            elem = XMLDOMParser.getSubElement(adv, "HeatMapStyle");
            if (elem != null) {
                HeatMapStyle hms = new HeatMapStyle(doc);
                hms.resolveStyles(sc, dynaStyles);
                return hms;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static AdvancedStyle createAdvancedStyle(Document doc) throws DataException {
        Node adv = XMLDOMParser.getSubElement(doc, "AdvancedStyle");
        if (adv == null) {
            System.err.println("Invalid advanced style definition.");
            return null;
        }
        try {
            Node elem = XMLDOMParser.getSubElement(adv, "BucketStyle");
            if (elem != null) {
                BucketStyle bs = new BucketStyle(doc);
                return bs;
            }
            elem = XMLDOMParser.getSubElement(XMLDOMParser.getSubElement(adv, "ColorSchemeStyle"), "Buckets");
            if (elem != null) {
                return new ColorSchemeStyle(doc);
            }
            elem = XMLDOMParser.getSubElement(XMLDOMParser.getSubElement(adv, "VariableMarkerStyle"), "Buckets");
            if (elem != null) {
                VariableMarkerStyle vms = new VariableMarkerStyle(doc);
                return vms;
            }
            elem = XMLDOMParser.getSubElement(XMLDOMParser.getSubElement(adv, "VariablePieChartStyle"), "Buckets");
            if (elem != null) {
                VariablePieChartStyle vpc = new VariablePieChartStyle(doc);
                return vpc;
            }
            elem = XMLDOMParser.getSubElement(adv, "PieChartStyle");
            if (elem != null) {
                PieChartStyle pcs = new PieChartStyle(doc);
                return pcs;
            }
            elem = XMLDOMParser.getSubElement(adv, "DotDensityStyle");
            if (elem != null) {
                DotDensityStyle dds = new DotDensityStyle(doc);
                return dds;
            }
            elem = XMLDOMParser.getSubElement(adv, "CollectionStyle");
            if (elem != null) {
                CollectionStyle cs = new CollectionStyle(doc);
                return cs;
            }
            elem = XMLDOMParser.getSubElement(adv, "BarChartStyle");
            if (elem != null) {
                BarChartStyle bcs = new BarChartStyle(doc);
                return bcs;
            }
            elem = XMLDOMParser.getSubElement(adv, "HeatMapStyle");
            if (elem != null) {
                HeatMapStyle hms = new HeatMapStyle(doc);
                return hms;
            }
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            return null;
        }
    }

    public static String[] getStyleNames(Document doc) throws DataException {
        Node adv = XMLDOMParser.getSubElement(doc, "AdvancedStyle");
        if (adv == null) {
            System.err.println("Invalid advanced style definition.");
            return null;
        }
        String[] styleNames = null;
        int nBuckets = 0;
        try {
            Node elem = XMLDOMParser.getSubElement(XMLDOMParser.getSubElement(adv, "BucketStyle"), "Buckets");
            if (elem != null) {
                boolean equalranged = false;
                NodeList nl = elem.getChildNodes();
                Object aNode = null;
                if (nl != null) {
                    nBuckets = nl.getLength();
                }
                if (nBuckets == 0) {
                    equalranged = true;
                    nBuckets = Integer.parseInt(XMLDOMParser.getAttribute(elem, "nbuckets"));
                }
                if (equalranged) {
                    System.out.println("equal ranged buckets");
                    String stylenames = XMLDOMParser.getAttribute(elem, "styles");
                    if (stylenames != null && stylenames.length() > 5) {
                        ArrayList al = Util.splitBy(stylenames, ",");
                        styleNames = al.toArray(new String[al.size()]);
                    }
                } else {
                    styleNames = new String[nBuckets];
                    for (int i = 0; i < nBuckets; ++i) {
                        String stystr;
                        styleNames[i] = "";
                        Node e = nl.item(i);
                        if (e.getNodeName().equalsIgnoreCase("RangedBucket")) {
                            stystr = XMLDOMParser.getAttribute(e, "style");
                            if (stystr != null && stystr.length() > 0) {
                                styleNames[i] = stystr;
                                continue;
                            }
                            styleNames[i] = "";
                            continue;
                        }
                        if (!e.getNodeName().equalsIgnoreCase("CollectionBucket")) continue;
                        stystr = XMLDOMParser.getAttribute(e, "style");
                        styleNames[i] = stystr != null && stystr.length() > 0 ? stystr : "";
                    }
                }
                return styleNames;
            }
            elem = XMLDOMParser.getSubElement(adv, "VariableMarkerStyle");
            if (elem != null) {
                styleNames = new String[]{XMLDOMParser.getAttribute(elem, "basemarker")};
                return styleNames;
            }
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static void createDynamicStyles(Hashtable ht, String dsrc, VisContext vc) {
        Style st;
        String def;
        String name;
        if (ht == null || ht.size() == 0) {
            return;
        }
        Vector<String> lineDefs = new Vector<String>();
        Vector<String> areaDefs = new Vector<String>();
        Enumeration enumer = ht.keys();
        while (enumer.hasMoreElements()) {
            String type;
            name = (String)enumer.nextElement();
            def = (String)ht.get(name);
            if (def.indexOf("<AdvancedStyle") > 0 || (type = StyleFactory.getSimpleStyleTypeFromXML(def)) == null) continue;
            if (type.equals("LINE")) {
                lineDefs.add(name);
                lineDefs.add(def);
                continue;
            }
            if (type.equals("AREA")) {
                areaDefs.add(name);
                areaDefs.add(def);
                continue;
            }
            try {
                Style st2 = StyleFactory.createStyle(def, dsrc, vc);
                if (st2 == null) continue;
                st2.getModel().setName(name);
                vc.addDynamicStyle(name, st2);
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.getMessage(), e);
            }
        }
        if (lineDefs.size() > 0) {
            for (int i = 0; i < lineDefs.size(); i += 2) {
                String lname = (String)lineDefs.get(i);
                String ldef = (String)lineDefs.get(i + 1);
                try {
                    st = StyleFactory.createStyle(ldef, dsrc, vc);
                    if (st == null) continue;
                    st.getModel().setName(lname);
                    vc.addDynamicStyle(lname, st);
                    continue;
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.getMessage(), e);
                }
            }
        }
        if (areaDefs.size() > 0) {
            for (int i = 0; i < areaDefs.size(); i += 2) {
                String aname = (String)areaDefs.get(i);
                String adef = (String)areaDefs.get(i + 1);
                try {
                    st = StyleFactory.createStyle(adef, dsrc, vc);
                    if (st == null) continue;
                    st.getModel().setName(aname);
                    vc.addDynamicStyle(aname, st);
                    continue;
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.getMessage(), e);
                }
            }
        }
        enumer = ht.keys();
        while (enumer.hasMoreElements()) {
            name = (String)enumer.nextElement();
            def = (String)ht.get(name);
            if (def.indexOf("<AdvancedStyle") < 0) continue;
            try {
                st = StyleFactory.createStyle(def, dsrc, vc);
                if (st == null) continue;
                st.getModel().setName(name);
                vc.addDynamicStyle(name, st);
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    public static Style createStyle(String styleDef, String dsrc, VisContext vc) throws StyleException {
        Hashtable dns;
        int stytype = StyleUtils.getStyleTypeFromXML(styleDef);
        Style st = null;
        StyleCache scache = DSManager.getStyleCache(dsrc);
        Hashtable hashtable = dns = vc == null ? null : vc.getDynamicStyles();
        if (stytype == 9) {
            try {
                st = StyleFactory.createAdvancedStyle(XMLDOMParser.parseToDoc(styleDef), scache, dns);
            }
            catch (Exception e) {
                throw new StyleException("cannot create dynamic Advanced style.", e);
            }
        } else {
            int idx = styleDef.indexOf("<image_marker");
            st = idx > 0 ? StyleFactory.createImageMarkerStyle(styleDef, idx) : ((idx = styleDef.indexOf("<image_area")) > 0 ? StyleFactory.createImageAreaStyle(styleDef, idx) : StyleFactory.createStyleFromXML(styleDef));
            if (st != null) {
                st.resolveStyles(scache, dns);
            }
        }
        return st;
    }

    public static Style createImageMarkerStyle(String styleDef, int idx) throws StyleException {
        String imgUrl = null;
        XMLDOMParser parser = new XMLDOMParser();
        if (parser.parse(styleDef) && ((imgUrl = parser.getAttribute("image_marker", "url")) == null || imgUrl.trim().length() == 0)) {
            return null;
        }
        try {
            URL wu = new URL(imgUrl);
            byte[] pixels = Util.readBinaryFromURL(wu);
            return new StyleMarker(0, pixels, styleDef);
        }
        catch (Exception e) {
            throw new StyleException("Exception creating URL image marker style", e);
        }
    }

    public static Style createImageAreaStyle(String styleDef, int idx) throws StyleException {
        idx = styleDef.indexOf("url=\"", idx);
        int edx = styleDef.indexOf("\"", idx + 5);
        if (idx < 0 || edx < 0) {
            return null;
        }
        String imgUrl = styleDef.substring(idx + 5, edx);
        try {
            byte[] img = Util.readBinaryFromURL(imgUrl);
            if (img == null) {
                throw new StyleException("cannot load area pattern image from: " + imgUrl);
            }
            return new StyleArea(styleDef, img);
        }
        catch (Exception e) {
            throw new StyleException("cannot create image area style", e);
        }
    }

    public static Style createStyle(StyleRowData data, String dataSrc, VisContext vc) {
        return null;
    }

    public static Style createStyleObject(int type, String svgDef, byte[] imageData) {
        try {
            switch (type) {
                case 1: {
                    return new StyleColor(svgDef);
                }
                case 2: {
                    if (imageData == null) {
                        return new StyleMarker(svgDef);
                    }
                    return new StyleMarker(0, imageData, svgDef);
                }
                case 3: {
                    return new StyleLine(svgDef);
                }
                case 4: {
                    return new StyleArea(svgDef, imageData);
                }
                case 5: {
                    return new StyleText(svgDef);
                }
                case 9: {
                    return StyleFactory.createAdvancedStyle(XMLDOMParser.parseToDoc(svgDef));
                }
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

