/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.Theme;
import oracle.sdovis.theme.CustomGeomThemeDefinition;
import oracle.sdovis.theme.CustomGeomThemeProducer;

public class CustomGeomTheme
extends Theme {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);

    public CustomGeomTheme(String name, String providerId, Properties runtimeProp, String spatialCol, String srid, String featureStyleName, String labelCol, String labelStyleName) {
        CustomGeomThemeDefinition def = new CustomGeomThemeDefinition();
        this.setDefinition(def);
        this.setProducer(new CustomGeomThemeProducer(this));
        def.setName(name);
        def.setProviderID(providerId);
        def.setRuntimeProperties(runtimeProp);
        def.setSpatialColumn(spatialCol);
        def.setLabelColumn(labelCol);
        def.setFeatureStyleName(featureStyleName);
        def.setLabelStyleName(labelStyleName);
        int id = 0;
        try {
            id = Integer.parseInt(srid);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.getMessage(), e);
        }
        def.setSrid(id);
    }

    public CustomGeomTheme(CustomGeomThemeDefinition def) {
        this.setDefinition(def);
        this.setProducer(new CustomGeomThemeProducer(this));
    }

    public CustomGeomTheme(CustomGeomThemeDefinition def, Object[] bindingParameters) {
        this.setDefinition(def);
        this.setProducer(new CustomGeomThemeProducer(this, bindingParameters));
    }

    @Override
    public void destroy() {
        this.decorator = null;
        this.producer.destroy();
        this.definition = null;
    }

    @Override
    public boolean isTextLabelPresent() {
        CustomGeomThemeDefinition def = (CustomGeomThemeDefinition)this.definition;
        return def.getLabelColumn() != null && def.getLabelStyleName() != null;
    }
}

