/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share;

import java.awt.geom.Dimension2D;
import java.io.Serializable;
import oracle.mapviewer.share.SizeDefinition;

public class SizeDefinition2D
extends Dimension2D
implements Serializable {
    private double width = 0.0;
    private double height = 0.0;
    private String unit = null;

    public SizeDefinition2D() {
    }

    public SizeDefinition2D(double width, double height, String unit) {
        this.width = width;
        this.height = height;
        this.unit = unit;
    }

    @Override
    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    @Override
    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    @Override
    public void setSize(Dimension2D dims) {
        if (dims == null) {
            return;
        }
        this.width = dims.getWidth();
        this.height = dims.getHeight();
    }

    @Override
    public void setSize(double width, double height) {
        this.width = width;
        this.height = height;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public static SizeDefinition2D parse(String widthWithunit, String heightWithunit) {
        if (widthWithunit == null || heightWithunit == null) {
            return null;
        }
        SizeDefinition sw = SizeDefinition.parse(widthWithunit);
        if (sw == null) {
            return null;
        }
        SizeDefinition sh = SizeDefinition.parse(heightWithunit);
        if (sh == null) {
            return null;
        }
        return new SizeDefinition2D(sw.getValue(), sh.getValue(), sw.getUnit());
    }

    public boolean isPixelUnit() {
        return this.unit == null || this.unit.equalsIgnoreCase("pt") || this.unit.equalsIgnoreCase("px");
    }
}

