/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.table;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.ide.db.event.SwingDBObjectListener;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.extension.DatabaseExtensionHook;
import oracle.ideimpl.db.panels.ChildTableEditorPanel;
import oracle.ideimpl.db.panels.table.ConstraintEditorPanel;
import oracle.ideimpl.db.panels.table.ConstraintsPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.ConstraintIndexHelper;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.property.PropertyManager;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.table.GenericTableCellRenderer;
import oracle.javatools.util.ModelUtil;

public class SimpleCreateTablePanel
extends ChildTableEditorPanel<Column, Table> {
    private final List<DBObjectID> m_lastPKCols = new ArrayList<DBObjectID>();
    private Table.TableType m_tableType;

    public SimpleCreateTablePanel() {
        this("SimpleCreateTablePanel");
    }

    SimpleCreateTablePanel(String string) {
        super(string);
    }

    @Override
    protected void initialiseComponents() {
        super.initialiseComponents();
    }

    @Override
    protected String getChildProperty() {
        return "columns";
    }

    @Override
    protected boolean isHorizontalSplit() {
        return false;
    }

    @Override
    protected void initialisePanel() {
        Table.TableType tableType = (Table.TableType)((Table)this.getUpdatedObject()).getProperty("TableType");
        if (this.m_tableType != null && this.m_tableType != tableType) {
            this.initialiseTableColumns(true);
        }
        this.m_tableType = tableType;
        super.initialisePanel();
        this.getPKCols(this.m_lastPKCols);
    }

    @Override
    protected ChildTableEditorPanel.NewChildInsertPolicy getNewChildInsertPolicy() {
        return !this.isInFlatEditor() && this.getOriginalObject() != null ? ChildTableEditorPanel.NewChildInsertPolicy.AT_END : ChildTableEditorPanel.NewChildInsertPolicy.AFTER_SELECTED_ROW;
    }

    @Override
    protected DBObjectListener createChildObjectListener() {
        return new SwingDBObjectListener(){

            @Override
            protected void updateUI(DBObjectChange dBObjectChange) {
                if (SimpleCreateTablePanel.this.isEntered()) {
                    Collection collection = dBObjectChange.getAllChangedProperties();
                    if (collection.contains("dataTypeUsage")) {
                        SimpleCreateTablePanel.this.validate();
                        SimpleCreateTablePanel.this.repaint();
                    } else if (collection.contains("notNull")) {
                        PropertyChangeEvent propertyChangeEvent = dBObjectChange.getPropertyChange("notNull");
                        TableColumnModel tableColumnModel = SimpleCreateTablePanel.this.getWrapperTable().getColumnModel();
                        int n = SimpleCreateTablePanel.this.getWrapperTableModel().getCurrentRowIndx();
                        int n2 = tableColumnModel.getColumnIndex("notNull");
                        SimpleCreateTablePanel.this.getWrapperTableModel().setValueAt(propertyChangeEvent.getNewValue(), n, n2);
                    }
                }
            }
        };
    }

    private void getPKCols(List<DBObjectID> list) {
        PKConstraint pKConstraint = PKConstraint.getPrimaryKey((Relation)((Relation)this.getUpdatedObject()));
        list.clear();
        if (pKConstraint != null) {
            for (DBObjectID dBObjectID : pKConstraint.getColumnIDs()) {
                list.add(dBObjectID);
            }
        }
    }

    @Override
    protected void commitPanel() throws TraversalException {
        super.commitPanel();
        if (!this.isInFlatEditor()) {
            PKConstraint pKConstraint = PKConstraint.getPrimaryKey((Relation)((Relation)this.getUpdatedObject()));
            ArrayList<DBObjectID> arrayList = new ArrayList<DBObjectID>();
            this.getPKCols(arrayList);
            if (!arrayList.equals(this.m_lastPKCols) && pKConstraint != null) {
                ConstraintIndexHelper constraintIndexHelper = ConstraintEditorPanel.getIndexHelper(this.getDataContext());
                try {
                    constraintIndexHelper.ensureAndValidateIndexes((UniqueConstraint)pKConstraint, this.getValidationLevel());
                }
                catch (ValidationException validationException) {
                    throw new TraversalException(validationException.getMessage());
                }
            }
        }
    }

    @Override
    protected void initialiseTableComponents() {
        ChildTableEditorPanel.NonPropertyColumnLogic<Column> nonPropertyColumnLogic;
        Table table = (Table)this.getUpdatedObject();
        PropertyManager propertyManager = this.getProvider().getPropertyManager();
        Table table2 = (Table)this.getOriginalObject();
        Table.TableType tableType = (Table.TableType)table.getProperty("TableType");
        int n = 3;
        if (tableType != Table.TableType.EXTERNAL && propertyManager.canCreateProperty((SystemObject)table, "constraints") && SimpleCreateTablePanel.isValueSupported(propertyManager.getAllowedPropertyValues((DBObject)table2, (DBObject)table, "constraintType"), "PKConstraint")) {
            nonPropertyColumnLogic = new ChildTableEditorPanel.NonPropertyColumnLogic<Column>(){

                @Override
                public void setValueAt(Object object, int n, int n2) {
                    SimpleCreateTablePanel.this.addColumnToPK(object, n, n2);
                }

                @Override
                public Object getCellValue(Column column) {
                    return PKConstraint.isConstrained((Column)column, (String[])new String[]{"PKConstraint"});
                }

                @Override
                public boolean isCellEditable(Column column) {
                    return true;
                }
            };
            this.addColumn(0, "PK", Boolean.class, nonPropertyColumnLogic, (TableCellRenderer)((Object)new PKColRenderer()));
        } else {
            n = 2;
        }
        nonPropertyColumnLogic = new ChildTableEditorPanel.NonPropertyColumnLogic<Column>(){

            private DataType getDataType(DataTypeUsage dataTypeUsage) {
                DataType dataType = null;
                try {
                    dataType = DataTypeHelper.getDataType((DataTypeUsage)dataTypeUsage, (boolean)false);
                }
                catch (DBException dBException) {
                    SimpleCreateTablePanel.this.getLogger().fine(dBException.getMessage());
                }
                return dataType;
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                ChildTableEditorPanel.RowInfo rowInfo = SimpleCreateTablePanel.this.getWrapperTableModel().getRow(n);
                DataTypeUsage dataTypeUsage = ((Column)rowInfo.getRowObject()).getDataTypeUsage();
                DataType dataType = this.getDataType(dataTypeUsage);
                if (dataType != null) {
                    if (dataType.hasDataTypeAttribute("size")) {
                        this.putAttributeValue(dataTypeUsage, "size", object);
                    } else if (dataType.hasDataTypeAttribute("precision")) {
                        this.putAttributeValue(dataTypeUsage, "precision", object);
                    }
                    ((Column)rowInfo.getRowObject()).setDataTypeUsage(dataTypeUsage);
                }
            }

            @Override
            public Object getCellValue(Column column) {
                Object object = null;
                DataTypeUsage dataTypeUsage = column.getDataTypeUsage();
                if (dataTypeUsage != null) {
                    Object object2 = dataTypeUsage.getAttributeValue("size");
                    Object object3 = dataTypeUsage.getAttributeValue("precision");
                    if (object2 != null) {
                        object = object2;
                    } else if (object3 != null) {
                        object = object3;
                    }
                }
                return object;
            }

            @Override
            public String getPropertyPath(Column column) {
                String string = null;
                DataType dataType = this.getDataType(column.getDataTypeUsage());
                if (dataType != null) {
                    if (dataType.hasDataTypeAttribute("size")) {
                        string = "size";
                    } else if (dataType.hasDataTypeAttribute("precision")) {
                        string = "precision";
                    }
                }
                return string == null ? null : Property.createPath((String[])new String[]{"dataTypeUsage", "attributeValues", string});
            }

            @Override
            public boolean isCellEditable(Column column) {
                boolean bl = false;
                DataTypeUsage dataTypeUsage = column.getDataTypeUsage();
                try {
                    DataType dataType = DataTypeHelper.getDataType((DataTypeUsage)dataTypeUsage, (boolean)false);
                    if (dataType != null) {
                        DataTypeAttribute dataTypeAttribute = dataType.getDataTypeAttribute("size");
                        if (dataTypeAttribute == null) {
                            dataTypeAttribute = dataType.getDataTypeAttribute("precision");
                        }
                        if (dataTypeAttribute != null) {
                            bl = dataTypeAttribute.isDeclarable();
                        }
                    }
                }
                catch (DBException dBException) {
                    DBLog.getLogger((Object)this).warning(dBException.getMessage());
                }
                return bl;
            }

            private void putAttributeValue(DataTypeUsage dataTypeUsage, String string, Object object) {
                DataType dataType = this.getDataType(dataTypeUsage);
                if (dataType != null) {
                    dataTypeUsage.putAttributeValue(string, DataTypeHelper.getAttributeValue((Object)object, (DataType)dataType, (String)string));
                }
            }
        };
        if (this.includeSizeColumn()) {
            this.addColumn(n, UIBundle.get("SIMPLETABLE_SIZE"), String.class, nonPropertyColumnLogic, (TableCellRenderer)((Object)new SizeRenderer()));
        }
        this.configureRenderers();
    }

    protected boolean includeSizeColumn() {
        return true;
    }

    @Override
    protected String[] getPropertiesForRow() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("name");
        arrayList.add("dataTypeUsage");
        arrayList.add("notNull");
        arrayList.add("default");
        Collection<PropertyInfo> collection = DatabaseExtensionHook.getHook().getAutoIncludedProperties(this.getProvider(), Column.class);
        for (PropertyInfo propertyInfo : collection) {
            arrayList.add(propertyInfo.getPropertyName());
        }
        arrayList.add("Comment");
        return arrayList.toArray(new String[arrayList.size()]);
    }

    @Override
    protected Column newChild() {
        Column column = (Column)super.newChild();
        if (column.getDataTypeUsage() == null) {
            column.setDataTypeUsage(this.getProvider().getDescriptor().createDefaultTypeUsage());
        }
        return column;
    }

    @Override
    protected Class getChildClass() {
        return Column.class;
    }

    protected void removeChild(Column column) {
        Table table = (Table)this.getUpdatedObject();
        table.removeColumn(column);
    }

    @Override
    public boolean isTableCellEditable(int n, int n2) {
        Column column;
        boolean bl = true;
        ChildTableEditorPanel.RowInfo rowInfo = this.getWrapperTableModel().getRow(n);
        String string = this.getWrapperTableModel().getColumnName(n2);
        if (string.equals(PropertyDisplayRegistry.getDisplayName("default")) && (column = (Column)rowInfo.getRowObject()).getDefault() == null && (this.isVirtualColumn(column) || this.isIdentityColumn(column))) {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean canMoveRowDown() {
        return this.isInFlatEditor() || this.getOriginalObject() == null;
    }

    @Override
    public boolean canMoveRowToBottom() {
        return this.isInFlatEditor() || this.getOriginalObject() == null;
    }

    @Override
    public boolean canMoveRowToTop() {
        return this.isInFlatEditor() || this.getOriginalObject() == null;
    }

    @Override
    public boolean canMoveRowUp() {
        return this.isInFlatEditor() || this.getOriginalObject() == null;
    }

    private void configureRenderers() {
        this.setColumnCellRenderer("dataTypeUsage", (TableCellRenderer)((Object)new DTUCellRenderer()));
        this.setColumnCellRenderer("default", (TableCellRenderer)((Object)new DefaultValueCellRenderer()));
    }

    private void addColumnToPK(Object object, int n, int n2) {
        ChildTableEditorPanel.RowInfo rowInfo = this.getWrapperTableModel().getRow(n);
        Column column = (Column)rowInfo.getRowObject();
        Table table = (Table)this.getUpdatedObject();
        Boolean bl = (Boolean)object;
        if (bl.booleanValue()) {
            PKConstraint pKConstraint = PKConstraint.getPrimaryKey((Relation)table);
            boolean bl2 = false;
            if (pKConstraint == null) {
                pKConstraint = (PKConstraint)ConstraintsPanel.newConstraint((Relation)table, "PKConstraint", this.getProvider());
            } else {
                bl2 = true;
            }
            pKConstraint.addColumn(column);
            this.getWrapperTableModel().setValueForProperty(column, "notNull", object, n);
            if (!bl2) {
                table.addConstraint((Constraint)pKConstraint);
            }
        } else {
            PKConstraint pKConstraint = PKConstraint.getPrimaryKey((Relation)table);
            if (pKConstraint != null) {
                DBObjectID dBObjectID = column.getID();
                DBObjectID[] dBObjectIDArray = pKConstraint.getColumnIDs();
                if (Arrays.asList(dBObjectIDArray).contains(dBObjectID)) {
                    if (dBObjectIDArray.length == 1) {
                        if (this.confirmCascadeDelete((ChildDBObject)pKConstraint, (DBObject)table)) {
                            table.removeConstraint((Constraint)pKConstraint);
                            if (!this.isInFlatEditor()) {
                                ConstraintIndexHelper constraintIndexHelper = ConstraintEditorPanel.getIndexHelper(this.getDataContext());
                                constraintIndexHelper.clearNewUnusedIndexes(table);
                                this.m_lastPKCols.clear();
                            }
                        }
                    } else {
                        pKConstraint.removeColumn(column);
                    }
                }
            }
        }
        this.enterChildPanel(column);
    }

    private boolean isIdentityColumn(Column column) {
        return column != null && column.getIdentityProperties() != null;
    }

    private boolean isVirtualColumn(Column column) {
        return column != null && column.getVirtualExpressionSource() != null;
    }

    private static boolean isValueSupported(Collection collection, Object object) {
        return collection == null || collection.contains(object);
    }

    private class PKColRenderer
    extends GenericTableCellRenderer {
        private PKColRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            jLabel.setToolTipText(UIBundle.get("TABLE_TIP_ADD_TO_PK"));
            if (object != null) {
                if (object == Boolean.TRUE) {
                    jLabel.setIcon(OracleIcons.getIcon((String)"primarykey.png"));
                    jLabel.setText(null);
                } else {
                    jLabel.setIcon(null);
                    jLabel.setText(null);
                }
            }
            return jLabel;
        }
    }

    private class SizeRenderer
    extends GenericTableCellRenderer {
        private SizeRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            ChildTableEditorPanel.RowInfo rowInfo = SimpleCreateTablePanel.this.getWrapperTableModel().getRow(n);
            DataTypeUsage dataTypeUsage = ((Column)rowInfo.getRowObject()).getDataTypeUsage();
            if (dataTypeUsage != null) {
                Object object2 = dataTypeUsage.getAttributeValue("size");
                Object object3 = dataTypeUsage.getAttributeValue("precision");
                if (object2 != null) {
                    jLabel.setText(object2.toString());
                } else if (object3 != null) {
                    jLabel.setText(object3.toString());
                } else {
                    jLabel.setText(null);
                }
            }
            return jLabel;
        }
    }

    private class DTUCellRenderer
    extends GenericTableCellRenderer {
        private DTUCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            SimpleCreateTablePanel.this.setEnabled(true);
            n2 = jTable.convertColumnIndexToModel(n2);
            String string = SimpleCreateTablePanel.this.getWrapperTableModel().getColumnName(n2);
            Column column = null;
            DataTypeUsage dataTypeUsage = null;
            DBObjectID dBObjectID = null;
            ChildTableEditorPanel.RowInfo rowInfo = SimpleCreateTablePanel.this.getWrapperTableModel().getRow(n);
            if (rowInfo != null && (dataTypeUsage = (column = (Column)rowInfo.getRowObject()).getDataTypeUsage()) != null) {
                dBObjectID = dataTypeUsage.getDataTypeID();
            }
            boolean bl3 = SimpleCreateTablePanel.this.isVirtualColumn(column);
            String string2 = dBObjectID != null ? (SimpleCreateTablePanel.this.includeSizeColumn() ? DBUtil.getDBObjectName((DBObjectID)dBObjectID) : DataTypeHelper.getDDL((DataTypeUsage)dataTypeUsage, (DBObjectProvider)SimpleCreateTablePanel.this.getProvider())) : (bl3 ? UIBundle.get("TABLE_DTU_DERIVED") : UIBundle.get("TABLE_DTU_INVALID"));
            Icon icon = null;
            if (bl3) {
                icon = OracleIcons.getIcon((String)"function.png");
            } else if (SimpleCreateTablePanel.this.isIdentityColumn(column)) {
                icon = OracleIcons.getIcon((String)"sequence.png");
            }
            jLabel.setText(string2);
            jLabel.setIcon(icon);
            return jLabel;
        }
    }

    private class DefaultValueCellRenderer
    extends GenericTableCellRenderer {
        private DefaultValueCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            ChildTableEditorPanel.RowInfo rowInfo = SimpleCreateTablePanel.this.getWrapperTableModel().getRow(n);
            if (rowInfo != null) {
                Column column = (Column)rowInfo.getRowObject();
                String string = column.getVirtualExpressionSource();
                if (string != null) {
                    jLabel.setText(string);
                } else if (SimpleCreateTablePanel.this.isIdentityColumn(column)) {
                    jLabel.setText("<" + UIBundle.get("IDENTITY_COLUMN_PANEL_TITLE") + ">");
                }
            }
            return jLabel;
        }
    }

    private static class DtuMapKey {
        private String m_key;

        DtuMapKey(DataTypeUsage dataTypeUsage) {
            this.m_key = this.createKey(dataTypeUsage);
        }

        public boolean equals(Object object) {
            return object instanceof DtuMapKey ? ModelUtil.areEqual((Object)((DtuMapKey)object).m_key, (Object)this.m_key) : false;
        }

        public int hashCode() {
            return this.m_key.hashCode();
        }

        public String toString() {
            return this.m_key;
        }

        private String createKey(DataTypeUsage dataTypeUsage) {
            StringBuilder stringBuilder = new StringBuilder();
            DBObjectID dBObjectID = dataTypeUsage.getDataTypeID();
            stringBuilder.append(dBObjectID != null ? dBObjectID.toString() : "null");
            Map map = dataTypeUsage.getAttributeValues();
            ArrayList arrayList = new ArrayList(map.keySet());
            Collections.sort(arrayList);
            for (String string : arrayList) {
                stringBuilder.append(":").append(string).append("=").append(map.get(string));
            }
            return stringBuilder.toString();
        }
    }
}

