/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.model;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.model.Element;
import oracle.ide.util.dnd.DragDropManager;
import oracle.ide.util.dnd.DropHelper;
import oracle.ideimpl.db.extension.DatabaseUIExtensionHook;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.SystemObject;
import oracle.javatools.util.ModelUtil;

public class DatabaseDropHelper
implements DropHelper {
    public boolean canTransferData(Object object, DataFlavor[] dataFlavorArray, int n) {
        boolean bl = DatabaseDropHelper.containsSystemObjectFlavor(dataFlavorArray);
        if (bl) {
            Element element = DBObjectNodeUtil.getTreeNodeElement(object);
            String string = DBObjectNodeUtil.getProviderType(element);
            bl = ModelUtil.hasLength((String)string);
        }
        return bl;
    }

    public boolean transferData(Object object, Transferable[] element, int n) {
        String string;
        Object object2;
        boolean bl = false;
        String string2 = null;
        HashSet<DataFlavor> hashSet = new HashSet<DataFlavor>();
        Element element2 = element;
        int n2 = ((Transferable[])element2).length;
        block5: for (int i = 0; i < n2; ++i) {
            object2 = element2[i];
            for (DataFlavor dataFlavor : object2.getTransferDataFlavors()) {
                hashSet.add(dataFlavor);
                Class<?> clazz = dataFlavor.getRepresentationClass();
                if (!DBObjectProvider.class.isAssignableFrom(clazz)) continue;
                DBObjectProvider dBObjectProvider = null;
                try {
                    dBObjectProvider = (DBObjectProvider)object2.getTransferData(dataFlavor);
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    DBLog.logStackTrace((String)"Flavor not supported", (Throwable)unsupportedFlavorException);
                    string2 = null;
                    break block5;
                }
                catch (IOException iOException) {
                    DBLog.getLogger((Object)this).log(Level.WARNING, iOException.getMessage());
                    string2 = null;
                    break block5;
                }
                String string3 = dBObjectProvider.getProviderType();
                if (string2 != null && !string2.equals(string3)) {
                    string2 = null;
                    break block5;
                }
                string2 = string3;
            }
        }
        if (string2 != null && (string = DBObjectNodeUtil.getProviderType(element2 = DBObjectNodeUtil.getTreeNodeElement(object))) != null) {
            DataFlavor[] dataFlavorArray = hashSet.toArray(new DataFlavor[hashSet.size()]);
            object2 = DatabaseUIExtensionHook.getHook();
            List<DropHelper> list = ((DatabaseUIExtensionHook)object2).getDropHelpers(string2, string);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                DataFlavor dataFlavor;
                DropHelper dropHelper = (DropHelper)iterator.next();
                if (dropHelper == null) continue;
                try {
                    if (!bl && dropHelper.canTransferData(object, dataFlavorArray, n)) {
                        bl = dropHelper.transferData(object, (Transferable[])element, n);
                    }
                }
                catch (Exception exception) {
                    DBLog.logStackTrace((String)UIBundle.get("DRAG_AND_DROP_FAILED"), (Throwable)exception);
                }
                dataFlavor = DragDropManager.getInstance();
                dataFlavor.unRegisterDropHelperForInstance(dropHelper, Element.class);
                dataFlavor.registerDropHelperForInstance(dropHelper, Element.class);
            }
        }
        return bl;
    }

    public float getWeight() {
        return Float.MIN_VALUE;
    }

    public static boolean containsSystemObjectFlavor(DataFlavor[] dataFlavorArray) {
        boolean bl = false;
        for (DataFlavor dataFlavor : dataFlavorArray) {
            Class<?> clazz = dataFlavor.getRepresentationClass();
            if (!SystemObject.class.isAssignableFrom(clazz)) continue;
            bl = true;
            break;
        }
        return bl;
    }
}

