/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.controls;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.Document;
import oracle.bali.ewt.dateEditor.DateEditor;
import oracle.ide.db.components.ComponentContext;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlTokenPattern;
import oracle.javatools.db.plsql.PlSqlTokenizer;
import oracle.javatools.db.token.Token;
import oracle.javatools.db.token.TokenPattern;

public class MVRefreshDateExpressionPanel
extends JPanel {
    private static final String SYSDATE = "SYSDATE";
    private static final String SYSDATE_PLUS_1 = "SYSDATE + 1";
    private static final String SYSDATE_PLUS_124 = "SYSDATE + 1/24";
    private final PlSqlTokenPattern m_sysdateSearch = new PlSqlTokenPattern("SYSDATE");
    private final PlSqlTokenPattern m_dailySearch = new PlSqlTokenPattern("SYSDATE + 1");
    private final PlSqlTokenPattern m_hourlySearch = new PlSqlTokenPattern("SYSDATE + 1/24");
    private final PlSqlTokenPattern m_dateSearch = new PlSqlTokenPattern(this.getToDateString("<d ?>"));
    private final JComboBox m_mode = new JComboBox();
    private final DateEditor m_datePicker;
    private final JTextField m_text;

    public MVRefreshDateExpressionPanel() {
        this.m_mode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MVRefreshDateExpressionPanel.this.enableControls();
                MVRefreshDateExpressionPanel.this.updateText();
            }
        });
        this.m_datePicker = new DateEditor();
        this.m_text = new JTextField();
        this.m_datePicker.setDateFormat((DateFormat)new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss"));
        this.m_datePicker.addPropertyChangeListener("date", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                MVRefreshDateExpressionPanel.this.updateText();
            }
        });
        DBUILayoutHelper dBUILayoutHelper = new DBUILayoutHelper(this);
        dBUILayoutHelper.setMargins(0);
        dBUILayoutHelper.add(this.m_mode, 1, 1, false, false);
        dBUILayoutHelper.add((Component)this.m_datePicker, 1, 1, true, false);
        dBUILayoutHelper.add(this.m_text, 1, 1, true, false);
        dBUILayoutHelper.layout();
    }

    public void initialiseComponent(ComponentContext componentContext) {
        this.m_mode.addItem(ComboItem.UNSPECIFED);
        if ("firstRefresh".equals(componentContext.getPropertyName())) {
            this.m_mode.addItem(ComboItem.SYSDATE);
        } else {
            this.m_mode.addItem(ComboItem.DAILY);
            this.m_mode.addItem(ComboItem.HOURLY);
        }
        this.m_mode.addItem(ComboItem.DATE);
        this.m_mode.addItem(ComboItem.EXPRESSION);
        this.m_mode.setSelectedIndex(0);
    }

    public void setValue(String string) {
        this.m_text.setText(string);
        if (string == null) {
            this.m_mode.setSelectedItem((Object)ComboItem.UNSPECIFED);
        } else {
            PlSqlToken plSqlToken;
            PlSqlToken plSqlToken2 = plSqlToken = PlSqlTokenizer.tokenize((String)string, (String[])new String[0]);
            while (plSqlToken2.getNextCodeToken() != null && ((PlSqlToken)plSqlToken2.getNextCodeToken()).getType() != Token.Type.END_MARKER) {
                plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
            }
            TokenPattern.PatternResult patternResult = this.m_sysdateSearch.getResult((Token)plSqlToken);
            TokenPattern.PatternResult patternResult2 = this.m_dailySearch.getResult((Token)plSqlToken);
            TokenPattern.PatternResult patternResult3 = this.m_hourlySearch.getResult((Token)plSqlToken);
            TokenPattern.PatternResult patternResult4 = this.m_dateSearch.getResult((Token)plSqlToken);
            if (patternResult != null && patternResult.getEndToken() == plSqlToken2) {
                this.m_mode.setSelectedItem((Object)ComboItem.SYSDATE);
            } else if (patternResult2 != null && patternResult2.getEndToken() == plSqlToken2) {
                this.m_mode.setSelectedItem((Object)ComboItem.DAILY);
            } else if (patternResult3 != null && patternResult3.getEndToken() == plSqlToken2) {
                this.m_mode.setSelectedItem((Object)ComboItem.HOURLY);
            } else {
                String string2;
                boolean bl = false;
                if (patternResult4 != null && patternResult4.getEndToken() == plSqlToken2 && (string2 = patternResult4.getNamedMatch("d")).startsWith("'") && string2.endsWith("'")) {
                    string2 = string2.substring(1, string2.length() - 1);
                    try {
                        this.m_datePicker.setDateString(string2);
                        this.m_mode.setSelectedItem((Object)ComboItem.DATE);
                        bl = true;
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                if (!bl) {
                    this.m_mode.setSelectedItem((Object)ComboItem.EXPRESSION);
                }
            }
        }
        this.enableControls();
    }

    public final Document getDocument() {
        return this.m_text.getDocument();
    }

    private void updateText() {
        ComboItem comboItem = (ComboItem)((Object)this.m_mode.getSelectedItem());
        if (comboItem == ComboItem.UNSPECIFED) {
            this.m_text.setText(null);
        } else if (comboItem == ComboItem.SYSDATE) {
            this.m_text.setText(SYSDATE);
        } else if (comboItem == ComboItem.DAILY) {
            this.m_text.setText(SYSDATE_PLUS_1);
        } else if (comboItem == ComboItem.HOURLY) {
            this.m_text.setText(SYSDATE_PLUS_124);
        } else if (comboItem == ComboItem.DATE) {
            this.m_text.setText(this.getToDateString(this.m_datePicker.getDateString()));
        }
    }

    private void enableControls() {
        ComboItem comboItem = (ComboItem)((Object)this.m_mode.getSelectedItem());
        this.m_datePicker.setVisible(comboItem == ComboItem.DATE);
        this.m_datePicker.setEnabled(comboItem == ComboItem.DATE);
        this.m_text.setVisible(comboItem != ComboItem.DATE);
        this.m_text.setEnabled(comboItem != ComboItem.DATE);
        this.m_text.setEditable(comboItem == ComboItem.EXPRESSION);
    }

    public String getValue() {
        return this.m_text.getText();
    }

    @Override
    public void setEnabled(boolean bl) {
        this.m_mode.setEnabled(bl);
        if (bl) {
            this.enableControls();
        } else {
            this.m_datePicker.setEnabled(false);
            this.m_text.setEnabled(false);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.m_mode.isEnabled();
    }

    @Override
    public final void setName(String string) {
        super.setName(string);
        this.m_mode.setName(string + "_mode");
        this.m_datePicker.setName(string + "_datePicker");
        this.m_text.setName(string + "_text");
    }

    private String getToDateString(String string) {
        StringBuilder stringBuilder = new StringBuilder("TO_DATE('");
        stringBuilder.append(string);
        stringBuilder.append("','DD-MON-YYYY HH24:MI:SS')");
        return stringBuilder.toString();
    }

    private static enum ComboItem {
        UNSPECIFED("MV_REFRESH_DATE_EXPR_UNSPECIFIED"),
        SYSDATE("MV_REFRESH_DATE_EXPR_NOW"),
        DAILY("MV_REFRESH_DATE_EXPR_DAILY"),
        HOURLY("MV_REFRESH_DATE_EXPR_HOURLY"),
        DATE("MV_REFRESH_DATE_EXPR_DATE"),
        EXPRESSION("MV_REFRESH_DATE_EXPR_EXPRESSION");

        final String m_text;

        private ComboItem(String string2) {
            this.m_text = UIBundle.get(string2);
        }

        public String toString() {
            return this.m_text;
        }
    }
}

