/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.controls;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.execute.StatementWrapper;
import oracle.javatools.util.ModelUtil;

public abstract class AbstractLazyCombo
extends JComboBox
implements ListCellRenderer {
    private final Object NULL_OBJ = new Object();
    private final DefaultListCellRenderer m_delegateLCR = new DefaultListCellRenderer();
    private boolean m_gotModel = false;
    private boolean m_inMenuWillBecomeVisible = false;
    private boolean m_menuVisible = false;
    private boolean m_settingModel = false;
    private Thread m_loadingThread = null;

    public AbstractLazyCombo() {
        this.setRenderer(this);
        this.setEditor(new CustomComboBoxEditor());
        this.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                AbstractLazyCombo.this.doBeforeLoading();
                if (!AbstractLazyCombo.this.m_gotModel && !AbstractLazyCombo.this.m_inMenuWillBecomeVisible) {
                    AbstractLazyCombo.this.loadModel();
                }
                AbstractLazyCombo.this.m_menuVisible = true;
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                AbstractLazyCombo.this.m_menuVisible = false;
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                AbstractLazyCombo.this.m_menuVisible = false;
            }
        });
    }

    protected abstract List getModelEntries();

    public String getNullText() {
        return null;
    }

    protected Icon getIcon(Object object) {
        return null;
    }

    public void reset() {
        this.cancel();
        this.m_gotModel = false;
    }

    public final void cancel() {
        Thread thread = this.m_loadingThread;
        if (thread != null && thread.isAlive()) {
            thread.interrupt();
            StatementWrapper.cancelExecution((Thread)thread);
        }
    }

    @Override
    protected void processFocusEvent(FocusEvent focusEvent) {
        if (!this.m_menuVisible) {
            super.processFocusEvent(focusEvent);
        }
    }

    protected final void loadModel() {
        if (!this.m_gotModel) {
            Object object = this.getCurrentValue();
            DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>();
            if (!this.isEditable()) {
                defaultComboBoxModel.addElement(object);
            }
            defaultComboBoxModel.addElement(UIBundle.get("DBOBJECT_TREE_LOADING_NODE"));
            defaultComboBoxModel.setSelectedItem(object);
            this.setModel(defaultComboBoxModel, false);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    String string = AbstractLazyCombo.this.getNullText();
                    final ArrayList<Object> arrayList = new ArrayList<Object>();
                    if (string != null) {
                        arrayList.add(AbstractLazyCombo.this.NULL_OBJ);
                    }
                    arrayList.addAll(AbstractLazyCombo.this.getModelEntries());
                    final Thread thread = Thread.currentThread();
                    if (AbstractLazyCombo.this.isVisible() && !thread.isInterrupted()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (AbstractLazyCombo.this.isVisible() && !thread.isInterrupted()) {
                                    Object object = AbstractLazyCombo.this.getCurrentValue();
                                    boolean bl = AbstractLazyCombo.this.isPopupVisible();
                                    DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
                                    Object object2 = arrayList.iterator();
                                    while (object2.hasNext()) {
                                        Object e = object2.next();
                                        defaultComboBoxModel.addElement(e);
                                    }
                                    defaultComboBoxModel.setSelectedItem(object == null ? AbstractLazyCombo.this.NULL_OBJ : object);
                                    AbstractLazyCombo.this.setModel(defaultComboBoxModel, true);
                                    if (bl) {
                                        AbstractLazyCombo.this.showPopup();
                                    }
                                    if ((object2 = Logger.getLogger("oracle.abbot.test")) != null) {
                                        ((Logger)object2).log(Level.FINE, AbstractLazyCombo.this.getLoadMessage());
                                    }
                                }
                            }
                        });
                    }
                }
            };
            Thread thread = this.m_loadingThread;
            if (thread == null || thread.isInterrupted() || !thread.isAlive()) {
                this.m_loadingThread = new Thread(runnable, "loadModelEntries");
                this.m_loadingThread.start();
            }
        }
    }

    protected String getLoadMessage() {
        return this.getName() + ".loaded";
    }

    protected void doBeforeClearingModel() {
    }

    protected void doBeforeLoading() {
    }

    protected void doAfterClearingModel() {
    }

    public void setModel(ComboBoxModel comboBoxModel) {
        this.setModel(comboBoxModel, false);
    }

    public void setModel(ComboBoxModel comboBoxModel, boolean bl) {
        try {
            this.m_settingModel = true;
            this.doBeforeClearingModel();
            super.setModel(comboBoxModel);
        }
        finally {
            this.doAfterClearingModel();
            this.m_settingModel = false;
            this.m_gotModel = bl;
        }
    }

    @Override
    public void revalidate() {
        if (!this.m_settingModel) {
            super.revalidate();
        }
    }

    @Override
    public Object getSelectedItem() {
        Object object = super.getSelectedItem();
        if (object == this.NULL_OBJ) {
            return null;
        }
        if (UIBundle.get("DBOBJECT_TREE_LOADING_NODE").equals(object)) {
            Component component = this.getEditor().getEditorComponent();
            if (component instanceof JTextField && this.isEditable()) {
                String string = ((JTextField)component).getText();
                return !ModelUtil.hasLength((String)string) || this.isInternalValue(string) ? null : string;
            }
            Object e = this.getModel().getElementAt(0);
            if (e == null) {
                return null;
            }
            return e.equals(UIBundle.get("DBOBJECT_TREE_LOADING_NODE")) ? null : e;
        }
        return object;
    }

    @Override
    public void setSelectedItem(Object object) {
        if (object == null) {
            object = this.NULL_OBJ;
        }
        super.setSelectedItem(object);
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        Component component;
        Object object2 = object;
        if (object == null || object == this.NULL_OBJ) {
            object = this.getNullText();
            object2 = null;
        }
        if ((component = this.m_delegateLCR.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2)) instanceof JLabel) {
            ((JLabel)component).setIcon(this.getIcon(object2));
            if (object != null && UIBundle.get("DBOBJECT_TREE_LOADING_NODE").equals(object)) {
                component.setEnabled(false);
            }
        }
        return component;
    }

    public boolean isModelLoaded() {
        return this.m_gotModel;
    }

    protected boolean isInternalValue(Object object) {
        return this.NULL_OBJ == object || UIBundle.get("DBOBJECT_TREE_LOADING_NODE").equals(object);
    }

    private Object getCurrentValue() {
        String string;
        Component component = this.getEditor().getEditorComponent();
        Object object = component instanceof JTextField && this.isEditable() ? (!ModelUtil.hasLength((String)(string = ((JTextField)component).getText())) || this.isInternalValue(string) ? this.NULL_OBJ : string) : this.getSelectedItem();
        return object;
    }

    protected JTextField createEditorTextField() {
        return new CustomJTextField();
    }

    private class CustomComboBoxEditor
    extends BasicComboBoxEditor {
        private CustomComboBoxEditor() {
        }

        @Override
        protected JTextField createEditorComponent() {
            return AbstractLazyCombo.this.createEditorTextField();
        }
    }

    protected class CustomJTextField
    extends JTextField {
        public CustomJTextField() {
            super("", 9);
        }

        @Override
        protected void processFocusEvent(FocusEvent focusEvent) {
            if (!AbstractLazyCombo.this.m_menuVisible) {
                super.processFocusEvent(focusEvent);
            }
        }

        @Override
        public void setText(String string) {
            if (ModelUtil.areDifferent((Object)this.getText(), (Object)string)) {
                super.setText(string);
            }
        }

        @Override
        public String getName() {
            String string;
            Object object = super.getName();
            if (object == null && (string = this.getBaseName()) != null) {
                object = string + "-editor";
            }
            return object;
        }

        protected String getBaseName() {
            return AbstractLazyCombo.this.getName();
        }
    }
}

