/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.components;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import oracle.bali.ewt.dateEditor.DateEditor;
import oracle.ide.db.components.ComponentWrapper;

public class DatePropertyComponentWrapper
extends ComponentWrapper<DateEditor> {
    private static final DateFormat DEFAULT_FORMAT = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");

    public DatePropertyComponentWrapper() {
        super(new DateEditor(new Date(), Calendar.getInstance(), DEFAULT_FORMAT));
    }

    @Override
    public Object getPropertyValue() {
        return ((DateEditor)this.getActiveComponent()).getDate();
    }

    @Override
    public void setPropertyValue(Object object) {
        ((DateEditor)this.getActiveComponent()).setDate((Date)object);
    }

    @Override
    protected void initialiseComponentListener() {
        ((DateEditor)this.getActiveComponent()).addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("date".equals(propertyChangeEvent.getPropertyName())) {
                    DatePropertyComponentWrapper.this.fireChangeEvent();
                }
            }
        });
    }
}

