/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.sql.tester;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellEditor;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.db.panels.sql.tester.SQLQueryTester;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.Database;
import oracle.javatools.db.sql.SQLFragmentUtils;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.ui.table.SimpleTableFormat;
import oracle.javatools.ui.table.SimpleTableModel;
import oracle.javatools.util.Pair;

public abstract class TesterComponent {
    private Map<String, Object> m_bindVariables;
    private SQLQueryTester m_tester;

    public abstract void testSQL(Database var1, String var2);

    public abstract Component getComponent();

    public abstract String getName();

    public void close() {
    }

    void setTester(SQLQueryTester sQLQueryTester) {
        this.m_tester = sQLQueryTester;
    }

    protected SQLQueryTester getTester() {
        return this.m_tester;
    }

    protected void setBindVariables(Map<String, Object> map) {
        this.m_bindVariables = map;
    }

    protected Map<String, ?> getBindVariables(Database database, String string) {
        this.promptForBindVariables(database, string);
        return this.m_bindVariables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void promptForBindVariables(Database database, String string) {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string22 : SQLFragmentUtils.listBindVariables((String)string)) {
            hashSet.add(string22);
        }
        if (hashSet.size() > 0) {
            String string22;
            if (this.m_bindVariables == null) {
                this.m_bindVariables = new HashMap<String, Object>();
            }
            for (String string22 : hashSet) {
                if (this.m_bindVariables.containsKey(string22)) continue;
                this.m_bindVariables.put(string22, null);
            }
            BindVariablePanel bindVariablePanel = new BindVariablePanel(this.m_bindVariables);
            string22 = JEWTDialog.createDialog((Component)this.getComponent(), (String)UIBundle.get("TESTSQL_BIND_TITLE"), (int)5);
            string22.setContent(bindVariablePanel.getComponent());
            string22.setMinimumSize(400, 300);
            string22.setPreferredSize(400, 300);
            string22.setResizable(true);
            string22.setName("SQLQueryTester.BindDialog");
            try {
                string22.runDialog();
                Iterator<Map.Entry<String, ?>> iterator = bindVariablePanel.getBindVariables().entrySet().iterator();
                while (iterator.hasNext()) {
                    Object obj;
                    Map.Entry<String, ?> entry;
                    this.m_bindVariables.put(entry.getKey(), (obj = (entry = iterator.next()).getValue()) == null ? "" : obj);
                }
            }
            finally {
                string22.dispose();
            }
        }
    }

    private static class BindVariablePanel {
        private final SimpleTableModel<Pair> m_tableModel;
        private final GenericTable m_table;
        private final JPanel m_panel;

        public BindVariablePanel(Map<String, Object> map) {
            ArrayList<Pair> arrayList = new ArrayList<Pair>();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                arrayList.add(new Pair((Object)entry.getKey(), entry.getValue()));
            }
            this.m_tableModel = new SimpleTableModel(arrayList, (SimpleTableFormat)new PairTableFormat());
            this.m_table = new GenericTable(this.m_tableModel);
            this.m_table.setColumnSelectorAvailable(false);
            this.m_table.setColumnHeaderSelectionEnabled(false);
            this.m_table.setSelectAllEnabled(false);
            this.m_table.setName("BindVariablePanel.Table");
            JWrappedLabel jWrappedLabel = new JWrappedLabel(UIBundle.get("TESTSQL_BIND_DESC"));
            this.m_panel = new JPanel();
            HelpUtils.setHelpID((JComponent)this.m_panel, (String)"f1_odbsqltestbindvariable_html");
            this.m_panel.setName("BindVariablePanel");
            this.m_panel.setLayout(new BorderLayout(0, 15));
            this.m_panel.add((Component)jWrappedLabel, "North");
            this.m_panel.add((Component)new JScrollPane((Component)this.m_table), "Center");
        }

        public Component getComponent() {
            return this.m_panel;
        }

        public Map<String, ?> getBindVariables() {
            TableCellEditor tableCellEditor = this.m_table.getCellEditor();
            if (tableCellEditor != null) {
                tableCellEditor.stopCellEditing();
            }
            TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
            for (Pair pair : this.m_tableModel.asList()) {
                treeMap.put((String)pair.getFirst(), pair.getSecond());
            }
            return treeMap;
        }
    }

    public static abstract class DelegateTesterComponent
    extends TesterComponent {
        private TesterComponent m_delegate;

        @Override
        public abstract String getName();

        protected abstract TesterComponent createDelegate();

        protected final TesterComponent getDelegate() {
            if (this.m_delegate == null) {
                this.m_delegate = this.createDelegate();
                this.m_delegate.setTester(this.getTester());
            }
            return this.m_delegate;
        }

        @Override
        public Component getComponent() {
            Component component = null;
            TesterComponent testerComponent = this.getDelegate();
            if (testerComponent != null) {
                component = testerComponent.getComponent();
            }
            return component;
        }

        @Override
        public void testSQL(Database database, String string) {
            TesterComponent testerComponent = this.getDelegate();
            if (testerComponent != null) {
                testerComponent.testSQL(database, string);
            }
        }

        @Override
        public void close() {
            TesterComponent testerComponent = this.m_delegate;
            if (testerComponent != null) {
                testerComponent.close();
                this.m_delegate = null;
            }
        }

        @Override
        protected Map<String, ?> getBindVariables(Database database, String string) {
            TesterComponent testerComponent = this.getDelegate();
            return testerComponent == null ? super.getBindVariables(database, string) : testerComponent.getBindVariables(database, string);
        }

        @Override
        protected void setBindVariables(Map<String, Object> map) {
            super.setBindVariables(map);
            TesterComponent testerComponent = this.getDelegate();
            if (testerComponent != null) {
                testerComponent.setBindVariables(map);
            }
        }
    }

    private static class PairTableFormat
    implements SimpleTableFormat<Pair> {
        private PairTableFormat() {
        }

        public Class getColumnClass(int n) {
            return String.class;
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int n) {
            return n == 0 ? UIBundle.get("TESTSQL_BIND_NAME") : UIBundle.get("TESTSQL_BIND_VALUE");
        }

        public Object getValueAt(Pair pair, int n) {
            return n == 0 ? pair.getFirst() : pair.getSecond();
        }

        public boolean isCellEditable(Pair pair, int n) {
            return n == 1;
        }

        public void setValueAt(Pair pair, Object object, int n) {
            if (n == 1) {
                pair.setSecond(object);
            }
        }
    }
}

