/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.ide.db.ProviderOperator;
import oracle.ide.db.components.ComponentContext;
import oracle.ideimpl.db.DBUIMnemonicBuilder;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.ideimpl.db.validate.DBValidationHandler;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.property.PropertyAction;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.property.PropertyManager;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.Holder;

public abstract class ComponentWrapper<T extends Component> {
    private static final String DEBUG_DISABLED = "ComponentWrapper.DEBUG_DISABLED";
    private Collection<PropertyChangeListener> m_listeners;
    private Collection<VetoableChangeListener> m_vetoListeners;
    private final T m_activeComponent;
    private Component m_component;
    private boolean m_active;
    private boolean m_readOnly;
    private boolean m_committing;
    private boolean m_settingValue;
    private ComponentContext m_componentContext;
    private boolean m_isSupported = true;
    private Boolean m_volatile = null;
    private JLabel m_label = null;
    private String m_displayName;

    public ComponentWrapper(T t) {
        this.m_activeComponent = t;
    }

    protected Logger getLogger() {
        return DBLog.getLogger((Object)this);
    }

    public final void initialise(ComponentContext componentContext) {
        this.m_componentContext = componentContext;
        this.initialiseComponent();
        T t = this.getActiveComponent();
        if (t instanceof JComponent) {
            ((JComponent)t).putClientProperty(ComponentContext.class, componentContext);
        }
        this.initialiseComponentListener();
    }

    public boolean refreshObject(DBObject dBObject) {
        boolean bl = false;
        ComponentContext componentContext = this.getComponentContext();
        if (dBObject != componentContext.getUpdatedObject()) {
            bl = true;
            this.getComponentContext().setUpdatedObject(dBObject);
        }
        if (dBObject != null) {
            this.setComponentValueFromObject();
        } else {
            this.setPropertyValueDirectly(null);
        }
        return bl;
    }

    private void setComponentValueFromObject() {
        if (this.getUpdatedObject() != null) {
            PropertyHelper propertyHelper = this.getPropertyHelper();
            Object object = propertyHelper.getPropertyValue((Object)this.getUpdatedObject(), this.getPropertyName());
            this.setPropertyValueDirectly(object);
        }
    }

    private void setPropertyValueDirectly(Object object) {
        this.m_settingValue = true;
        try {
            this.setPropertyValue(object);
        }
        finally {
            this.m_settingValue = false;
        }
    }

    public final void setActive(boolean bl) {
        if (this.m_active != bl) {
            if (bl) {
                this.setComponentValueFromObject();
            }
            this.m_active = bl;
            this.setActiveImpl(bl);
        }
    }

    public final boolean isActive() {
        return this.m_active;
    }

    protected void setActiveImpl(boolean bl) {
    }

    public final boolean isVolatile() {
        if (this.m_volatile == null) {
            ComponentContext componentContext;
            PropertyManager propertyManager = this.getProvider().getPropertyManager();
            this.m_volatile = !propertyManager.getRestrictingProperties((componentContext = this.getComponentContext()).getUpdatedSystemObject().getClass(), componentContext.getFullPropertyPath()).isEmpty();
        }
        return this.m_volatile;
    }

    public final T getActiveComponent() {
        return this.m_activeComponent;
    }

    protected Component createComponentForLayout() {
        return this.getActiveComponent();
    }

    public final Component getComponent() {
        if (this.m_component == null) {
            this.m_component = this.createComponentForLayout();
        }
        return this.m_component;
    }

    public Component getDefaultFocusComponent() {
        return this.getActiveComponent();
    }

    public void setValidationStatus(Collection<ValidationException> collection, DBValidationHandler dBValidationHandler) {
        Component component = this.getDefaultValidationComponent();
        if (component != null) {
            dBValidationHandler.processValidation(component, this, collection);
        }
    }

    protected Component getDefaultValidationComponent() {
        return this.getDefaultFocusComponent();
    }

    public abstract Object getPropertyValue();

    public abstract void setPropertyValue(Object var1);

    public final void resetPropertyValue(Object object) {
        this.setDBObjectPropertyValue(object);
        this.setPropertyValueDirectly(object);
    }

    public void setEnabled(boolean bl) {
        T t = this.getActiveComponent();
        if (ComponentWrapper.isDebug() && ComponentWrapper.isDebugDisabled(t)) {
            return;
        }
        ((Component)t).setEnabled(bl);
        JLabel jLabel = this.getLabel();
        if (jLabel != null) {
            jLabel.setEnabled(bl);
        }
    }

    public void setVisible(boolean bl) {
        T t = this.getActiveComponent();
        JLabel jLabel = this.getLabel();
        if (!bl && ComponentWrapper.isDebug()) {
            ComponentWrapper.setDebugEnabled(t, jLabel, false);
        } else {
            if (ComponentWrapper.isDebug()) {
                ComponentWrapper.setDebugEnabled(t, jLabel, true);
            }
            this.setVisibleImpl((Component)t, this.getComponent(), bl);
            if (jLabel != null) {
                this.getLabel().setVisible(bl);
            }
        }
    }

    private void setVisibleImpl(Component component, Component component2, boolean bl) {
        Container container;
        component.setVisible(bl);
        if (component != component2 && (container = component.getParent()) != null) {
            this.setVisibleImpl(container, component2, bl);
        }
    }

    public final String getPropertyName() {
        return this.getComponentContext().getPropertyName();
    }

    public JLabel getLabel() {
        if (this.m_label == null) {
            this.m_label = new JLabel(this.getPropertyDisplayName());
        }
        return this.m_label;
    }

    public String getPropertyDisplayName() {
        if (this.m_displayName == null) {
            this.m_displayName = PropertyDisplayRegistry.getDisplayName(this.getPropertyName(), this.getProvider(), this.getUpdatedObject());
        }
        return this.m_displayName;
    }

    public void setPropertyDisplayName(String string) {
        this.m_displayName = string;
    }

    protected abstract void initialiseComponentListener();

    protected void initialiseComponent() {
    }

    public final synchronized void addListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener != null) {
            if (this.m_listeners == null) {
                this.m_listeners = new CopyOnWriteArrayList<PropertyChangeListener>();
            }
            if (!this.m_listeners.contains(propertyChangeListener)) {
                this.m_listeners.add(propertyChangeListener);
            }
        }
    }

    public final synchronized void addVetoListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener != null) {
            if (this.m_vetoListeners == null) {
                this.m_vetoListeners = new CopyOnWriteArrayList<VetoableChangeListener>();
            }
            if (!this.m_vetoListeners.contains(vetoableChangeListener)) {
                this.m_vetoListeners.add(vetoableChangeListener);
            }
        }
    }

    public final void removeListener(PropertyChangeListener propertyChangeListener) {
        if (this.m_listeners != null) {
            this.m_listeners.remove(propertyChangeListener);
        }
    }

    public final void removeVetoListener(VetoableChangeListener vetoableChangeListener) {
        if (this.m_vetoListeners != null) {
            this.m_vetoListeners.remove(vetoableChangeListener);
        }
    }

    public void processComponent(boolean bl, boolean bl2) {
        ComponentContext componentContext = this.getComponentContext();
        if (componentContext == null) {
            throw new IllegalStateException("Cannot call processComponents before initialise");
        }
        PropertyManager propertyManager = this.getProvider().getPropertyManager();
        SystemObject systemObject = componentContext.getOriginalSystemObject();
        SystemObject systemObject2 = componentContext.getUpdatedSystemObject();
        DBObject dBObject = this.getUpdatedObject();
        this.m_isSupported = this.checkPropertyIsSupported();
        if (this.m_isSupported) {
            boolean bl3;
            boolean bl4 = bl3 = !bl || dBObject == null;
            if (!bl3) {
                PropertyAction.Type type;
                String string = componentContext.getFullPropertyPath();
                PropertyAction propertyAction = propertyManager.canChangeProperty(systemObject, systemObject2, string);
                PropertyAction.Type type2 = type = propertyAction == null ? null : propertyAction.getType();
                if (systemObject == null) {
                    if (type != PropertyAction.Type.CREATE) {
                        bl3 = true;
                    }
                } else if (type != PropertyAction.Type.ALTER) {
                    if (type == PropertyAction.Type.REPLACE) {
                        this.getLogger().fine("will need replace for: " + this.getPropertyName());
                        bl3 = !bl2;
                    } else {
                        bl3 = true;
                    }
                }
            }
            this.setVisible(true);
            this.setEnabled(!bl3);
        } else if (systemObject2 == null) {
            this.m_isSupported = true;
        } else {
            this.setVisible(false);
        }
        if (componentContext.getFullPropertyPath().contains("attributeValues")) {
            this.setVisible(true);
        }
    }

    protected boolean checkPropertyIsSupported() {
        PropertyManager propertyManager = this.getProvider().getPropertyManager();
        SystemObject systemObject = this.getComponentContext().getUpdatedSystemObject();
        boolean bl = true;
        DBObject dBObject = this.getUpdatedObject();
        if (dBObject != null && dBObject != systemObject) {
            bl = propertyManager.supportsProperty(dBObject.getClass(), this.getPropertyName());
        }
        String string = this.getComponentContext().getFullPropertyPath();
        boolean bl2 = false;
        if (systemObject != null) {
            if (!propertyManager.supportsProperty(systemObject.getClass(), string)) {
                JLabel jLabel = this.getLabel();
                if (jLabel == null) {
                    jLabel = this.getActiveComponent();
                }
                DBUIMnemonicBuilder.setIgnoreComponent(jLabel, true);
                bl2 = false;
            } else {
                bl2 = propertyManager.canCreateProperty(systemObject, string);
            }
        }
        return bl && bl2;
    }

    protected final Object getExistingPropertyValue() {
        return this.getPropertyValueFromModel(this.getUpdatedObject());
    }

    protected final Object getOriginalPropertyValue() {
        return this.getPropertyValueFromModel(this.getOriginalObject());
    }

    private Object getPropertyValueFromModel(DBObject dBObject) {
        PropertyInfo propertyInfo;
        Object object = null;
        if (dBObject != null && (propertyInfo = this.getComponentContext().getPropertyInfo()) != null) {
            String string = this.getPropertyName();
            PropertyHelper propertyHelper = this.getPropertyHelper();
            object = propertyHelper.getPropertyValue((Object)dBObject, string);
        }
        return object;
    }

    private void setDBObjectPropertyValue(Object object) {
        PropertyInfo propertyInfo;
        DBObject dBObject = this.getUpdatedObject();
        if (dBObject != null && (propertyInfo = this.getComponentContext().getPropertyInfo()) != null) {
            String string = this.getPropertyName();
            PropertyHelper propertyHelper = this.getPropertyHelper();
            try {
                propertyHelper.setPropertyValueOrFail((Object)dBObject, string, object);
            }
            catch (Exception exception) {
                this.getLogger().log(Level.SEVERE, this.getPropertyName(), exception);
            }
        }
    }

    protected final boolean fireChangeEvent() {
        boolean bl;
        try {
            this.fireChangeEventImpl(true);
            bl = true;
        }
        catch (PropertyVetoException propertyVetoException) {
            bl = false;
            this.setComponentValueFromObject();
        }
        return bl;
    }

    protected final void fireVetoableChangeEvent() throws PropertyVetoException {
        this.fireChangeEventImpl(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChangeEventImpl(boolean bl) throws PropertyVetoException {
        if (this.m_active && !this.m_committing && !this.m_settingValue && this.m_isSupported) {
            this.m_committing = true;
            try {
                if (this.m_readOnly) {
                    this.setComponentValueFromObject();
                } else {
                    Object object = this.getExistingPropertyValue();
                    final Object object2 = this.getPropertyValue();
                    final PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this.getActiveComponent(), "value", object, object2);
                    if (this.m_vetoListeners != null && this.m_vetoListeners.size() > 0) {
                        for (VetoableChangeListener vetoableChangeListener : this.m_vetoListeners) {
                            try {
                                vetoableChangeListener.vetoableChange(propertyChangeEvent);
                            }
                            catch (PropertyVetoException propertyVetoException) {
                                String string;
                                if (bl && (string = propertyVetoException.getMessage()) != null) {
                                    this.showError(string);
                                }
                                throw propertyVetoException;
                            }
                            catch (Exception exception) {
                                this.logListenerException(exception, vetoableChangeListener);
                            }
                        }
                    }
                    DBUtil.invokeCompoundChange((DBObject)this.getUpdatedObject(), (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ComponentWrapper.this.setDBObjectPropertyValue(object2);
                            if (ComponentWrapper.this.m_listeners != null && ComponentWrapper.this.m_listeners.size() > 0) {
                                for (PropertyChangeListener propertyChangeListener : ComponentWrapper.this.m_listeners) {
                                    try {
                                        propertyChangeListener.propertyChange(propertyChangeEvent);
                                    }
                                    catch (Exception exception) {
                                        ComponentWrapper.this.logListenerException(exception, propertyChangeListener);
                                    }
                                }
                            }
                        }
                    }, (boolean)true);
                }
            }
            finally {
                this.m_committing = false;
            }
        }
    }

    protected void showError(String string) {
        String string2 = ProviderOperator.getErrorTitle(this.getComponentContext().getEditorConfig());
        MessageDialog.error(this.getActiveComponent(), (Object)string, (String)string2, null);
    }

    private void logListenerException(Exception exception, Object object) {
        this.getLogger().log(DBLog.getExceptionLogLevel(), object.getClass().getName(), exception);
    }

    protected final PropertyHelper getPropertyHelper() {
        return BaseEditorPanel.getPropertyHelper(this.getComponentContext().getDataContext(), this.getProvider());
    }

    protected final DBObjectProvider getProvider() {
        return this.getComponentContext().getProvider();
    }

    protected final DBObject getUpdatedObject() {
        return this.getComponentContext().getUpdatedObject();
    }

    protected final DBObject getOriginalObject() {
        return this.getComponentContext().getOriginalObject();
    }

    public final boolean isSupported() {
        return this.m_isSupported;
    }

    public final ComponentContext getComponentContext() {
        return this.m_componentContext;
    }

    public Component getCellEditorComponent() {
        return this.getActiveComponent();
    }

    private static boolean isDebugDisabled(Component component) {
        return component instanceof JComponent && ((JComponent)component).getClientProperty(DEBUG_DISABLED) != null;
    }

    private static void setDebugEnabled(Component component, JLabel jLabel, boolean bl) {
        component.setEnabled(bl);
        if (jLabel != null) {
            jLabel.setEnabled(bl);
        }
        if (component instanceof JComponent) {
            if (bl) {
                Holder holder = (Holder)((JComponent)component).getClientProperty(DEBUG_DISABLED);
                if (holder != null) {
                    ((JComponent)component).setBorder((Border)holder.get());
                    ((JComponent)component).putClientProperty(DEBUG_DISABLED, null);
                }
            } else {
                ((JComponent)component).putClientProperty(DEBUG_DISABLED, new Holder((Object)((JComponent)component).getBorder()));
                ((JComponent)component).setBorder(BorderFactory.createLineBorder(Color.PINK, 2));
            }
        }
    }

    private static boolean isDebug() {
        return Boolean.valueOf(System.getProperty("ide.db.debugWrappers"));
    }

    public final void setReadOnly(boolean bl) {
        this.m_readOnly = bl;
        this.setUIReadOnly(bl);
    }

    protected void setUIReadOnly(boolean bl) {
    }

    protected void resourceComponent(DBUIResourceHelper dBUIResourceHelper) {
        String string = this.getPropertyName();
        T t = this.getActiveComponent();
        JLabel jLabel = this.getLabel();
        String string2 = this.getPropertyDisplayName();
        if (jLabel == null) {
            if (t instanceof AbstractButton) {
                dBUIResourceHelper.resButton((AbstractButton)t, string2, string);
            } else if (((Component)t).getName() == null) {
                dBUIResourceHelper.setName((Component)t, string);
            }
        } else {
            dBUIResourceHelper.resLabel(jLabel, (Component)t, string2 + ":", string);
        }
    }
}

