/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.mt.util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.adf.share.mt.util.CloudHelper;
import oracle.adfinternal.share.release.Function;
import oracle.adfinternal.share.release.ReleaseAdapter;

public class MultiTenantStorage<T> {
    protected static final Logger logger = Logger.getLogger(MultiTenantStorage.class.getName());
    private final ValueStorage<T> valueStorage;
    private final Function mtsFunc = new Function<Object, Holder<T>>(){

        @Override
        public Holder<T> apply(Object k) {
            return MultiTenantStorage.this.newHolder(null, k);
        }
    };

    public MultiTenantStorage() {
        this.valueStorage = this.initValueStorage();
    }

    protected ValueStorage<T> initValueStorage() {
        return CloudHelper.isMultitenancySupportable() ? new MultiValueStorage() : new SingleValueStorage();
    }

    public T get() {
        return this.valueStorage.getValue(this);
    }

    public T set(T newValue) {
        return this.valueStorage.setValue(newValue, this);
    }

    public T remove() {
        return this.valueStorage.removeValue();
    }

    protected T initialValue() {
        return null;
    }

    protected Holder<T> newHolder(T value, Object key) {
        return logger.isLoggable(Level.FINER) ? new DiagnosticHolder<T>(value, this, key) : new Holder<T>(value, this);
    }

    static interface ValueStorage<T> {
        public T getValue(MultiTenantStorage<T> var1);

        public T setValue(T var1, MultiTenantStorage<T> var2);

        public T removeValue();
    }

    protected static class MultiValueStorage<T>
    implements ValueStorage<T> {
        private static final int INITIAL_HOLDERS_SIZE = 2;
        private ConcurrentHashMap<Object, Holder<T>> mtHolders = new ConcurrentHashMap(2);

        protected MultiValueStorage() {
        }

        @Override
        public T getValue(MultiTenantStorage<T> mts) {
            Object key = this.getStripingKey();
            Holder<T> h = ReleaseAdapter.getInstance().computeIfAbsent(this.mtHolders, key, mts.mtsFunc);
            return h.getValue();
        }

        @Override
        public T setValue(T newValue, MultiTenantStorage<T> mts) {
            Object key = this.getStripingKey();
            Holder<T> h = this.mtHolders.put(key, mts.newHolder(newValue, key));
            return h == null ? null : (T)h.getValue();
        }

        @Override
        public T removeValue() {
            Holder<T> h = this.mtHolders.remove(this.getStripingKey());
            return h == null ? null : (T)h.getValue();
        }

        protected Object getStripingKey() {
            return CloudHelper.getTenantKeyOrThrow();
        }
    }

    protected static final class SingleValueStorage<T>
    implements ValueStorage<T> {
        private volatile Holder<T> holder;
        private static AtomicReferenceFieldUpdater<SingleValueStorage, Holder> holderUpdater = AtomicReferenceFieldUpdater.newUpdater(SingleValueStorage.class, Holder.class, "holder");

        protected SingleValueStorage() {
        }

        @Override
        public T getValue(MultiTenantStorage<T> mts) {
            if (this.holder == null) {
                holderUpdater.compareAndSet(this, null, mts.newHolder(null, null));
            }
            return this.holder != null ? (T)this.holder.getValue() : null;
        }

        @Override
        public T setValue(T newValue, MultiTenantStorage<T> mts) {
            Holder<T> prev = holderUpdater.getAndSet(this, mts.newHolder(newValue, null));
            return prev != null ? (T)prev.getValue() : null;
        }

        @Override
        public T removeValue() {
            Holder prev = holderUpdater.getAndSet(this, null);
            return prev != null ? (T)prev.getValue() : null;
        }
    }

    protected static class DiagnosticHolder<T>
    extends Holder<T> {
        private final Throwable createdBy = new Throwable("Created By");
        private final Object key;
        private T originalValue;

        public DiagnosticHolder(T value, MultiTenantStorage<T> mts, Object key) {
            super(value, mts);
            this.key = key;
            this.originalValue = value;
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("" + this);
            }
        }

        @Override
        public T getValue() {
            Object curKey;
            if (this.originalValue != this.value) {
                if (this.originalValue == null) {
                    this.originalValue = this.value;
                } else {
                    throw new IllegalStateException(new Throwable("Value changed after Holder created, value=" + this.value + ", original=" + this.originalValue, this.createdBy));
                }
            }
            if (this.key != null && !this.key.equals(curKey = this.getStripingKey())) {
                throw new IllegalStateException(new Throwable("Wrong tenant being used, curKey=" + curKey + ", key=" + this.key, this.createdBy));
            }
            return (T)this.value;
        }

        protected Object getStripingKey() {
            return CloudHelper.getTenantKeyOrThrow();
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(super.toString());
            buf.append(", key=");
            buf.append(this.key);
            buf.append("\n");
            for (StackTraceElement elem : this.createdBy.getStackTrace()) {
                buf.append("  ");
                buf.append(elem.toString());
                buf.append("\n");
            }
            return buf.toString();
        }
    }

    protected static class Holder<T> {
        protected final T value;

        public Holder(T value, MultiTenantStorage<T> mts) {
            this.value = value != null ? value : mts.initialValue();
        }

        public T getValue() {
            return this.value;
        }
    }
}

