/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.resource.templates.v2;

import java.io.InputStream;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.TreeReader;
import oracle.dbtools.rt.entity.Entities;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.home.tenants.TenantEntity;
import oracle.dbtools.rt.home.tenants.TenantEntityAccess;
import oracle.dbtools.rt.home.tenants.TenantIdentifier;
import oracle.dbtools.rt.resource.collection.tenants.TenantEntityItemRequestHandler;
import oracle.dbtools.rt.resource.templates.v2.ResourceModule;
import oracle.dbtools.rt.resource.templates.v2.ResourceModuleReader;
import oracle.dbtools.rt.resource.templates.v2.ResourceModules;
import oracle.dbtools.rt.resource.templates.v2.ResourceModulesProvider;
import oracle.dbtools.rt.resource.templates.v2.ResourceTemplatesProfile;
import oracle.dbtools.rt.validation.Validator;
import oracle.dbtools.rt.web.ContentType;
import oracle.dbtools.rt.web.HttpHeader;
import oracle.dbtools.rt.web.ResourceDispatcher;

@Service(provides={ResourceDispatcher.class})
public class ResourceModuleRequestHandler
extends TenantEntityItemRequestHandler<ResourceModule> {
    @Reference
    private ResourceModules modules;
    @Reference
    private ResourceModulesProvider provider;
    @Reference
    private Validator validator;

    public ResourceModuleRequestHandler() {
        super(ResourceTemplatesProfile.URI_TEMPLATES, TenantEntityAccess.TENANT, ResourceTemplatesProfile.MEDIA_TYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void delete(CompoundPrincipal principal, ResourceModule existing) {
        Transaction txn = null;
        try {
            txn = this.provider.newTransaction(principal);
            this.modules.delete(txn, principal, existing.id());
        }
        catch (Throwable throwable) {
            Closeables.close(txn);
            throw throwable;
        }
        Closeables.close((Object)txn);
    }

    @Override
    protected TreeReader<TenantEntity> entityGraphReader() {
        return new ResourceModuleReader(this.validator);
    }

    @Override
    protected ResourceModule existing(CompoundPrincipal principal, TenantIdentifier id) {
        return this.modules.entity(null, principal, id);
    }

    @Override
    protected Entity process(CompoundPrincipal principal, ResourceModule existing) {
        return Entities.entity(this.modules.content(principal, existing), Entities.headers(new CharSequence[]{HttpHeader.CONTENT_TYPE, ResourceTemplatesProfile.MEDIA_TYPE}));
    }

    @Override
    protected void put(CompoundPrincipal principal, ResourceModule existing, ContentType contentType, InputStream content) {
        super.put(principal, existing, contentType, content);
    }
}

