/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.paging;

import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.util.Pair;
import oracle.dbtools.common.util.QueryString;
import oracle.dbtools.rt.entity.Entities;
import oracle.dbtools.rt.entity.EntityHeaders;
import oracle.dbtools.rt.paging.Pagination;
import oracle.dbtools.rt.web.ReTargetingDispatcher;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.Requests;
import oracle.dbtools.rt.web.ResourceDispatcher;

@Service(provides={ResourceDispatcher.class})
public class PagingDispatcher
extends ReTargetingDispatcher<PageTarget> {
    @Override
    protected PageTarget target(RequestEntity request) {
        Pair<QueryString, Long> page;
        if (Requests.isRead(request) && (page = Pagination.paginate(request.path())) != null) {
            String target = ((QueryString)page.first()).toString();
            if (!request.path().equals(target)) {
                return new PageTarget(((QueryString)page.first()).toString(), (Long)page.second());
            }
        }
        return null;
    }

    @Override
    protected EntityHeaders modifyRequestHeaders(PageTarget target, RequestEntity request) {
        return Entities.headers("X-APEX-PAGE-OFFSET", Long.toString(target.pageOffset));
    }

    class PageTarget
    extends ReTargetingDispatcher.Target {
        private final long pageOffset;

        PageTarget(String target, long pageOffset) {
            super(target);
            this.pageOffset = pageOffset;
        }
    }
}

