/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.authentication;

import java.security.Principal;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import oracle.dbtools.auth.principal.PartyPrincipal;
import oracle.dbtools.auth.principal.PartyPrincipals;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.NullOrEmpty;

public abstract class Principals {
    private static final PartyPrincipals PRINCIPALS = PartyPrincipals.instance();

    private Principals() {
    }

    public static Principal[] principals(String userName, String ... roles) {
        PartyPrincipal user = Principals.user(userName);
        return Principals.principals(user, roles);
    }

    public static Principal[] principals(PartyPrincipal user, String ... roles) {
        Iterable<Principal> rolePrincipals = Principals.roles(roles);
        ArrayList<PartyPrincipal> principals = new ArrayList<PartyPrincipal>();
        principals.add(user);
        Iterables.add(principals, rolePrincipals);
        return principals.toArray(new Principal[principals.size()]);
    }

    public static PartyPrincipal role(String role) {
        if (!NullOrEmpty.nullOrEmpty((CharSequence)role)) {
            role = role.trim();
            return PRINCIPALS.role(role);
        }
        return null;
    }

    private static Iterable<Principal> roles(String ... roles) {
        LinkedHashSet<Principal> principals = new LinkedHashSet<Principal>(roles.length);
        for (int i = 0; i < roles.length; ++i) {
            String role = roles[i];
            if (NullOrEmpty.nullOrEmpty((CharSequence)role)) continue;
            principals.add((Principal)Principals.role(role));
        }
        return principals;
    }

    public static PartyPrincipal user(String name) {
        if (!NullOrEmpty.nullOrEmpty((CharSequence)(name = name.trim()))) {
            return PRINCIPALS.endUser(name).build();
        }
        return null;
    }
}

