/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.postgresql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import oracle.dbtools.migration.capture.OnlineCapturer;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.core.ThirdPartyDbProvider;
import oracle.dbtools.migration.workbench.postgresql.PostgreSQLCapturer;

public class PostgreSQLDbProvider
extends ThirdPartyDbProvider {
    private String m_label;
    private PostgreSQLCapturer m_capturer;

    public PostgreSQLDbProvider(Connection connection) {
        super(connection);
    }

    public OnlineCapturer getCapturer(MigrationStorer migrationStorer) {
        if (this.m_capturer == null) {
            this.m_capturer = new PostgreSQLCapturer(migrationStorer, this._conn);
        }
        return this.m_capturer;
    }

    public String getConnectionLabel() {
        if (this.m_label == null) {
            try {
                DatabaseMetaData databaseMetaData = this.getConnection().getMetaData();
                String string = databaseMetaData.getURL();
                String[] stringArray = string.split("/");
                String string2 = databaseMetaData.getUserName();
                String[] stringArray2 = string2.split("@");
                this.m_label = stringArray2[0] + "@" + stringArray[2] + ":" + this.getConnection().getCatalog() + " (" + databaseMetaData.getDatabaseProductName() + ")";
            }
            catch (SQLException sQLException) {
                this.m_label = "PostgreSQL Model";
            }
        }
        return this.m_label;
    }
}

