/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser;

import java.util.TreeMap;
import oracle.arbori.util.Service;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;

public class Substitutions {
    private final String input;
    private Parsed target;
    protected TreeMap<Long, String> substitutions = new TreeMap();

    public String getInput() {
        return this.input;
    }

    public Substitutions(String input) {
        this.input = input;
    }

    public Substitutions(Parsed target) {
        this.target = target;
        this.input = target.getInput();
    }

    public void put(int X, int Y, String replacement) {
        for (long candidate : this.substitutions.keySet()) {
            if ((X != Service.lX(candidate) || Service.lY(candidate) != Y) && (X <= Service.lX(candidate) && Service.lX(candidate) < Y || X < Service.lY(candidate) && Service.lY(candidate) <= Y)) {
                throw new AssertionError((Object)("[" + Service.lX(candidate) + "," + Service.lY(candidate) + ") overlaps with [" + X + "," + Y + ")"));
            }
        }
        this.substitutions.put(Service.lPair(X, Y), replacement);
    }

    public String get(int X, int Y) {
        return this.substitutions.get(Service.lPair(X, Y));
    }

    public void replace(int X, int Y, String replacement) {
        this.put(X, Y, replacement);
    }

    public String get(ParseNode node) {
        if (this.target == null) {
            throw new AssertionError((Object)"target == null");
        }
        return this.get(this.target.getSrc().get((int)node.from).begin, this.target.getSrc().get((int)(node.to - 1)).end);
    }

    public void put(ParseNode node, String replacement, String annotation) {
        if (this.target == null) {
            throw new AssertionError((Object)"target == null");
        }
        String was = this.input.substring(this.target.getSrc().get((int)node.from).begin, this.target.getSrc().get((int)(node.to - 1)).end);
        Object comment = "";
        if (annotation != null && !"".equals(annotation)) {
            comment = "/* " + annotation + was + " */";
        }
        this.put(this.target.getSrc().get((int)node.from).begin, this.target.getSrc().get((int)(node.to - 1)).end, replacement + (String)comment);
    }

    public void put(ParseNode node, String replacement) {
        this.put(node, replacement, "");
    }

    public void putWcomment(ParseNode node, String replacement) {
        this.put(node, replacement, "was:");
    }

    public void delete(ParseNode node) {
        this.put(node, "", "");
    }

    public void deleteWcomment(ParseNode node) {
        this.put(node, "", "deleted: ");
    }

    public void append(ParseNode node, String appendix) {
        this.put(node, "/*added:*/" + appendix);
    }

    public void replace(ParseNode node, String replacement) {
        this.put(node, replacement);
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        int lastPos = 0;
        for (long key : this.substitutions.keySet()) {
            int begin = Service.lX(key);
            int end = Service.lY(key);
            if (lastPos < begin) {
                ret.append(this.input.substring(lastPos, begin));
            }
            ret.append("\n---\n");
            ret.append(this.input.substring(begin, end));
            ret.append("\n--->>>\n");
            ret.append(this.substitutions.get(key));
            ret.append("\n---\n");
            lastPos = end;
        }
        ret.append(this.input.substring(lastPos));
        return ret.toString();
    }

    public String transformInput() {
        StringBuilder ret = new StringBuilder();
        int lastPos = 0;
        for (long key : this.substitutions.keySet()) {
            int begin = Service.lX(key);
            int end = Service.lY(key);
            if (lastPos < begin) {
                ret.append(this.input.substring(lastPos, begin));
            }
            ret.append(this.substitutions.get(key));
            lastPos = end;
        }
        ret.append(this.input.substring(lastPos));
        return ret.toString();
    }

    public boolean equals(Object obj) {
        String match;
        Substitutions cmp = (Substitutions)obj;
        for (Long key : this.substitutions.keySet()) {
            match = cmp.substitutions.get(key);
            if (match == null) {
                return false;
            }
            if (!match.equals(this.substitutions.get(key))) continue;
            return false;
        }
        for (Long key : cmp.substitutions.keySet()) {
            match = this.substitutions.get(key);
            if (match != null) continue;
            return false;
        }
        return true;
    }

    public String diff(Object obj) {
        String match;
        Substitutions cmp = (Substitutions)obj;
        for (Long key : this.substitutions.keySet()) {
            match = cmp.substitutions.get(key);
            if (match == null) {
                return "no match for " + Service.lX(key) + "," + Service.lY(key) + " `" + this.substitutions.get(key) + "`";
            }
            if (!match.equals(this.substitutions.get(key))) continue;
            return Service.lX(key) + "," + Service.lY(key) + " `" + this.substitutions.get(key) + "` != `" + match + "`";
        }
        for (Long key : cmp.substitutions.keySet()) {
            match = this.substitutions.get(key);
            if (match != null) continue;
            return "no match for " + Service.lX(key) + "," + Service.lY(key) + " `" + cmp.substitutions.get(key) + "`";
        }
        return "=";
    }

    public String[] lines() {
        String[] ret = new String[this.substitutions.size()];
        int pos = -1;
        for (long key : this.substitutions.keySet()) {
            ret[++pos] = Service.lX(key) + "," + Service.lY(key) + " `" + this.substitutions.get(key) + "`";
        }
        return ret;
    }

    public int origOffset(int pos) {
        int diff = 0;
        for (long key : this.substitutions.keySet()) {
            int begin = Service.lX(key);
            int end = Service.lY(key);
            if (pos + diff <= begin) break;
            int len = this.substitutions.get(key).length();
            if (begin - diff <= pos && pos < begin - diff + len) {
                int x = pos - (begin - diff);
                diff -= x;
                break;
            }
            diff += end - begin - len;
        }
        return pos + diff;
    }

    public static int levenshteinDistance(String x, String y) {
        if (x.length() == 0) {
            return y.length();
        }
        if (y.length() == 0) {
            return x.length();
        }
        String x1 = x.substring(1);
        String y1 = y.substring(1);
        if (x.charAt(0) == y.charAt(0)) {
            return Substitutions.levenshteinDistance(x1, y1);
        }
        int a = Substitutions.levenshteinDistance(x1, y);
        if (a == 0) {
            return 1;
        }
        int b = Substitutions.levenshteinDistance(x, y1);
        if (b == 0) {
            return 1;
        }
        int c = Substitutions.levenshteinDistance(x1, y1);
        return 1 + Integer.min(a, Integer.min(b, c));
    }

    public static void main(String[] args) {
        Substitutions repl = new Substitutions("0123456789012345");
        repl.put(1, 2, "[1,2)");
        repl.put(11, 12, "[11,12)");
        System.out.println("**** repl.toString():");
        System.out.println(repl.toString());
        System.out.println("**** repl.transformInput():");
        System.out.println(repl.transformInput());
        System.out.println("0123456789012345678901234");
        System.out.println("**** repl.origOffset(1)=" + repl.origOffset(1));
        System.out.println("**** repl.origOffset(5)=" + repl.origOffset(5));
        System.out.println("**** repl.origOffset(10)=" + repl.origOffset(10));
        System.out.println("**** repl.origOffset(14)=" + repl.origOffset(14));
        System.out.println("**** repl.origOffset(19)=" + repl.origOffset(19));
        System.out.println("**** repl.origOffset(23)=" + repl.origOffset(23));
        long t1 = System.currentTimeMillis();
        Object x = "9012345";
        String y = "234567890[11,12)2345";
        System.out.println("levenshteinDistance(\"" + (String)x + "\", \"" + y + "\")=" + Substitutions.levenshteinDistance((String)x, y));
        System.out.println(System.currentTimeMillis() - t1);
        t1 = System.currentTimeMillis();
        x = "678" + (String)x;
        System.out.println("levenshteinDistance(\"" + (String)x + "\", \"" + y + "\")=" + Substitutions.levenshteinDistance((String)x, y));
        System.out.println(System.currentTimeMillis() - t1);
    }
}

