/*
 * Decompiled with CFR 0.152.
 */
package oracle.arbori.util;

import java.util.Optional;
import java.util.function.IntConsumer;

public class ParseInt {
    public static boolean isInt(String text) {
        if (text == null || text.isEmpty()) {
            return false;
        }
        char first = text.charAt(0);
        if (first == '+' || first == '-' || Character.isDigit((int)first)) {
            return text.chars().skip(1L).allMatch(Character::isDigit);
        }
        return false;
    }

    public static Optional<Integer> parseInt(String text) {
        if (ParseInt.isInt(text)) {
            int value = Integer.parseInt(text, 0, text.length(), 10);
            return Optional.of(value);
        }
        return Optional.empty();
    }

    public static Optional<Integer> whenInt(String text, IntConsumer action) {
        Optional<Integer> value = ParseInt.parseInt(text);
        if (value.isPresent()) {
            action.accept(value.get());
        }
        return value;
    }
}

