/*
 * Decompiled with CFR 0.152.
 */
package ice.mozilla.javascript;

import ice.mozilla.javascript.Context;
import ice.mozilla.javascript.Function;
import ice.mozilla.javascript.IdFunction;
import ice.mozilla.javascript.IdScriptable;
import ice.mozilla.javascript.JavaScriptException;
import ice.mozilla.javascript.ObjToIntMap;
import ice.mozilla.javascript.PropertyException;
import ice.mozilla.javascript.ScriptRuntime;
import ice.mozilla.javascript.Scriptable;
import ice.mozilla.javascript.ScriptableObject;
import ice.mozilla.javascript.Undefined;

public class NativeObject
extends IdScriptable {
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_toLocaleString = 3;
    private static final int Id_valueOf = 4;
    private static final int Id_hasOwnProperty = 5;
    private static final int Id_propertyIsEnumerable = 6;
    private static final int Id_isPrototypeOf = 7;
    private static final int MAX_PROTOTYPE_ID = 7;
    private boolean prototypeFlag;

    public static void init(Context cx, Scriptable scope, boolean sealed) {
        NativeObject obj = new NativeObject();
        obj.prototypeFlag = true;
        obj.addAsPrototype(7, cx, scope, sealed);
    }

    public String getClassName() {
        return "Object";
    }

    public int methodArity(int methodId) {
        if (this.prototypeFlag) {
            switch (methodId) {
                case 1: {
                    return 1;
                }
                case 2: {
                    return 0;
                }
                case 3: {
                    return 0;
                }
                case 4: {
                    return 0;
                }
                case 5: {
                    return 1;
                }
                case 6: {
                    return 1;
                }
                case 7: {
                    return 1;
                }
            }
        }
        return super.methodArity(methodId);
    }

    public Object execMethod(int methodId, IdFunction f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        if (this.prototypeFlag) {
            switch (methodId) {
                case 1: {
                    return NativeObject.jsConstructor(cx, args, f, thisObj == null);
                }
                case 2: {
                    return NativeObject.js_toString(cx, thisObj);
                }
                case 3: {
                    return NativeObject.js_toLocaleString(cx, thisObj);
                }
                case 4: {
                    return NativeObject.js_valueOf(thisObj);
                }
                case 5: {
                    return NativeObject.js_hasOwnProperty(thisObj, args);
                }
                case 6: {
                    return NativeObject.js_propertyIsEnumerable(cx, thisObj, args);
                }
                case 7: {
                    return NativeObject.js_isPrototypeOf(cx, thisObj, args);
                }
            }
        }
        return super.execMethod(methodId, f, cx, scope, thisObj, args);
    }

    private static Object jsConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) throws JavaScriptException {
        if (!inNewExpr) {
            return ctorObj.construct(cx, ctorObj.getParentScope(), args);
        }
        if (args.length == 0 || args[0] == null || args[0] == Undefined.instance) {
            return new NativeObject();
        }
        return ScriptRuntime.toObject(cx, ctorObj.getParentScope(), args[0]);
    }

    public String toString() {
        Context cx = Context.getCurrentContext();
        if (cx != null) {
            return NativeObject.js_toString(cx, this);
        }
        return "[object " + this.getClassName() + "]";
    }

    private static String js_toString(Context cx, Scriptable thisObj) {
        if (cx.hasFeature(4)) {
            return NativeObject.toSource(cx, thisObj);
        }
        return "[object " + thisObj.getClassName() + "]";
    }

    private static String js_toLocaleString(Context cx, Scriptable thisObj) {
        return NativeObject.js_toString(cx, thisObj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String toSource(Context cx, Scriptable thisObj) {
        boolean iterating;
        boolean toplevel;
        StringBuffer result = new StringBuffer(256);
        result.append('{');
        if (cx.iterating == null) {
            toplevel = true;
            iterating = false;
            cx.iterating = new ObjToIntMap(31);
        } else {
            toplevel = false;
            iterating = cx.iterating.has(thisObj);
        }
        try {
            if (!iterating) {
                cx.iterating.put(thisObj, 0);
                Object[] ids = thisObj.getIds();
                for (int i = 0; i < ids.length; ++i) {
                    Object p;
                    if (i > 0) {
                        result.append(", ");
                    }
                    Object id = ids[i];
                    result.append(id);
                    result.append(':');
                    Object object = p = id instanceof String ? thisObj.get((String)id, thisObj) : thisObj.get((Integer)id, thisObj);
                    if (p instanceof String) {
                        result.append('\"');
                        result.append(ScriptRuntime.escapeString((String)p));
                        result.append('\"');
                        continue;
                    }
                    result.append(ScriptRuntime.toString(p));
                }
            }
        }
        finally {
            if (toplevel) {
                cx.iterating = null;
            }
        }
        result.append('}');
        return result.toString();
    }

    private static Object js_valueOf(Scriptable thisObj) {
        return thisObj;
    }

    private static Object js_hasOwnProperty(Scriptable thisObj, Object[] args) {
        if (args.length != 0 && thisObj.has(ScriptRuntime.toString(args[0]), thisObj)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private static Object js_propertyIsEnumerable(Context cx, Scriptable thisObj, Object[] args) {
        try {
            int a;
            String name;
            if (args.length != 0 && thisObj.has(name = ScriptRuntime.toString(args[0]), thisObj) && ((a = ((ScriptableObject)thisObj).getAttributes(name, thisObj)) & 2) == 0) {
                return Boolean.TRUE;
            }
        }
        catch (PropertyException x) {
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return Boolean.FALSE;
    }

    private static Object js_isPrototypeOf(Context cx, Scriptable thisObj, Object[] args) {
        if (args.length != 0 && args[0] instanceof Scriptable) {
            Scriptable v = (Scriptable)args[0];
            do {
                if ((v = v.getPrototype()) != thisObj) continue;
                return Boolean.TRUE;
            } while (v != null);
        }
        return Boolean.FALSE;
    }

    protected String getIdName(int id) {
        if (this.prototypeFlag) {
            switch (id) {
                case 1: {
                    return "constructor";
                }
                case 2: {
                    return "toString";
                }
                case 3: {
                    return "toLocaleString";
                }
                case 4: {
                    return "valueOf";
                }
                case 5: {
                    return "hasOwnProperty";
                }
                case 6: {
                    return "propertyIsEnumerable";
                }
                case 7: {
                    return "isPrototypeOf";
                }
            }
        }
        return null;
    }

    protected int mapNameToId(String s) {
        if (!this.prototypeFlag) {
            return 0;
        }
        int id = 0;
        String X = null;
        switch (s.length()) {
            case 7: {
                X = "valueOf";
                id = 4;
                break;
            }
            case 8: {
                X = "toString";
                id = 2;
                break;
            }
            case 11: {
                X = "constructor";
                id = 1;
                break;
            }
            case 13: {
                X = "isPrototypeOf";
                id = 7;
                break;
            }
            case 14: {
                char c = s.charAt(0);
                if (c == 'h') {
                    X = "hasOwnProperty";
                    id = 5;
                    break;
                }
                if (c != 't') break;
                X = "toLocaleString";
                id = 3;
                break;
            }
            case 20: {
                X = "propertyIsEnumerable";
                id = 6;
                break;
            }
        }
        if (X != null && X != s && !X.equals(s)) {
            id = 0;
        }
        return id;
    }
}

