/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.common.repeatinterval.clause;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.dbtools.scheduler.SchedulerArb;
import oracle.dbtools.scheduler.panels.common.repeatinterval.clause.AbstractRepeatIntervalClause;
import oracle.dbtools.scheduler.panels.common.repeatinterval.clause.ClauseSyntaxHandler;
import oracle.dbtools.scheduler.panels.common.repeatinterval.component.PropertyBasedPanel;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.ClauseType;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.RepeatIntervalModel;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.SortedClauseModel;

public class BySubPeriodClause
extends AbstractRepeatIntervalClause<Integer, SortedClauseModel<Integer>> {
    public BySubPeriodClause(RepeatIntervalModel repeatIntervalModel) {
        this(Integer.class, repeatIntervalModel);
    }

    protected BySubPeriodClause(SortedClauseModel<Integer> sortedClauseModel) {
        super(sortedClauseModel);
    }

    protected BySubPeriodClause(Class<Integer> clazz, RepeatIntervalModel repeatIntervalModel) {
        this(new SortedClauseModel<Integer>(clazz, ClauseType.BYSUBPERIOD, repeatIntervalModel));
    }

    @Override
    public JPanel getPanel() {
        return this.getPanel(null);
    }

    @Override
    public JPanel getPanel(Properties properties) {
        return new Panel(properties);
    }

    @Override
    public ClauseSyntaxHandler getSyntaxHandler() {
        return new SyntaxHandler();
    }

    protected class Panel
    extends PropertyBasedPanel {
        protected int previousSpinnerValue;
        protected GridBagLayout gridBagLayout1;
        protected JSpinner numberSpinner;
        protected SpinnerNumberModel numberSpinnerModel;
        protected JButton addButton;
        protected JButton removeButton;
        protected JButton clearButton;

        public Panel(Properties properties) {
            super(properties);
            this.previousSpinnerValue = 1;
            this.gridBagLayout1 = new GridBagLayout();
            this.numberSpinner = new JSpinner();
            this.numberSpinnerModel = new SpinnerNumberModel(this.previousSpinnerValue, 1, 100, 1);
            this.addButton = new JButton();
            this.removeButton = new JButton();
            this.clearButton = new JButton();
            try {
                this.jbInit();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        protected void jbInit() throws Exception {
            this.setLayout(this.gridBagLayout1);
            this.numberSpinner.setMinimumSize(new Dimension(64, 19));
            this.numberSpinner.setPreferredSize(new Dimension(64, 19));
            this.numberSpinner.setModel(this.numberSpinnerModel);
            this.numberSpinnerModel.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (Panel.this.numberSpinnerModel.getNumber().intValue() == 0) {
                        if (Panel.this.previousSpinnerValue > 0) {
                            Panel.this.numberSpinnerModel.setValue(-1);
                        } else {
                            Panel.this.numberSpinnerModel.setValue(1);
                        }
                    }
                    Panel.this.previousSpinnerValue = Panel.this.numberSpinnerModel.getNumber().intValue();
                }
            });
            this.addButton.setText(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_ADD"));
            this.addButton.setActionCommand("Add");
            this.addButton.setToolTipText(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_ADD_TOOLTIP"));
            this.addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Panel.this.addButton_actionPerformed(actionEvent);
                }
            });
            this.addButton.setMargin(new Insets(0, 0, 0, 0));
            this.removeButton.setText(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_REMOVE"));
            this.removeButton.setActionCommand("Del");
            this.removeButton.setToolTipText(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_REMOVE_TOOLTIP"));
            this.removeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Panel.this.removeButton_actionPerformed(actionEvent);
                }
            });
            this.removeButton.setMargin(new Insets(0, 0, 0, 0));
            this.clearButton.setText(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_CLEAR_ALL"));
            this.clearButton.setActionCommand("Clear");
            this.clearButton.setToolTipText(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_CLEAR_ALL_TOOLTIP"));
            this.clearButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Panel.this.clearButton_actionPerformed(actionEvent);
                }
            });
            this.clearButton.setMargin(new Insets(0, 0, 0, 0));
            this.add((Component)this.numberSpinner, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 4, 4, 4), 0, 0));
            this.add((Component)this.addButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 4, 4, 4), 0, 0));
            this.add((Component)this.removeButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 4, 4, 4), 0, 0));
            this.add((Component)this.clearButton, new GridBagConstraints(3, 1, 1, 1, 1.0, 1.0, 18, 0, new Insets(4, 4, 4, 4), 0, 0));
        }

        protected void addButton_actionPerformed(ActionEvent actionEvent) {
            Integer n = this.numberSpinnerModel.getNumber().intValue();
            ((SortedClauseModel)BySubPeriodClause.this.clauseModel).add(n);
        }

        protected void removeButton_actionPerformed(ActionEvent actionEvent) {
            Integer n = this.numberSpinnerModel.getNumber().intValue();
            ((SortedClauseModel)BySubPeriodClause.this.clauseModel).remove(n);
        }

        protected void clearButton_actionPerformed(ActionEvent actionEvent) {
            ((SortedClauseModel)BySubPeriodClause.this.clauseModel).clear();
        }
    }

    protected class SyntaxHandler
    extends AbstractRepeatIntervalClause.AbstractSyntaxHandler {
        protected SyntaxHandler() {
        }

        @Override
        public void initialise(String string) {
            if (string != null) {
                String[] stringArray;
                for (String string2 : stringArray = string.split(",")) {
                    string2 = string2.trim();
                    try {
                        ((SortedClauseModel)BySubPeriodClause.this.clauseModel).add(Integer.valueOf(string2));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

