/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.editors.graphical.xml;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.HashMap;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.scheduler.SchedulerArb;
import oracle.dbtools.scheduler.editors.graphical.controller.GraphicalEditorAbstractIdeController;
import oracle.dbtools.scheduler.editors.graphical.controller.GraphicalEditorController;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineNode;
import oracle.dbtools.scheduler.generator.DBMSSchedulerCodeGenerator;
import oracle.ide.Context;
import oracle.ide.controller.IdeAction;

public class SchedulerEnableDisableActionController
extends GraphicalEditorAbstractIdeController {
    DBObject dbObject;
    String table;
    String colName;
    String owner;
    String name;
    Boolean isEnabled;

    public boolean handleEvent(IdeAction ideAction, Context context) {
        GraphicalEditorController graphicalEditorController = this.getGraphicalEditorController(context);
        GraphEngineNode graphEngineNode = (GraphEngineNode)this.getGraphEngineObject(context);
        DBObject dBObject = this.getDBObject(context);
        if (graphicalEditorController != null) {
            try {
                this.dbObject = dBObject;
                this.owner = graphEngineNode.getOwner();
                this.name = graphEngineNode.getName();
                DatabaseQueryTask databaseQueryTask = this.isEnabled != false ? new DisableTask() : new EnableTask();
                RaptorTaskManager.getInstance().addTask((RaptorTask)databaseQueryTask);
            }
            catch (Throwable throwable) {
                ideAction.setEnabled(false);
            }
        }
        return true;
    }

    public boolean update(IdeAction ideAction, Context context) {
        GraphicalEditorController graphicalEditorController = this.getGraphicalEditorController(context);
        GraphEngineNode graphEngineNode = (GraphEngineNode)this.getGraphEngineObject(context);
        DBObject dBObject = this.getDBObject(context);
        if (graphEngineNode == null || graphEngineNode.getType() == null) {
            int n = 1;
            ++n;
        }
        String string = graphEngineNode.getType().getTypeId();
        ideAction.setEnabled(false);
        if (graphicalEditorController != null && graphEngineNode != null && string != null) {
            String string2 = null;
            String string3 = null;
            if (string.equals("SCHCHAIN")) {
                string2 = "SYS.ALL_SCHEDULER_CHAINS";
                string3 = "CHAIN_NAME";
            } else if (string.equals("SCHJOB") || string.equals("SCHNEWJOB")) {
                string2 = "SYS.ALL_SCHEDULER_JOBS";
                string3 = "JOB_NAME";
            } else if (string.equals("SCHPROGRAM")) {
                string2 = "SYS.ALL_SCHEDULER_PROGRAMS";
                string3 = "PROGRAM_NAME";
            } else if (string.equals("SCHWINDOW")) {
                string2 = "SYS.ALL_SCHEDULER_WINDOWS";
                string3 = "WINDOW_NAME";
            } else if (string.equals("SCHWINDOWGROUP")) {
                string2 = "SYS.ALL_SCHEDULER_WINDOW_GROUPS";
                string3 = "WINDOW_GROUP_NAME";
            } else if (string.equals("SCHFILEWATCHER")) {
                string2 = "SYS.ALL_SCHEDULER_FILE_WATCHERS";
                string3 = "FILE_WATCHER_NAME";
            }
            if (dBObject != null && string2 != null) {
                try {
                    this.dbObject = dBObject;
                    this.table = string2;
                    this.colName = string3;
                    this.owner = graphEngineNode.getOwner();
                    this.name = graphEngineNode.getName();
                    GetEnabledTask getEnabledTask = new GetEnabledTask();
                    RaptorTaskManager.getInstance().addTask((RaptorTask)getEnabledTask);
                    this.isEnabled = (Boolean)getEnabledTask.getResult();
                    if (this.isEnabled.booleanValue()) {
                        ideAction.setName(SchedulerArb.getString("SCHEDULER_POPUP_DISABLE"));
                    } else {
                        ideAction.setName(SchedulerArb.getString("SCHEDULER_POPUP_ENABLE"));
                    }
                    ideAction.setState(this.isEnabled.booleanValue());
                    ideAction.setEnabled(true);
                }
                catch (Throwable throwable) {
                    ideAction.setEnabled(false);
                }
            }
        }
        return true;
    }

    private class DisableTask
    extends DatabaseQueryTask<Boolean> {
        public DisableTask() {
            super("DisableTask", IRaptorTaskRunMode.NO_GUI, false, false);
        }

        public String getConnectionName() {
            return this.getDBObject().getConnectionName();
        }

        public String getQuery() {
            DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("table", SchedulerEnableDisableActionController.this.table);
            hashMap.put("namecol", SchedulerEnableDisableActionController.this.colName);
            hashMap.put("owner", SchedulerEnableDisableActionController.this.owner);
            hashMap.put("name", SchedulerEnableDisableActionController.this.name);
            String string = dBMSSchedulerCodeGenerator.generate(this.getDBObject().getDBVersion(), "DISABLE", hashMap);
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doWork() throws TaskException {
            Boolean bl = null;
            Connection connection = this.getDBObject().getConnection();
            LockManager.lock((Connection)connection);
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                dBUtil.execute(this.getQuery());
            }
            finally {
                LockManager.unlock((Connection)connection);
            }
            return bl;
        }

        public DBObject getDBObject() {
            return SchedulerEnableDisableActionController.this.dbObject;
        }
    }

    private class EnableTask
    extends DatabaseQueryTask<Boolean> {
        public EnableTask() {
            super("EnableTask", IRaptorTaskRunMode.NO_GUI, false, false);
        }

        public String getConnectionName() {
            return this.getDBObject().getConnectionName();
        }

        public String getQuery() {
            DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("table", SchedulerEnableDisableActionController.this.table);
            hashMap.put("namecol", SchedulerEnableDisableActionController.this.colName);
            hashMap.put("owner", SchedulerEnableDisableActionController.this.owner);
            hashMap.put("name", SchedulerEnableDisableActionController.this.name);
            String string = dBMSSchedulerCodeGenerator.generate(this.getDBObject().getDBVersion(), "ENABLE", hashMap);
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doWork() throws TaskException {
            Boolean bl = null;
            Connection connection = this.getDBObject().getConnection();
            LockManager.lock((Connection)connection);
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                dBUtil.execute(this.getQuery());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            finally {
                LockManager.unlock((Connection)connection);
            }
            return bl;
        }

        public DBObject getDBObject() {
            return SchedulerEnableDisableActionController.this.dbObject;
        }
    }

    private class GetEnabledTask
    extends DatabaseQueryTask<Boolean> {
        public GetEnabledTask() {
            super("GetEnabledTask", IRaptorTaskRunMode.NO_GUI, false, false);
        }

        public String getConnectionName() {
            return this.getDBObject().getConnectionName();
        }

        public String getQuery() {
            DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("table", SchedulerEnableDisableActionController.this.table);
            hashMap.put("namecol", SchedulerEnableDisableActionController.this.colName);
            hashMap.put("owner", SchedulerEnableDisableActionController.this.owner);
            hashMap.put("name", SchedulerEnableDisableActionController.this.name);
            String string = dBMSSchedulerCodeGenerator.generate(this.getDBObject().getDBVersion(), "GET_ENABLED", hashMap);
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doWork() throws TaskException {
            Boolean bl = null;
            Connection connection = this.getDBObject().getConnection();
            LockManager.lock((Connection)connection);
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                ResultSet resultSet = dBUtil.executeOracleQuery(this.getQuery(), null);
                try {
                    if (resultSet.next()) {
                        String string = resultSet.getString("ENABLED");
                        bl = string.equalsIgnoreCase("true");
                    }
                }
                finally {
                    DBUtil.closeResultSet((ResultSet)resultSet);
                }
            }
            catch (Throwable throwable) {
                throw new TaskException(throwable);
            }
            finally {
                LockManager.unlock((Connection)connection);
            }
            return bl;
        }

        public DBObject getDBObject() {
            return SchedulerEnableDisableActionController.this.dbObject;
        }
    }
}

