/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.syntax;

import com.adbs.ast.AstNode;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.SQLBuilder;
import com.adbs.ast.SQLBuilderSelectFormat;
import com.adbs.utils.Str;

public class OracleSQLSampleClause
extends AstNode {
    public boolean block;
    public String percent;
    public String seed;

    public OracleSQLSampleClause(BaseSQLContext sqlContext) {
        super(sqlContext);
    }

    @Override
    public void assign(Object source) {
        super.assign(source);
        if (source instanceof OracleSQLSampleClause) {
            this.block = ((OracleSQLSampleClause)source).block;
            this.percent = ((OracleSQLSampleClause)source).percent;
            this.seed = ((OracleSQLSampleClause)source).seed;
        }
    }

    @Override
    public void buildSQLDirect(SQLBuilder builder, SQLBuilderSelectFormat format) {
        builder.writeKeyword("Sample");
        if (this.block) {
            builder.space();
            builder.writeKeyword("Block");
        }
        builder.space();
        builder.writeSymbol("(");
        builder.writeNumber(this.percent);
        builder.writeSymbol(")");
        if (!Str.IsNullOrEmpty(this.seed)) {
            builder.space();
            builder.writeKeyword("Seed");
            builder.space();
            builder.writeSymbol("(");
            builder.writeNumber(this.seed);
            builder.writeSymbol(")");
        }
    }
}

